/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.tsp.TSPValidationException;

public class TSPUtil {
    public static void validateCertificate(X509Certificate x509Certificate) throws TSPValidationException {
        if (x509Certificate.getVersion() != 3) {
            throw new IllegalArgumentException("Certificate must have an ExtendedKeyUsage extension.");
        }
        byte[] byArray = x509Certificate.getExtensionValue(X509Extensions.ExtendedKeyUsage.getId());
        if (byArray == null) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension.");
        }
        if (!x509Certificate.getCriticalExtensionOIDs().contains(X509Extensions.ExtendedKeyUsage.getId())) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension marked as critical.");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        try {
            aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((ASN1OctetString)aSN1InputStream.readObject()).getOctets()));
            ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)aSN1InputStream.readObject());
            if (!extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_timeStamping) || extendedKeyUsage.size() != 1) {
                throw new TSPValidationException("ExtendedKeyUsage not solely time stamping.");
            }
        }
        catch (IOException iOException) {
            throw new TSPValidationException("cannot process ExtendedKeyUsage extension");
        }
    }
}

