/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x9.X9FieldElement;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECCurve;

public class X9Curve
extends ASN1Encodable
implements X9ObjectIdentifiers {
    private ECCurve curve;
    private byte[] seed;

    public X9Curve(X9FieldID x9FieldID, ASN1Sequence aSN1Sequence) {
        if (!x9FieldID.getIdentifier().equals(X9ObjectIdentifiers.prime_field)) {
            throw new RuntimeException("not implemented");
        }
        BigInteger bigInteger = ((DERInteger)x9FieldID.getParameters()).getValue();
        X9FieldElement x9FieldElement = new X9FieldElement(true, bigInteger, (ASN1OctetString)aSN1Sequence.getObjectAt(0));
        X9FieldElement x9FieldElement2 = new X9FieldElement(true, bigInteger, (ASN1OctetString)aSN1Sequence.getObjectAt(1));
        this.curve = new ECCurve.Fp(bigInteger, x9FieldElement.getValue().toBigInteger(), x9FieldElement2.getValue().toBigInteger());
        if (aSN1Sequence.size() == 3) {
            this.seed = ((DERBitString)aSN1Sequence.getObjectAt(2)).getBytes();
        }
    }

    public X9Curve(ECCurve eCCurve) {
        this.curve = eCCurve;
        this.seed = null;
    }

    public X9Curve(ECCurve eCCurve, byte[] byArray) {
        this.curve = eCCurve;
        this.seed = byArray;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new X9FieldElement(this.curve.getA()).getDERObject());
        aSN1EncodableVector.add(new X9FieldElement(this.curve.getB()).getDERObject());
        if (this.seed != null) {
            aSN1EncodableVector.add(new DERBitString(this.seed));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

