/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.params.GOST3410Parameters;
import org.bouncycastle.crypto.params.GOST3410ValidationParameters;

public class GOST3410ParametersGenerator {
    private int size;
    private int typeproc;
    private SecureRandom init_random;
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private static BigInteger TWO = BigInteger.valueOf(2L);

    public GOST3410Parameters generateParameters() {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        if (this.typeproc == 1) {
            int n = this.init_random.nextInt();
            int n2 = this.init_random.nextInt();
            switch (this.size) {
                case 512: {
                    this.procedure_A(n, n2, bigIntegerArray, 512);
                    break;
                }
                case 1024: {
                    this.procedure_B(n, n2, bigIntegerArray);
                    break;
                }
                default: {
                    System.out.println("Ooops! key size 512 or 1024 bit.");
                    return null;
                }
            }
            bigInteger2 = bigIntegerArray[0];
            bigInteger = bigIntegerArray[1];
            bigInteger3 = this.procedure_C(bigInteger2, bigInteger);
            return new GOST3410Parameters(bigInteger2, bigInteger, bigInteger3, new GOST3410ValidationParameters(n, n2));
        }
        long l = this.init_random.nextLong();
        long l2 = this.init_random.nextLong();
        switch (this.size) {
            case 512: {
                this.procedure_Aa(l, l2, bigIntegerArray, 512);
                break;
            }
            case 1024: {
                this.procedure_Bb(l, l2, bigIntegerArray);
                break;
            }
            default: {
                System.out.println("Ooops! key size 512 or 1024 bit.");
                return null;
            }
        }
        bigInteger2 = bigIntegerArray[0];
        bigInteger = bigIntegerArray[1];
        bigInteger3 = this.procedure_C(bigInteger2, bigInteger);
        return new GOST3410Parameters(bigInteger2, bigInteger, bigInteger3, new GOST3410ValidationParameters(l, l2));
    }

    public void init(int n, int n2, SecureRandom secureRandom) {
        this.size = n;
        this.typeproc = n2;
        this.init_random = secureRandom;
    }

    private int procedure_A(int n, int n2, BigInteger[] bigIntegerArray, int n3) {
        Object[] objectArray;
        while (n < 0 || n > 65536) {
            n = this.init_random.nextInt() / 32768;
        }
        while (n2 < 0 || n2 > 65536 || n2 / 2 == 0) {
            n2 = this.init_random.nextInt() / 32768 + 1;
        }
        BigInteger bigInteger = new BigInteger(Integer.toString(n2));
        BigInteger bigInteger2 = new BigInteger("19381");
        BigInteger[] bigIntegerArray2 = new BigInteger[]{new BigInteger(Integer.toString(n))};
        int[] nArray = new int[]{n3};
        int n4 = 0;
        int n5 = 0;
        while (nArray[n5] >= 17) {
            objectArray = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, objectArray, 0, nArray.length);
            nArray = new int[objectArray.length];
            System.arraycopy(objectArray, 0, nArray, 0, objectArray.length);
            nArray[n5 + 1] = nArray[n5] / 2;
            n4 = n5 + 1;
            ++n5;
        }
        objectArray = new BigInteger[n4 + 1];
        objectArray[n4] = new BigInteger("8003", 16);
        int n6 = n4 - 1;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = nArray[n6] / 16;
            block4: while (true) {
                BigInteger[] bigIntegerArray3 = new BigInteger[bigIntegerArray2.length];
                System.arraycopy(bigIntegerArray2, 0, bigIntegerArray3, 0, bigIntegerArray2.length);
                bigIntegerArray2 = new BigInteger[n8 + 1];
                System.arraycopy(bigIntegerArray3, 0, bigIntegerArray2, 0, bigIntegerArray3.length);
                int n9 = 0;
                while (n9 < n8) {
                    bigIntegerArray2[n9 + 1] = bigIntegerArray2[n9].multiply(bigInteger2).add(bigInteger).mod(TWO.pow(16));
                    ++n9;
                }
                BigInteger bigInteger3 = new BigInteger("0");
                int n10 = 0;
                while (n10 < n8) {
                    bigInteger3 = bigInteger3.add(bigIntegerArray2[n10].multiply(TWO.pow(16 * n10)));
                    ++n10;
                }
                bigIntegerArray2[0] = bigIntegerArray2[n8];
                BigInteger bigInteger4 = TWO.pow(nArray[n6] - 1).divide(objectArray[n6 + 1]).add(TWO.pow(nArray[n6] - 1).multiply(bigInteger3).divide(objectArray[n6 + 1].multiply(TWO.pow(16 * n8))));
                if (bigInteger4.mod(TWO).compareTo(ONE) == 0) {
                    bigInteger4 = bigInteger4.add(ONE);
                }
                int n11 = 0;
                while (true) {
                    objectArray[n6] = objectArray[n6 + 1].multiply(bigInteger4.add(BigInteger.valueOf(n11))).add(ONE);
                    if (objectArray[n6].compareTo(TWO.pow(nArray[n6])) == 1) continue block4;
                    if (TWO.modPow(objectArray[n6 + 1].multiply(bigInteger4.add(BigInteger.valueOf(n11))), objectArray[n6]).compareTo(ONE) == 0 && TWO.modPow(bigInteger4.add(BigInteger.valueOf(n11)), objectArray[n6]).compareTo(ONE) != 0) break block4;
                    n11 += 2;
                }
                break;
            }
            if (--n6 < 0) {
                bigIntegerArray[0] = objectArray[0];
                bigIntegerArray[1] = objectArray[1];
                return bigIntegerArray2[0].intValue();
            }
            ++n7;
        }
        return bigIntegerArray2[0].intValue();
    }

    private long procedure_Aa(long l, long l2, BigInteger[] bigIntegerArray, int n) {
        Object[] objectArray;
        while (l < 0L || l > 0x100000000L) {
            l = this.init_random.nextInt() * 2;
        }
        while (l2 < 0L || l2 > 0x100000000L || l2 / 2L == 0L) {
            l2 = this.init_random.nextInt() * 2 + 1;
        }
        BigInteger bigInteger = new BigInteger(Long.toString(l2));
        BigInteger bigInteger2 = new BigInteger("97781173");
        BigInteger[] bigIntegerArray2 = new BigInteger[]{new BigInteger(Long.toString(l))};
        int[] nArray = new int[]{n};
        int n2 = 0;
        int n3 = 0;
        while (nArray[n3] >= 33) {
            objectArray = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, objectArray, 0, nArray.length);
            nArray = new int[objectArray.length];
            System.arraycopy(objectArray, 0, nArray, 0, objectArray.length);
            nArray[n3 + 1] = nArray[n3] / 2;
            n2 = n3 + 1;
            ++n3;
        }
        objectArray = new BigInteger[n2 + 1];
        objectArray[n2] = new BigInteger("8000000B", 16);
        int n4 = n2 - 1;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = nArray[n4] / 32;
            block4: while (true) {
                BigInteger[] bigIntegerArray3 = new BigInteger[bigIntegerArray2.length];
                System.arraycopy(bigIntegerArray2, 0, bigIntegerArray3, 0, bigIntegerArray2.length);
                bigIntegerArray2 = new BigInteger[n6 + 1];
                System.arraycopy(bigIntegerArray3, 0, bigIntegerArray2, 0, bigIntegerArray3.length);
                int n7 = 0;
                while (n7 < n6) {
                    bigIntegerArray2[n7 + 1] = bigIntegerArray2[n7].multiply(bigInteger2).add(bigInteger).mod(TWO.pow(32));
                    ++n7;
                }
                BigInteger bigInteger3 = new BigInteger("0");
                int n8 = 0;
                while (n8 < n6) {
                    bigInteger3 = bigInteger3.add(bigIntegerArray2[n8].multiply(TWO.pow(32 * n8)));
                    ++n8;
                }
                bigIntegerArray2[0] = bigIntegerArray2[n6];
                BigInteger bigInteger4 = TWO.pow(nArray[n4] - 1).divide(objectArray[n4 + 1]).add(TWO.pow(nArray[n4] - 1).multiply(bigInteger3).divide(objectArray[n4 + 1].multiply(TWO.pow(32 * n6))));
                if (bigInteger4.mod(TWO).compareTo(ONE) == 0) {
                    bigInteger4 = bigInteger4.add(ONE);
                }
                int n9 = 0;
                while (true) {
                    objectArray[n4] = objectArray[n4 + 1].multiply(bigInteger4.add(BigInteger.valueOf(n9))).add(ONE);
                    if (objectArray[n4].compareTo(TWO.pow(nArray[n4])) == 1) continue block4;
                    if (TWO.modPow(objectArray[n4 + 1].multiply(bigInteger4.add(BigInteger.valueOf(n9))), objectArray[n4]).compareTo(ONE) == 0 && TWO.modPow(bigInteger4.add(BigInteger.valueOf(n9)), objectArray[n4]).compareTo(ONE) != 0) break block4;
                    n9 += 2;
                }
                break;
            }
            if (--n4 < 0) {
                bigIntegerArray[0] = objectArray[0];
                bigIntegerArray[1] = objectArray[1];
                return bigIntegerArray2[0].longValue();
            }
            ++n5;
        }
        return bigIntegerArray2[0].longValue();
    }

    private void procedure_B(int n, int n2, BigInteger[] bigIntegerArray) {
        while (n < 0 || n > 65536) {
            n = this.init_random.nextInt() / 32768;
        }
        while (n2 < 0 || n2 > 65536 || n2 / 2 == 0) {
            n2 = this.init_random.nextInt() / 32768 + 1;
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[2];
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = new BigInteger(Integer.toString(n2));
        BigInteger bigInteger5 = new BigInteger("19381");
        n = this.procedure_A(n, n2, bigIntegerArray2, 256);
        bigInteger = bigIntegerArray2[0];
        n = this.procedure_A(n, n2, bigIntegerArray2, 512);
        bigInteger2 = bigIntegerArray2[0];
        BigInteger[] bigIntegerArray3 = new BigInteger[65];
        bigIntegerArray3[0] = new BigInteger(Integer.toString(n));
        int n3 = 1024;
        block2: while (true) {
            int n4 = 0;
            while (n4 < 64) {
                bigIntegerArray3[n4 + 1] = bigIntegerArray3[n4].multiply(bigInteger5).add(bigInteger4).mod(TWO.pow(16));
                ++n4;
            }
            BigInteger bigInteger6 = new BigInteger("0");
            int n5 = 0;
            while (n5 < 64) {
                bigInteger6 = bigInteger6.add(bigIntegerArray3[n5].multiply(TWO.pow(16 * n5)));
                ++n5;
            }
            bigIntegerArray3[0] = bigIntegerArray3[64];
            BigInteger bigInteger7 = TWO.pow(n3 - 1).divide(bigInteger.multiply(bigInteger2)).add(TWO.pow(n3 - 1).multiply(bigInteger6).divide(bigInteger.multiply(bigInteger2).multiply(TWO.pow(1024))));
            if (bigInteger7.mod(TWO).compareTo(ONE) == 0) {
                bigInteger7 = bigInteger7.add(ONE);
            }
            int n6 = 0;
            while (true) {
                if ((bigInteger3 = bigInteger.multiply(bigInteger2).multiply(bigInteger7.add(BigInteger.valueOf(n6))).add(ONE)).compareTo(TWO.pow(n3)) == 1) continue block2;
                if (TWO.modPow(bigInteger.multiply(bigInteger2).multiply(bigInteger7.add(BigInteger.valueOf(n6))), bigInteger3).compareTo(ONE) == 0 && TWO.modPow(bigInteger.multiply(bigInteger7.add(BigInteger.valueOf(n6))), bigInteger3).compareTo(ONE) != 0) {
                    bigIntegerArray[0] = bigInteger3;
                    bigIntegerArray[1] = bigInteger;
                    return;
                }
                n6 += 2;
            }
            break;
        }
    }

    private void procedure_Bb(long l, long l2, BigInteger[] bigIntegerArray) {
        while (l < 0L || l > 0x100000000L) {
            l = this.init_random.nextInt() * 2;
        }
        while (l2 < 0L || l2 > 0x100000000L || l2 / 2L == 0L) {
            l2 = this.init_random.nextInt() * 2 + 1;
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[2];
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = new BigInteger(Long.toString(l2));
        BigInteger bigInteger5 = new BigInteger("97781173");
        l = this.procedure_Aa(l, l2, bigIntegerArray2, 256);
        bigInteger = bigIntegerArray2[0];
        l = this.procedure_Aa(l, l2, bigIntegerArray2, 512);
        bigInteger2 = bigIntegerArray2[0];
        BigInteger[] bigIntegerArray3 = new BigInteger[33];
        bigIntegerArray3[0] = new BigInteger(Long.toString(l));
        int n = 1024;
        block2: while (true) {
            int n2 = 0;
            while (n2 < 32) {
                bigIntegerArray3[n2 + 1] = bigIntegerArray3[n2].multiply(bigInteger5).add(bigInteger4).mod(TWO.pow(32));
                ++n2;
            }
            BigInteger bigInteger6 = new BigInteger("0");
            int n3 = 0;
            while (n3 < 32) {
                bigInteger6 = bigInteger6.add(bigIntegerArray3[n3].multiply(TWO.pow(32 * n3)));
                ++n3;
            }
            bigIntegerArray3[0] = bigIntegerArray3[32];
            BigInteger bigInteger7 = TWO.pow(n - 1).divide(bigInteger.multiply(bigInteger2)).add(TWO.pow(n - 1).multiply(bigInteger6).divide(bigInteger.multiply(bigInteger2).multiply(TWO.pow(1024))));
            if (bigInteger7.mod(TWO).compareTo(ONE) == 0) {
                bigInteger7 = bigInteger7.add(ONE);
            }
            int n4 = 0;
            while (true) {
                if ((bigInteger3 = bigInteger.multiply(bigInteger2).multiply(bigInteger7.add(BigInteger.valueOf(n4))).add(ONE)).compareTo(TWO.pow(n)) == 1) continue block2;
                if (TWO.modPow(bigInteger.multiply(bigInteger2).multiply(bigInteger7.add(BigInteger.valueOf(n4))), bigInteger3).compareTo(ONE) == 0 && TWO.modPow(bigInteger.multiply(bigInteger7.add(BigInteger.valueOf(n4))), bigInteger3).compareTo(ONE) != 0) {
                    bigIntegerArray[0] = bigInteger3;
                    bigIntegerArray[1] = bigInteger;
                    return;
                }
                n4 += 2;
            }
            break;
        }
    }

    private BigInteger procedure_C(BigInteger bigInteger, BigInteger bigInteger2) {
        byte[] byArray;
        BigInteger bigInteger3;
        do {
            byArray = new byte[bigInteger.toByteArray().length];
            this.init_random.nextBytes(byArray);
        } while ((bigInteger3 = new BigInteger(byArray)).compareTo(TWO) == -1 || bigInteger3.compareTo(bigInteger.subtract(TWO)) == 1 || bigInteger3.modPow(bigInteger.subtract(ONE).divide(bigInteger2), bigInteger).compareTo(ONE) == 0);
        return bigInteger3.modPow(bigInteger.subtract(ONE).divide(bigInteger2), bigInteger);
    }
}

