/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.Holder;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.CertSelector;

public class AttributeCertificateHolder
implements CertSelector {
    Holder holder;

    public AttributeCertificateHolder(X509Certificate x509Certificate) throws CertificateParsingException {
        X509Principal x509Principal;
        try {
            x509Principal = PrincipalUtil.getIssuerX509Principal(x509Certificate);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
        this.holder = new Holder(new IssuerSerial(new GeneralNames(new DERSequence(new GeneralName(new X509Principal(x509Principal)))), new DERInteger(x509Certificate.getSerialNumber())));
    }

    AttributeCertificateHolder(ASN1Sequence aSN1Sequence) {
        this.holder = Holder.getInstance(aSN1Sequence);
    }

    public AttributeCertificateHolder(X509Principal x509Principal) {
        this.holder = new Holder(new GeneralNames(new DERSequence(new GeneralName(x509Principal))));
    }

    public Object clone() {
        return new AttributeCertificateHolder((ASN1Sequence)this.holder.toASN1Object());
    }

    public Principal[] getEntityNames() {
        if (this.holder.getEntityName() != null) {
            return this.getPrincipals(this.holder.getEntityName());
        }
        return null;
    }

    public Principal[] getIssuer() {
        if (this.holder.getBaseCertificateID() != null) {
            return this.getPrincipals(this.holder.getBaseCertificateID().getIssuer());
        }
        return null;
    }

    private Object[] getNames(GeneralName[] generalNameArray) {
        ArrayList<X509Principal> arrayList = new ArrayList<X509Principal>(generalNameArray.length);
        int n = 0;
        while (n != generalNameArray.length) {
            if (generalNameArray[n].getName() instanceof X509Name) {
                try {
                    arrayList.add(new X509Principal(((X509Name)generalNameArray[n].getName()).getEncoded()));
                }
                catch (IOException iOException) {
                    throw new RuntimeException("badly formed Name object");
                }
            }
            ++n;
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    private Principal[] getPrincipals(GeneralNames generalNames) {
        Object[] objectArray = this.getNames(generalNames.getNames());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n != objectArray.length) {
            if (objectArray[n] instanceof Principal) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Principal[arrayList.size()]);
    }

    public BigInteger getSerialNumber() {
        if (this.holder.getBaseCertificateID() != null) {
            return this.holder.getBaseCertificateID().getSerial().getValue();
        }
        return null;
    }

    public boolean match(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        try {
            if (this.holder.getBaseCertificateID() != null) {
                return this.holder.getBaseCertificateID().getSerial().getValue().equals(x509Certificate.getSerialNumber()) && this.matchesDN(PrincipalUtil.getIssuerX509Principal(x509Certificate), this.holder.getBaseCertificateID().getIssuer());
            }
            if (this.holder.getEntityName() != null && this.matchesDN(PrincipalUtil.getSubjectX509Principal(x509Certificate), this.holder.getEntityName())) {
                return true;
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
        return false;
    }

    private boolean matchesDN(X509Principal x509Principal, GeneralNames generalNames) {
        GeneralName[] generalNameArray = generalNames.getNames();
        int n = 0;
        while (n != generalNameArray.length) {
            GeneralName generalName = generalNameArray[n];
            if (generalName.getTagNo() == 4) {
                try {
                    if (new X509Principal(((ASN1Encodable)generalName.getName()).getEncoded()).equals(x509Principal)) {
                        return true;
                    }
                }
                catch (IOException iOException) {}
            }
            ++n;
        }
        return false;
    }
}

