/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;

public class PGPPublicKeyRingCollection {
    private HashMap pubRings = new HashMap();
    private ArrayList order = new ArrayList();

    private PGPPublicKeyRingCollection(HashMap hashMap, ArrayList arrayList) {
        this.pubRings = hashMap;
        this.order = arrayList;
    }

    public PGPPublicKeyRingCollection(byte[] byArray) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray));
    }

    public PGPPublicKeyRingCollection(InputStream inputStream) throws IOException, PGPException {
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        PGPPublicKeyRing pGPPublicKeyRing = null;
        while ((pGPPublicKeyRing = (PGPPublicKeyRing)pGPObjectFactory.nextObject()) != null) {
            Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
            this.pubRings.put(l, pGPPublicKeyRing);
            this.order.add(l);
        }
    }

    public PGPPublicKeyRingCollection(Collection collection) throws IOException, PGPException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
            this.pubRings.put(l, pGPPublicKeyRing);
            this.order.add(l);
        }
    }

    public int size() {
        return this.order.size();
    }

    public Iterator getKeyRings() {
        return this.pubRings.values().iterator();
    }

    public Iterator getKeyRings(String string, boolean bl) throws PGPException {
        Iterator iterator = this.getKeyRings();
        ArrayList<PGPPublicKeyRing> arrayList = new ArrayList<PGPPublicKeyRing>();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            Iterator iterator2 = pGPPublicKeyRing.getPublicKey().getUserIDs();
            while (iterator2.hasNext()) {
                if (bl) {
                    if (((String)iterator2.next()).indexOf(string) <= -1) continue;
                    arrayList.add(pGPPublicKeyRing);
                    continue;
                }
                if (!iterator2.next().equals(string)) continue;
                arrayList.add(pGPPublicKeyRing);
            }
        }
        return arrayList.iterator();
    }

    public Iterator getKeyRings(String string) throws PGPException {
        return this.getKeyRings(string, false);
    }

    public PGPPublicKey getPublicKey(long l) throws PGPException {
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(l);
            if (pGPPublicKey == null) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public PGPPublicKeyRing getPublicKeyRing(long l) throws PGPException {
        Long l2 = new Long(l);
        if (this.pubRings.containsKey(l2)) {
            return (PGPPublicKeyRing)this.pubRings.get(l2);
        }
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(l);
            if (pGPPublicKey == null) continue;
            return pGPPublicKeyRing;
        }
        return null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        Iterator iterator = ((AbstractList)this.order).iterator();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)this.pubRings.get(iterator.next());
            pGPPublicKeyRing.encode(bCPGOutputStream);
        }
    }

    public static PGPPublicKeyRingCollection addPublicKeyRing(PGPPublicKeyRingCollection pGPPublicKeyRingCollection, PGPPublicKeyRing pGPPublicKeyRing) {
        Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
        if (pGPPublicKeyRingCollection.pubRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPPublicKeyRing> hashMap = new HashMap<Long, PGPPublicKeyRing>(pGPPublicKeyRingCollection.pubRings);
        ArrayList<Long> arrayList = new ArrayList<Long>(pGPPublicKeyRingCollection.order);
        hashMap.put(l, pGPPublicKeyRing);
        arrayList.add(l);
        return new PGPPublicKeyRingCollection(hashMap, arrayList);
    }

    public static PGPPublicKeyRingCollection removePublicKeyRing(PGPPublicKeyRingCollection pGPPublicKeyRingCollection, PGPPublicKeyRing pGPPublicKeyRing) {
        Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
        if (!pGPPublicKeyRingCollection.pubRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap hashMap = new HashMap(pGPPublicKeyRingCollection.pubRings);
        ArrayList arrayList = new ArrayList(pGPPublicKeyRingCollection.order);
        hashMap.remove(l);
        int n = 0;
        while (n < arrayList.size()) {
            Long l2 = (Long)arrayList.get(n);
            if (l2.longValue() == l.longValue()) {
                arrayList.remove(n);
                break;
            }
            ++n;
        }
        return new PGPPublicKeyRingCollection(hashMap, arrayList);
    }
}

