/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.util.Date;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignerUserID;

public class PGPSignatureSubpacketVector {
    SignatureSubpacket[] packets;

    PGPSignatureSubpacketVector(SignatureSubpacket[] signatureSubpacketArray) {
        this.packets = signatureSubpacketArray;
    }

    public SignatureSubpacket getSubpacket(int n) {
        int n2 = 0;
        while (n2 != this.packets.length) {
            if (this.packets[n2].getType() == n) {
                return this.packets[n2];
            }
            ++n2;
        }
        return null;
    }

    public long getIssuerKeyID() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(16);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((IssuerKeyID)signatureSubpacket).getKeyID();
    }

    public Date getSignatureCreationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(2);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((SignatureCreationTime)signatureSubpacket).getTime();
    }

    public long getSignatureExpirationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(3);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((SignatureExpirationTime)signatureSubpacket).getTime();
    }

    public long getKeyExpirationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(9);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((KeyExpirationTime)signatureSubpacket).getTime();
    }

    public int[] getPreferredHashAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(21);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferrences();
    }

    public int[] getPreferredSymmetricAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(11);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferrences();
    }

    public int[] getPreferredCompressionAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(22);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferrences();
    }

    public int getKeyFlags() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(27);
        if (signatureSubpacket == null) {
            return 0;
        }
        return ((KeyFlags)signatureSubpacket).getFlags();
    }

    public String getSignerUserID() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(28);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((SignerUserID)signatureSubpacket).getID();
    }

    public int[] getCriticalTags() {
        int n = 0;
        int n2 = 0;
        while (n2 != this.packets.length) {
            if (this.packets[n2].isCritical()) {
                ++n;
            }
            ++n2;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 != this.packets.length) {
            if (this.packets[n3].isCritical()) {
                nArray[n3] = this.packets[n3].getType();
            }
            ++n3;
        }
        return nArray;
    }

    SignatureSubpacket[] toSubpacketArray() {
        return this.packets;
    }
}

