/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;

public class UserIDPacket
extends ContainedPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.idData = new byte[bCPGInputStream.available()];
        bCPGInputStream.readFully(this.idData);
    }

    public UserIDPacket(String string) {
        this.idData = new byte[string.length()];
        for (int i = 0; i != string.length(); ++i) {
            this.idData[i] = (byte)string.charAt(i);
        }
    }

    public String getID() {
        char[] cArray = new char[this.idData.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(this.idData[i] & 0xFF);
        }
        return new String(cArray);
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(13, this.idData, true);
    }
}

