/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Random;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PGPPacketTest
implements Test {
    private static int MAX = 32000;

    private TestResult readBackTest(PGPLiteralDataGenerator pGPLiteralDataGenerator) throws IOException {
        Random random = new Random();
        byte[] byArray = new byte[MAX];
        random.nextBytes(byArray);
        for (int i = 1; i != MAX; ++i) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)byteArrayOutputStream, 'b', "_CONSOLE", i, new Date());
            outputStream.write(byArray, 0, i);
            pGPLiteralDataGenerator.close();
            PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(byteArrayOutputStream.toByteArray());
            PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory.nextObject();
            InputStream inputStream = pGPLiteralData.getInputStream();
            for (int j = 0; j != i; ++j) {
                if (inputStream.read() == (byArray[j] & 0xFF)) continue;
                return new SimpleTestResult(false, this.getName() + ": failed readback test - length = " + i);
            }
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        try {
            PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator(true);
            TestResult testResult = this.readBackTest(pGPLiteralDataGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            PGPLiteralDataGenerator pGPLiteralDataGenerator2 = new PGPLiteralDataGenerator(false);
            testResult = this.readBackTest(pGPLiteralDataGenerator2);
            return testResult;
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "PGPPacketTest";
    }

    public static void main(String[] stringArray) {
        PGPPacketTest pGPPacketTest = new PGPPacketTest();
        TestResult testResult = pGPPacketTest.perform();
        System.out.println(testResult.toString());
    }
}

