/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class GOST28147Test
implements Test {
    static String[] cipherTests = new String[]{"256", "0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef", "4e6f77206973207468652074696d6520666f7220616c6c20", "281630d0d5770030068c252d841e84149ccc1912052dbc02", "256", "0123456789abcdef0123456789abcdef0123456789abcdef0123456789abcdef", "4e6f77206973207468652074696d65208a920c6ed1a804f5", "88e543dfc04dc4f764fa7b624741cec07de49b007bf36065"};

    public String getName() {
        return "GOST28147";
    }

    private boolean equalArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult testECB(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Cipher cipher;
        Cipher cipher2;
        SecretKeySpec secretKeySpec;
        try {
            secretKeySpec = new SecretKeySpec(byArray, "GOST28147");
            cipher2 = Cipher.getInstance("GOST28147/ECB/NoPadding", "BC");
            cipher = Cipher.getInstance("GOST28147/ECB/NoPadding", "BC");
            cipher.init(1, secretKeySpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed initialisation - " + exception.toString());
        }
        try {
            cipher2.init(2, secretKeySpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed initialisation - " + exception.toString());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        try {
            for (int i = 0; i != byArray2.length / 2; ++i) {
                cipherOutputStream.write(byArray2[i]);
            }
            cipherOutputStream.write(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed encryption - " + iOException.toString());
        }
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        if (!this.equalArray(byArray4, byArray3)) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed encryption - expected " + new String(Hex.encode((byte[])byArray3)) + " got " + new String(Hex.encode((byte[])byArray4)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher2);
        try {
            DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
            byArray4 = new byte[byArray2.length];
            for (int i = 0; i != byArray2.length / 2; ++i) {
                byArray4[i] = (byte)dataInputStream.read();
            }
            dataInputStream.readFully(byArray4, byArray2.length / 2, byArray4.length - byArray2.length / 2);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed encryption - " + exception.toString());
        }
        if (!this.equalArray(byArray4, byArray2)) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed decryption - expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray4)));
        }
        return new SimpleTestResult(true, this.getName() + ": GOST28147 Okay");
    }

    public TestResult testCFB(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4;
        Cipher cipher;
        Cipher cipher2;
        SecretKeySpec secretKeySpec;
        try {
            secretKeySpec = new SecretKeySpec(byArray, "GOST28147");
            cipher2 = Cipher.getInstance("GOST28147/CFB8/NoPadding", "BC");
            cipher = Cipher.getInstance("GOST28147/CFB8/NoPadding", "BC");
            byArray4 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray4));
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed initialisation - " + exception.toString(), exception);
        }
        try {
            byArray4 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
            cipher2.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray4));
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed initialisation - " + exception.toString(), exception);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        try {
            for (int i = 0; i != byArray2.length / 2; ++i) {
                cipherOutputStream.write(byArray2[i]);
            }
            cipherOutputStream.write(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed encryption - " + iOException.toString(), (Exception)iOException);
        }
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        if (!this.equalArray(byArray5, byArray3)) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed encryption - expected " + new String(Hex.encode((byte[])byArray3)) + " got " + new String(Hex.encode((byte[])byArray5)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray5);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher2);
        try {
            DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
            byArray5 = new byte[byArray2.length];
            for (int i = 0; i != byArray2.length / 2; ++i) {
                byArray5[i] = (byte)dataInputStream.read();
            }
            dataInputStream.readFully(byArray5, byArray2.length / 2, byArray5.length - byArray2.length / 2);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed encryption - " + exception.toString(), exception);
        }
        if (!this.equalArray(byArray5, byArray2)) {
            return new SimpleTestResult(false, this.getName() + ": GOST28147 failed decryption - expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray5)));
        }
        return new SimpleTestResult(true, this.getName() + ": GOST28147 Okay");
    }

    private TestResult oidTest() {
        String[] stringArray = new String[]{CryptoProObjectIdentifiers.gostR28147_cbc.getId()};
        String[] stringArray2 = new String[]{"GOST28147/CBC/PKCS7Padding"};
        try {
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[8]);
            for (int i = 0; i != stringArray.length; ++i) {
                Cipher cipher = Cipher.getInstance(stringArray[i], "BC");
                Cipher cipher2 = Cipher.getInstance(stringArray2[i], "BC");
                KeyGenerator keyGenerator = KeyGenerator.getInstance(stringArray[i], "BC");
                SecretKey secretKey = keyGenerator.generateKey();
                cipher.init(1, (Key)secretKey, ivParameterSpec);
                cipher2.init(2, (Key)secretKey, ivParameterSpec);
                byte[] byArray2 = cipher2.doFinal(cipher.doFinal(byArray));
                if (this.equalArray(byArray, byArray2)) continue;
                return new SimpleTestResult(false, this.getName() + ": failed OID test");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed exception " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        for (int i = 0; i != cipherTests.length; i += 8) {
            TestResult testResult = this.testECB(Integer.parseInt(cipherTests[i]), Hex.decode((String)cipherTests[i + 1]), Hex.decode((String)cipherTests[i + 2]), Hex.decode((String)cipherTests[i + 3]));
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            testResult = this.testCFB(Integer.parseInt(cipherTests[i + 4]), Hex.decode((String)cipherTests[i + 4 + 1]), Hex.decode((String)cipherTests[i + 4 + 2]), Hex.decode((String)cipherTests[i + 4 + 3]));
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            testResult = this.oidTest();
            if (testResult.isSuccessful()) continue;
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        GOST28147Test gOST28147Test = new GOST28147Test();
        TestResult testResult = gOST28147Test.perform();
        System.out.println(testResult.toString());
    }
}

