/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SHA224HMacTest
implements Test {
    static final String[] keys = new String[]{"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "4a656665", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "0102030405060708090a0b0c0d0e0f10111213141516171819", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
    static final String[] digests = new String[]{"896fb1128abbdf196832107cd49df33f47b4b1169912ba4f53684b22", "a30e01098bc6dbbf45690f3a7e9e6d0f8bbea2a39e6148008fd05e44", "7fb3cb3588c6c1f6ffa9694d7d6ad2649365b0c1f65d69d1ec8333ea", "6c11506874013cac6a2abc1bb382627cec6a90d86efc012de7afec5a", "0e2aea68a90c8d37c988bcdb9fca6fa8099cd857c7ec4a1815cac54c", "95e9a0db962095adaebe9b2d6f0dbce2d499f112f2d2b7273fa6870e", "3a854166ac5d9f023f54d517d0b39dbd946770db9c2b95c9f6f565d1"};
    static final String[] messages = new String[]{"Hi There", "what do ya want for nothing?", "0xdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd", "0xcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcd", "Test With Truncation", "Test Using Larger Than Block-Size Key - Hash Key First", "This is a test using a larger than block-size key and a larger than block-size data. The key needs to be hashed before being used by the HMAC algorithm."};

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "SHA224HMac";
    }

    public static void main(String[] stringArray) {
        SHA224HMacTest sHA224HMacTest = new SHA224HMacTest();
        TestResult testResult = sHA224HMacTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        HMac hMac = new HMac((Digest)new SHA224Digest());
        byte[] byArray = new byte[hMac.getMacSize()];
        int n = 0;
        while (n < messages.length) {
            byte[] byArray2 = messages[n].getBytes();
            if (messages[n].startsWith("0x")) {
                byArray2 = Hex.decode((String)messages[n].substring(2));
            }
            hMac.init((CipherParameters)new KeyParameter(Hex.decode((String)keys[n])));
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray, 0);
            if (!SHA224HMacTest.arraysEqual(byArray, Hex.decode((String)digests[n]))) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Vector " + n + " failed got -" + new String(Hex.encode((byte[])byArray)));
            }
            ++n;
        }
        int n2 = 0;
        byte[] byArray3 = messages[n2].getBytes();
        if (messages[n2].startsWith("0x")) {
            byArray3 = Hex.decode((String)messages[n2].substring(2));
        }
        hMac.init((CipherParameters)new KeyParameter(Hex.decode((String)keys[n2])));
        hMac.update(byArray3, 0, byArray3.length);
        hMac.doFinal(byArray, 0);
        hMac.reset();
        hMac.update(byArray3, 0, byArray3.length);
        hMac.doFinal(byArray, 0);
        if (!SHA224HMacTest.arraysEqual(byArray, Hex.decode((String)digests[n2]))) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + "Reset with vector " + n2 + " failed");
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

