/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CipherStreamTest
implements Test {
    public String getName() {
        return "CipherStreamTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CipherStreamTest cipherStreamTest = new CipherStreamTest();
        TestResult testResult = cipherStreamTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult perform() {
        TestResult testResult = this.runTest("RC4");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.runTest("DES/ECB/PKCS7Padding");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.runTest("DES/CFB8/NoPadding");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    private TestResult runTest(String string) {
        String string2 = "ABCDEFGHIJKLMNOPQRSTUVWXY0123456789";
        try {
            KeyGenerator keyGenerator = null;
            keyGenerator = string.indexOf(47) < 0 ? KeyGenerator.getInstance(string, "BC") : KeyGenerator.getInstance(string.substring(0, string.indexOf(47)), "BC");
            Cipher cipher = Cipher.getInstance(string, "BC");
            Cipher cipher2 = Cipher.getInstance(string, "BC");
            SecretKey secretKey = keyGenerator.generateKey();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cipher.init(1, secretKey);
            if (cipher.getIV() != null) {
                cipher2.init(2, (Key)secretKey, new IvParameterSpec(cipher.getIV()));
            } else {
                cipher2.init(2, secretKey);
            }
            CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher2);
            int n = 0;
            while ((n = cipherInputStream.read()) >= 0) {
                cipherOutputStream.write(n);
            }
            cipherInputStream.close();
            cipherOutputStream.flush();
            cipherOutputStream.close();
            String string3 = new String(byteArrayOutputStream.toByteArray());
            if (!string3.equals(string2)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - decrypted data doesn't match.");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + exception.toString());
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

