/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1ObjectIdentifier;
import org.bouncycastle.sasn1.BerGenerator;
import org.bouncycastle.sasn1.BerOctetStringGenerator;
import org.bouncycastle.sasn1.BerSequenceGenerator;

public class CMSSignedDataStreamGenerator {
    public static final String DATA = PKCSObjectIdentifiers.data.getId();
    public static final String DIGEST_SHA1 = "1.3.14.3.2.26";
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_MD5 = "1.2.840.113549.2.5";
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String ENCRYPTION_RSA = "1.2.840.113549.1.1.1";
    public static final String ENCRYPTION_DSA = "1.2.840.10040.4.3";
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();
    private ArrayList _certs = new ArrayList();
    private ArrayList _crls = new ArrayList();
    private ArrayList _signerInfs = new ArrayList();
    private ArrayList _signers = new ArrayList();
    private ArrayList _digests = new ArrayList();

    private String getEncOID(PrivateKey privateKey, String string) {
        String string2 = null;
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_RSA;
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_DSA;
            if (!string.equals(DIGEST_SHA1)) {
                throw new IllegalArgumentException("can't mix DSA with anything but SHA1");
            }
        } else if (privateKey instanceof GOST3410PrivateKey || "GOST3410".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_GOST3410;
        } else if ("ECGOST3410".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_ECGOST3410;
        }
        return string2;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, null, null, string2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        MessageDigest messageDigest;
        Signature signature;
        String string3 = this.getEncOID(privateKey, string);
        if (string2 != null) {
            signature = Signature.getInstance(CMSUtils.getDigestAlgName(string) + "with" + CMSUtils.getEncryptionAlgName(string3), string2);
            try {
                messageDigest = MessageDigest.getInstance(CMSUtils.getDigestAlgName(string), string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                messageDigest = MessageDigest.getInstance(CMSUtils.getDigestAlgName(string));
            }
        } else {
            signature = Signature.getInstance(CMSUtils.getDigestAlgName(string) + "with" + CMSUtils.getEncryptionAlgName(string3));
            messageDigest = MessageDigest.getInstance(CMSUtils.getDigestAlgName(string));
        }
        signature.initSign(privateKey);
        this._signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string3, attributeTable, attributeTable2, messageDigest, signature));
        this._digests.add(messageDigest);
    }

    public void addSigners(SignerInformationStore signerInformationStore) {
        Iterator iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            this._signers.add(iterator.next());
        }
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, CMSException {
        X509Extension x509Extension;
        Iterator iterator;
        try {
            iterator = certStore.getCertificates(null).iterator();
            while (iterator.hasNext()) {
                x509Extension = (X509Certificate)iterator.next();
                this._certs.add(new X509CertificateStructure((ASN1Sequence)this.makeObj(((Certificate)((Object)x509Extension)).getEncoded())));
            }
        }
        catch (IOException iOException) {
            throw new CMSException("error processing certs", iOException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CMSException("error encoding certs", certificateEncodingException);
        }
        try {
            iterator = certStore.getCRLs(null).iterator();
            while (iterator.hasNext()) {
                x509Extension = (X509CRL)iterator.next();
                this._crls.add(new CertificateList((ASN1Sequence)this.makeObj(((X509CRL)x509Extension).getEncoded())));
            }
        }
        catch (IOException iOException) {
            throw new CMSException("error processing crls", iOException);
        }
        catch (CRLException cRLException) {
            throw new CMSException("error encoding crls", cRLException);
        }
    }

    private DERObject makeObj(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        return aSN1InputStream.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)this.makeObj(byArray));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)new DERNull());
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        return this.open(outputStream, false);
    }

    public OutputStream open(OutputStream outputStream, boolean bl) throws IOException {
        return this.open(outputStream, DATA, bl);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl) throws IOException {
        OutputStream outputStream2;
        Object object;
        Object object2;
        BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(outputStream);
        berSequenceGenerator.addObject(new Asn1ObjectIdentifier(CMSObjectIdentifiers.signedData.getId()));
        BerSequenceGenerator berSequenceGenerator2 = new BerSequenceGenerator(berSequenceGenerator.getRawOutputStream(), 0, true);
        berSequenceGenerator2.addObject(this.getVersion(string));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator iterator = ((AbstractList)this._signers).iterator();
        while (iterator.hasNext()) {
            object2 = (SignerInformation)iterator.next();
            object = this.makeAlgId(((SignerInformation)object2).getDigestAlgOID(), ((SignerInformation)object2).getDigestAlgParams());
            aSN1EncodableVector.add((DEREncodable)object);
        }
        iterator = ((AbstractList)this._signerInfs).iterator();
        while (iterator.hasNext()) {
            object2 = (SignerInf)iterator.next();
            object = this.makeAlgId(((SignerInf)object2).getDigestAlgOID(), ((SignerInf)object2).getDigestAlgParams());
            aSN1EncodableVector.add((DEREncodable)object);
        }
        berSequenceGenerator2.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
        object2 = new BerSequenceGenerator(berSequenceGenerator2.getRawOutputStream());
        ((BerSequenceGenerator)object2).addObject(new Asn1ObjectIdentifier(string));
        object = new BerOctetStringGenerator(((BerGenerator)object2).getRawOutputStream(), 0, true);
        if (bl) {
            outputStream2 = ((BerOctetStringGenerator)object).getOctetOutputStream();
        } else {
            ((BerOctetStringGenerator)object).getOctetOutputStream().close();
            outputStream2 = new NullOutputStream();
        }
        iterator = ((AbstractList)this._digests).iterator();
        while (iterator.hasNext()) {
            outputStream2 = new DigestOutputStream(outputStream2, (MessageDigest)iterator.next());
        }
        return new CmsSignedDataOutputStream(outputStream2, string, berSequenceGenerator, berSequenceGenerator2, (BerSequenceGenerator)object2);
    }

    private Asn1Integer getVersion(String string) {
        int n = 0;
        n = this.anyCertHasTypeOther() || this.anyCrlHasTypeOther() ? 5 : (this.anyCertHasV2Attribute() ? 4 : (this.anyCertHasV1Attribute() || !string.equals(DATA) ? 3 : 1));
        return new Asn1Integer(n);
    }

    private boolean anyCertHasTypeOther() {
        return false;
    }

    private boolean anyCertHasV1Attribute() {
        return false;
    }

    private boolean anyCertHasV2Attribute() {
        return false;
    }

    private boolean anyCrlHasTypeOther() {
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private String _contentOID;
        private BerSequenceGenerator _sGen;
        private BerSequenceGenerator _sigGen;
        private BerSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream outputStream, String string, BerSequenceGenerator berSequenceGenerator, BerSequenceGenerator berSequenceGenerator2, BerSequenceGenerator berSequenceGenerator3) {
            this._out = outputStream;
            this._contentOID = string;
            this._sGen = berSequenceGenerator;
            this._sigGen = berSequenceGenerator2;
            this._eiGen = berSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void close() throws IOException {
            Object object;
            Iterator iterator;
            ASN1EncodableVector aSN1EncodableVector;
            this._out.close();
            this._eiGen.close();
            if (CMSSignedDataStreamGenerator.this._certs.size() != 0) {
                aSN1EncodableVector = new ASN1EncodableVector();
                iterator = ((AbstractList)CMSSignedDataStreamGenerator.this._certs).iterator();
                while (iterator.hasNext()) {
                    aSN1EncodableVector.add((DEREncodable)iterator.next());
                }
                this._sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, (DEREncodable)new DERSet((DEREncodableVector)aSN1EncodableVector)).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this._crls.size() != 0) {
                aSN1EncodableVector = new ASN1EncodableVector();
                iterator = ((AbstractList)CMSSignedDataStreamGenerator.this._crls).iterator();
                while (iterator.hasNext()) {
                    aSN1EncodableVector.add((DEREncodable)iterator.next());
                }
                this._sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, (DEREncodable)new DERSet((DEREncodableVector)aSN1EncodableVector)).getEncoded());
            }
            aSN1EncodableVector = new ASN1EncodableVector();
            iterator = ((AbstractList)CMSSignedDataStreamGenerator.this._signers).iterator();
            while (iterator.hasNext()) {
                object = (SignerInformation)iterator.next();
                aSN1EncodableVector.add((DEREncodable)((SignerInformation)object).toSignerInfo());
            }
            iterator = ((AbstractList)CMSSignedDataStreamGenerator.this._signerInfs).iterator();
            while (iterator.hasNext()) {
                object = (SignerInf)iterator.next();
                try {
                    aSN1EncodableVector.add((DEREncodable)((SignerInf)object).toSignerInfo(this._contentOID, true));
                }
                catch (IOException iOException) {
                    throw new IOException("encoding error." + iOException);
                }
                catch (SignatureException signatureException) {
                    throw new IOException("error creating signature." + signatureException);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("error creating sid." + certificateEncodingException);
                }
            }
            this._sigGen.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int n) throws IOException {
        }
    }

    private class SignerInf {
        PrivateKey _key;
        X509Certificate _cert;
        String _digestOID;
        String _encOID;
        AttributeTable _sAttr;
        AttributeTable _unsAttr;
        MessageDigest _digest;
        Signature _signature;

        SignerInf(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2, MessageDigest messageDigest, Signature signature) {
            this._key = privateKey;
            this._cert = x509Certificate;
            this._digestOID = string;
            this._encOID = string2;
            this._sAttr = attributeTable;
            this._unsAttr = attributeTable2;
            this._digest = messageDigest;
            this._signature = signature;
        }

        PrivateKey getKey() {
            return this._key;
        }

        X509Certificate getCertificate() {
            return this._cert;
        }

        String getDigestAlgOID() {
            return this._digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this._encOID;
        }

        AttributeTable getSignedAttributes() {
            return this._sAttr;
        }

        AttributeTable getUnsignedAttributes() {
            return this._unsAttr;
        }

        SignerInfo toSignerInfo(String string, boolean bl) throws IOException, SignatureException, CertificateEncodingException {
            Object object;
            Object object2;
            Object object3;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), (DEREncodable)new DERNull());
            AlgorithmIdentifier algorithmIdentifier2 = this.getEncryptionAlgOID().equals(CMSSignedDataStreamGenerator.ENCRYPTION_DSA) ? new AlgorithmIdentifier(new DERObjectIdentifier(this.getEncryptionAlgOID())) : new AlgorithmIdentifier(new DERObjectIdentifier(this.getEncryptionAlgOID()), (DEREncodable)new DERNull());
            DERSet dERSet = null;
            DERSet dERSet2 = null;
            AttributeTable attributeTable = this.getSignedAttributes();
            byte[] byArray = this._digest.digest();
            if (attributeTable != null) {
                object3 = new ASN1EncodableVector();
                if (attributeTable.get(CMSAttributes.contentType) == null) {
                    object3.add((DEREncodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)new DERObjectIdentifier(string.toString()))));
                } else {
                    object3.add((DEREncodable)attributeTable.get(CMSAttributes.contentType));
                }
                if (attributeTable.get(CMSAttributes.signingTime) == null) {
                    object3.add((DEREncodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new Time(new Date()))));
                } else {
                    object3.add((DEREncodable)attributeTable.get(CMSAttributes.signingTime));
                }
                object3.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(byArray))));
                object2 = attributeTable.toHashtable();
                ((Hashtable)object2).remove(CMSAttributes.contentType);
                ((Hashtable)object2).remove(CMSAttributes.signingTime);
                ((Hashtable)object2).remove(CMSAttributes.messageDigest);
                object = ((Hashtable)object2).values().iterator();
                while (object.hasNext()) {
                    object3.add((DEREncodable)Attribute.getInstance(object.next()));
                }
                dERSet = new DERSet((DEREncodableVector)object3);
            } else if (bl) {
                object3 = new ASN1EncodableVector();
                object3.add((DEREncodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)new DERObjectIdentifier(string.toString()))));
                object3.add((DEREncodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new DERUTCTime(new Date()))));
                object3.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(byArray))));
                dERSet = new DERSet((DEREncodableVector)object3);
            }
            attributeTable = this.getUnsignedAttributes();
            if (attributeTable != null) {
                object3 = attributeTable.toHashtable();
                object2 = ((Hashtable)object3).values().iterator();
                object = new ASN1EncodableVector();
                while (object2.hasNext()) {
                    object.add((DEREncodable)Attribute.getInstance(object2.next()));
                }
                dERSet2 = new DERSet((DEREncodableVector)object);
            }
            object3 = new ByteArrayOutputStream();
            if (dERSet == null) {
                throw new RuntimeException("signatures without signed attributes not implemented.");
            }
            object2 = new DEROutputStream((OutputStream)object3);
            object2.writeObject(dERSet);
            this._signature.update(((ByteArrayOutputStream)object3).toByteArray());
            object2 = new DEROctetString(this._signature.sign());
            object = this.getCertificate();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((X509Certificate)object).getTBSCertificate());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(tBSCertificateStructure.getIssuer(), tBSCertificateStructure.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(issuerAndSerialNumber), algorithmIdentifier, (ASN1Set)dERSet, algorithmIdentifier2, (ASN1OctetString)object2, (ASN1Set)dERSet2);
        }
    }

    static class SigOutputStream
    extends OutputStream {
        Signature sig;

        public SigOutputStream(Signature signature) {
            this.sig = signature;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.sig.update(byArray, n, n2);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }

        public void write(int n) throws IOException {
            try {
                this.sig.update((byte)n);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest messageDigest) {
            this.dig = messageDigest;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }
    }
}

