/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientId;

public abstract class RecipientInformation {
    private static final ASN1Null asn1Null = new DERNull();
    protected RecipientId _rid = new RecipientId();
    protected AlgorithmIdentifier _encAlg;
    protected AlgorithmIdentifier _keyEncAlg;
    protected InputStream _data;

    protected RecipientInformation(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, InputStream inputStream) {
        this._encAlg = algorithmIdentifier;
        this._keyEncAlg = algorithmIdentifier2;
        this._data = inputStream;
    }

    public RecipientId getRID() {
        return this._rid;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)dEREncodable);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public String getKeyEncryptionAlgOID() {
        return this._keyEncAlg.getObjectId().getId();
    }

    public byte[] getKeyEncryptionAlgParams() {
        try {
            return this.encodeObj(this._keyEncAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmParameters getKeyEncryptionAlgorithmParameters(String string) throws CMSException, NoSuchProviderException {
        try {
            byte[] byArray = this.encodeObj(this._keyEncAlg.getParameters());
            if (byArray == null) {
                return null;
            }
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.getKeyEncryptionAlgOID(), string);
            algorithmParameters.init(byArray, "ASN.1");
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find parameters for algorithm", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't find parse parameters", iOException);
        }
    }

    protected CMSTypedStream getContentFromSessionKey(Key key, String string) throws CMSException, NoSuchProviderException {
        String string2 = this._encAlg.getObjectId().getId();
        try {
            Cipher cipher = Cipher.getInstance(string2, string);
            DEREncodable dEREncodable = this._encAlg.getParameters();
            if (dEREncodable != null && !asn1Null.equals((Object)dEREncodable)) {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string2, string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                aSN1OutputStream.writeObject((Object)this._encAlg.getParameters());
                algorithmParameters.init(byteArrayOutputStream.toByteArray(), "ASN.1");
                cipher.init(2, key, algorithmParameters);
            } else if (string2.equals("1.2.840.113549.3.7") || string2.equals("1.3.6.1.4.1.188.7.1.1.2") || string2.equals("1.2.840.113533.7.66.10")) {
                cipher.init(2, key, new IvParameterSpec(new byte[8]));
            } else {
                cipher.init(2, key);
            }
            return new CMSTypedStream(new CipherInputStream(this._data, cipher));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("error decoding algorithm parameters.", iOException);
        }
    }

    public byte[] getContent(Key key, String string) throws CMSException, NoSuchProviderException {
        try {
            if (this._data instanceof ByteArrayInputStream) {
                this._data.reset();
            }
            return CMSUtils.streamToByteArray(this.getContentStream(key, string).getContentStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to parse internal stream: " + iOException);
        }
    }

    public abstract CMSTypedStream getContentStream(Key var1, String var2) throws CMSException, NoSuchProviderException;
}

