/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.internet.MimeBodyPart;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.test.SMIMETestSetup;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;

public class SMIMEEnvelopedTest
extends TestCase {
    public boolean DEBUG = true;
    static /* synthetic */ Class class$org$bouncycastle$mail$smime$test$SMIMEEnvelopedTest;

    public SMIMEEnvelopedTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
        TestRunner.run((Class)(class$org$bouncycastle$mail$smime$test$SMIMEEnvelopedTest == null ? (class$org$bouncycastle$mail$smime$test$SMIMEEnvelopedTest = SMIMEEnvelopedTest.class$("org.bouncycastle.mail.smime.test.SMIMEEnvelopedTest")) : class$org$bouncycastle$mail$smime$test$SMIMEEnvelopedTest));
    }

    public static Test suite() {
        return new SMIMETestSetup((Test)new TestSuite(class$org$bouncycastle$mail$smime$test$SMIMEEnvelopedTest == null ? (class$org$bouncycastle$mail$smime$test$SMIMEEnvelopedTest = SMIMEEnvelopedTest.class$("org.bouncycastle.mail.smime.test.SMIMEEnvelopedTest")) : class$org$bouncycastle$mail$smime$test$SMIMEEnvelopedTest));
    }

    public void log(Exception exception) {
        if (this.DEBUG) {
            exception.printStackTrace();
        }
    }

    public void log(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testDESEDE3Encrypted() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            String string = "O=Bouncy Castle, C=CA";
            KeyPair keyPair = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate = SMIMETestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair2 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = SMIMETestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair3 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = SMIMETestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addKeyTransRecipient(x509Certificate3);
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.2.840.113549.3.7", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            recipientId.setSerialNumber(x509Certificate3.getSerialNumber());
            recipientId.setIssuer(((X509Principal)x509Certificate3.getIssuerDN()).getEncoded());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(keyPair3.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void testIDEAEncrypted() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            String string = "O=Bouncy Castle, C=CA";
            KeyPair keyPair = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate = SMIMETestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair2 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = SMIMETestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair3 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = SMIMETestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addKeyTransRecipient(x509Certificate3);
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.3.6.1.4.1.188.7.1.1.2", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            recipientId.setSerialNumber(x509Certificate3.getSerialNumber());
            recipientId.setIssuer(((X509Principal)x509Certificate3.getIssuerDN()).getEncoded());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(keyPair3.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void testRC2Encrypted() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            String string = "O=Bouncy Castle, C=CA";
            KeyPair keyPair = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate = SMIMETestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair2 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = SMIMETestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair3 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = SMIMETestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addKeyTransRecipient(x509Certificate3);
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.2.840.113549.3.2", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            recipientId.setSerialNumber(x509Certificate3.getSerialNumber());
            recipientId.setIssuer(((X509Principal)x509Certificate3.getIssuerDN()).getEncoded());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(keyPair3.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void testCASTEncrypted() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            String string = "O=Bouncy Castle, C=CA";
            KeyPair keyPair = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate = SMIMETestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair2 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = SMIMETestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair3 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = SMIMETestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addKeyTransRecipient(x509Certificate3);
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.2.840.113533.7.66.10", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            recipientId.setSerialNumber(x509Certificate3.getSerialNumber());
            recipientId.setIssuer(((X509Principal)x509Certificate3.getIssuerDN()).getEncoded());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(keyPair3.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void testSubKeyId() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            String string = "O=Bouncy Castle, C=CA";
            KeyPair keyPair = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate = SMIMETestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair2 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = SMIMETestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=CA";
            KeyPair keyPair3 = SMIMETestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = SMIMETestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1", "BC");
            messageDigest.update(x509Certificate3.getPublicKey().getEncoded());
            sMIMEEnvelopedGenerator.addKeyTransRecipient(x509Certificate3.getPublicKey(), messageDigest.digest());
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.2.840.113549.3.7", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            messageDigest.update(x509Certificate3.getPublicKey().getEncoded());
            recipientId.setSubjectKeyIdentifier(messageDigest.digest());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(keyPair3.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

