/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.sasn1.Asn1InputStream;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1ObjectIdentifier;
import org.bouncycastle.sasn1.Asn1OctetString;
import org.bouncycastle.sasn1.Asn1Sequence;
import org.bouncycastle.sasn1.BerOctetString;
import org.bouncycastle.sasn1.BerOctetStringGenerator;
import org.bouncycastle.sasn1.BerSequence;
import org.bouncycastle.sasn1.BerSequenceGenerator;
import org.bouncycastle.sasn1.DerSequenceGenerator;
import org.bouncycastle.sasn1.cms.CompressedDataParser;
import org.bouncycastle.sasn1.cms.ContentInfoParser;

public class OctetStringTest
extends TestCase {
    static /* synthetic */ Class class$org$bouncycastle$sasn1$test$OctetStringTest;

    public void testReadingWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BerOctetStringGenerator berOctetStringGenerator = new BerOctetStringGenerator(byteArrayOutputStream);
        OutputStream outputStream = berOctetStringGenerator.getOctetOutputStream();
        outputStream.write(new byte[]{1, 2, 3, 4});
        outputStream.write(new byte[4]);
        outputStream.close();
        Asn1InputStream asn1InputStream = new Asn1InputStream(byteArrayOutputStream.toByteArray());
        BerOctetString berOctetString = (BerOctetString)asn1InputStream.readObject();
        InputStream inputStream = berOctetString.getOctetStream();
        int n = 0;
        while (inputStream.read() >= 0) {
            ++n;
        }
        Assert.assertEquals((int)8, (int)n);
    }

    public void testReadingWritingZeroInLength() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BerOctetStringGenerator berOctetStringGenerator = new BerOctetStringGenerator(byteArrayOutputStream);
        OutputStream outputStream = berOctetStringGenerator.getOctetOutputStream();
        outputStream.write(new byte[]{1, 2, 3, 4});
        outputStream.write(new byte[512]);
        outputStream.close();
        Asn1InputStream asn1InputStream = new Asn1InputStream(byteArrayOutputStream.toByteArray());
        BerOctetString berOctetString = (BerOctetString)asn1InputStream.readObject();
        InputStream inputStream = berOctetString.getOctetStream();
        int n = 0;
        while (inputStream.read() >= 0) {
            ++n;
        }
        Assert.assertEquals((int)516, (int)n);
    }

    public void testReadingWritingNested() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(byteArrayOutputStream);
        BerOctetStringGenerator berOctetStringGenerator = new BerOctetStringGenerator(berSequenceGenerator.getRawOutputStream());
        OutputStream outputStream = berOctetStringGenerator.getOctetOutputStream();
        BerSequenceGenerator berSequenceGenerator2 = new BerSequenceGenerator(outputStream);
        BerOctetStringGenerator berOctetStringGenerator2 = new BerOctetStringGenerator(berSequenceGenerator2.getRawOutputStream());
        OutputStream outputStream2 = berOctetStringGenerator2.getOctetOutputStream();
        outputStream2.write(new byte[]{1, 2, 3, 4});
        outputStream2.write(new byte[10]);
        outputStream2.close();
        berSequenceGenerator2.close();
        outputStream.close();
        berSequenceGenerator.close();
        Asn1InputStream asn1InputStream = new Asn1InputStream(byteArrayOutputStream.toByteArray());
        BerSequence berSequence = (BerSequence)asn1InputStream.readObject();
        BerOctetString berOctetString = (BerOctetString)berSequence.readObject();
        Asn1InputStream asn1InputStream2 = new Asn1InputStream(berOctetString.getOctetStream());
        BerSequence berSequence2 = (BerSequence)asn1InputStream2.readObject();
        BerOctetString berOctetString2 = (BerOctetString)berSequence2.readObject();
        InputStream inputStream = berOctetString2.getOctetStream();
        int n = 0;
        while (inputStream.read() >= 0) {
            ++n;
        }
        Assert.assertEquals((int)14, (int)n);
    }

    public void testNestedStructure() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(byteArrayOutputStream);
        berSequenceGenerator.addObject(new Asn1ObjectIdentifier(CMSObjectIdentifiers.compressedData.getId()));
        BerSequenceGenerator berSequenceGenerator2 = new BerSequenceGenerator(berSequenceGenerator.getRawOutputStream(), 0, true);
        berSequenceGenerator2.addObject(new Asn1Integer(0L));
        DerSequenceGenerator derSequenceGenerator = new DerSequenceGenerator(berSequenceGenerator2.getRawOutputStream());
        derSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.2"));
        derSequenceGenerator.close();
        BerSequenceGenerator berSequenceGenerator3 = new BerSequenceGenerator(berSequenceGenerator2.getRawOutputStream());
        berSequenceGenerator3.addObject(new Asn1ObjectIdentifier("1.1"));
        BerOctetStringGenerator berOctetStringGenerator = new BerOctetStringGenerator(berSequenceGenerator3.getRawOutputStream(), 0, true);
        OutputStream outputStream = berOctetStringGenerator.getOctetOutputStream();
        outputStream.write(new byte[]{1, 2, 3, 4});
        outputStream.write(new byte[4]);
        outputStream.write(new byte[20]);
        outputStream.close();
        berSequenceGenerator3.close();
        berSequenceGenerator2.close();
        berSequenceGenerator.close();
        Asn1InputStream asn1InputStream = new Asn1InputStream(byteArrayOutputStream.toByteArray());
        ContentInfoParser contentInfoParser = new ContentInfoParser((Asn1Sequence)((Object)asn1InputStream.readObject()));
        CompressedDataParser compressedDataParser = new CompressedDataParser((Asn1Sequence)((Object)contentInfoParser.getContent(16)));
        ContentInfoParser contentInfoParser2 = compressedDataParser.getEncapContentInfo();
        Asn1OctetString asn1OctetString = (Asn1OctetString)((Object)contentInfoParser2.getContent(4));
        InputStream inputStream = asn1OctetString.getOctetStream();
        int n = 0;
        while (inputStream.read() >= 0) {
            ++n;
        }
        Assert.assertEquals((int)28, (int)n);
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$sasn1$test$OctetStringTest == null ? (class$org$bouncycastle$sasn1$test$OctetStringTest = OctetStringTest.class$("org.bouncycastle.sasn1.test.OctetStringTest")) : class$org$bouncycastle$sasn1$test$OctetStringTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

