/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSContentInfoParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.sasn1.Asn1Object;
import org.bouncycastle.sasn1.Asn1OctetString;
import org.bouncycastle.sasn1.Asn1Sequence;
import org.bouncycastle.sasn1.Asn1Set;
import org.bouncycastle.sasn1.Asn1TaggedObject;
import org.bouncycastle.sasn1.DerObject;
import org.bouncycastle.sasn1.DerSequence;
import org.bouncycastle.sasn1.cms.ContentInfoParser;
import org.bouncycastle.sasn1.cms.EncryptedContentInfoParser;
import org.bouncycastle.sasn1.cms.EnvelopedDataParser;

public class CMSEnvelopedDataParser
extends CMSContentInfoParser {
    RecipientInformationStore _recipientInfoStore;
    EnvelopedDataParser _envelopedData = new EnvelopedDataParser((Asn1Sequence)((Object)this._contentInfo.getContent(16)));
    private AlgorithmIdentifier _encAlg;
    private AttributeTable _unprotectedAttributes;
    private boolean _attrNotRead = true;

    public CMSEnvelopedDataParser(byte[] byArray) throws CMSException, IOException {
        this(CMSEnvelopedDataParser.readContentInfo(new ByteArrayInputStream(byArray)));
    }

    public CMSEnvelopedDataParser(InputStream inputStream) throws CMSException, IOException {
        this(CMSEnvelopedDataParser.readContentInfo(inputStream));
    }

    CMSEnvelopedDataParser(ContentInfoParser contentInfoParser) throws CMSException, IOException {
        super(contentInfoParser);
        Object object;
        Object object2;
        Asn1Set asn1Set = this._envelopedData.getRecipientInfos();
        ArrayList<RecipientInfo> arrayList = new ArrayList<RecipientInfo>();
        Asn1Object asn1Object = null;
        while ((asn1Object = asn1Set.readObject()) != null) {
            if (asn1Object instanceof DerSequence) {
                object2 = (DerSequence)asn1Object;
                arrayList.add(RecipientInfo.getInstance((Object)new ASN1InputStream(((DerObject)object2).getEncoded()).readObject()));
                continue;
            }
            object2 = (Asn1TaggedObject)asn1Object;
            object = (DerSequence)((Asn1TaggedObject)object2).getObject(16, true);
            arrayList.add(RecipientInfo.getInstance((Object)new DERTaggedObject(true, ((Asn1Object)object2).getTagNumber(), (DEREncodable)new ASN1InputStream(((DerObject)object).getEncoded()).readObject())));
        }
        object2 = this._envelopedData.getEncryptedContentInfo();
        this._encAlg = ((EncryptedContentInfoParser)object2).getContentEncryptionAlgorithm();
        object = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RecipientInfo recipientInfo = (RecipientInfo)iterator.next();
            if (recipientInfo.getInfo() instanceof KeyTransRecipientInfo) {
                ((ArrayList)object).add(new KeyTransRecipientInformation((KeyTransRecipientInfo)recipientInfo.getInfo(), this._encAlg, ((Asn1OctetString)((Object)((EncryptedContentInfoParser)object2).getEncryptedContent(4))).getOctetStream()));
                continue;
            }
            if (!(recipientInfo.getInfo() instanceof KEKRecipientInfo)) continue;
            ((ArrayList)object).add(new KEKRecipientInformation((KEKRecipientInfo)recipientInfo.getInfo(), this._encAlg, ((Asn1OctetString)((Object)((EncryptedContentInfoParser)object2).getEncryptedContent(4))).getOctetStream()));
        }
        this._recipientInfoStore = new RecipientInformationStore((Collection)object);
    }

    public String getEncryptionAlgOID() {
        return this._encAlg.getObjectId().toString();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return ((DerObject)this._encAlg.getParameters()).getEncoded();
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String string) throws CMSException, NoSuchProviderException {
        try {
            byte[] byArray = this.getEncryptionAlgParams();
            if (byArray == null) {
                return null;
            }
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.getEncryptionAlgOID(), string);
            algorithmParameters.init(byArray, "ASN.1");
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find parameters for algorithm", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't find parse parameters", iOException);
        }
    }

    public RecipientInformationStore getRecipientInfos() {
        return this._recipientInfoStore;
    }

    public AttributeTable getUnprotectedAttributes() throws IOException {
        if (this._unprotectedAttributes == null && this._attrNotRead) {
            Asn1Set asn1Set = this._envelopedData.getUnprotectedAttrs();
            this._attrNotRead = false;
            if (asn1Set != null) {
                Asn1Object asn1Object;
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                while ((asn1Object = asn1Set.readObject()) != null) {
                    DerSequence derSequence = (DerSequence)asn1Object;
                    aSN1EncodableVector.add((DEREncodable)DERSequence.getInstance((Object)new ASN1InputStream(derSequence.getEncoded()).readObject()));
                }
                this._unprotectedAttributes = new AttributeTable((ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector));
            }
        }
        return this._unprotectedAttributes;
    }
}

