/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.SecretKey;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class EnvelopedDataStreamTest
extends TestCase {
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static boolean _initialised;
    static /* synthetic */ Class class$org$bouncycastle$cms$test$EnvelopedDataStreamTest;

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
        }
    }

    public void testWorkingData() throws Exception {
        byte[] byArray = Base64.decode((String)"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAKrAz/SQKrcQnj9IxHIfKDbuXsMqUpI06s2gps6fp7RDNvtUDDMOciWGFhD45YSy8GO0mPx3Nkc7vKBqX4TLcqLUz7kXGOHGOwiPZoNF+9jBMPNROe/B0My0PkWg9tuq+nxN64oD47+JvDwrpNOS5wsYavXeAW8Anv9ZzHLU7KwZAgMBAAECgYA/fqdVt+5KWKGfwr1Z+oAHvSf7xtchiw/tGtosZ24DOCNP3fcTXUHQ9kVqVkNyzt9ZFCT3bJUAdBQ2SpfuV4DusVeQZVzcROKeA09nPkxBpTefWbSDQGhb+eZq9L8JDRSWHyYqs+MBoUpLw7GKtZiJkZyY6CsYkAnQ+uYVWq/TIQJBAP5zafO4HUV/w4KDVJi+ua+GYF1Sg1t/dYL1kXO9GP1p75YAmtm6LdnOCas7wj70/G1YlPGkOP0VGFzeG5KAmAUCQQCryvKU9nwWA+kypcQT9Yr1P4vGS0APYoBThnZq7jEPc5CmZI82yseSxSeea0+8KQbZ5mvh1p3qImDLEH/iNSQFAkAghS+tboKPN10NeSt+uiGRRWNbiggv0YJ7Uldcq3ZeLQPp7/naiekCRUsHD4Qr97OrZf7jQ1HlRqTueZScjMLhAkBNUMZCQnhwFAyEzdPkQ7LpU1MdyEopYmRssuxijZao5JLqQAGwYCzXokGFa7hz72b09F4DQurJL/WuDlvvu4jdAkEAxwT9lylvfSfEQw4/qQgZMFB26gqB6Gqs1pHIZCzdliKx5BO3VDeUGfXMI8yOkbXoWbYx5xPid/+N8R//+sxLBw==");
        byte[] byArray2 = Base64.decode((String)"MIAGCSqGSIb3DQEHA6CAMIACAQAxgcQwgcECAQAwKjAlMRYwFAYDVQQKEw1Cb3VuY3kgQ2FzdGxlMQswCQYDVQQGEwJBVQIBHjANBgkqhkiG9w0BAQEFAASBgDmnaDZ0vDJNlaUSYyEXsgbaUH+itNTjCOgv77QTX2ImXj+kTctM19PQF2I10/NL0fjakvCgBTHKmk13a7jqB6cX3bysenHNrglHsgNGgeXQ7ggAq5fV/JQQT7rSxEtuwpbuHQnoVUZahOHVKy/a0uLr9iIh1A3y+yZTZaG505ZJMIAGCSqGSIb3DQEHATAdBglghkgBZQMEAQIEENmkYNbDXiZxJWtq82qIRZKggAQgkOGr1JcTsADStez1eY4+rO4DtyBIyUYQ3pilnbirfPkAAAAAAAAAAAAA");
        CMSEnvelopedDataParser cMSEnvelopedDataParser = new CMSEnvelopedDataParser(byArray2);
        RecipientInformationStore recipientInformationStore = cMSEnvelopedDataParser.getRecipientInfos();
        EnvelopedDataStreamTest.assertEquals((String)cMSEnvelopedDataParser.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        byte[] byArray3 = Hex.decode((String)"57616c6c6157616c6c6157617368696e67746f6e");
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataStreamTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            CMSTypedStream cMSTypedStream = recipientInformation.getContentStream(privateKey, "BC");
            EnvelopedDataStreamTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray3, CMSTestUtil.streamToByteArray(cMSTypedStream.getContentStream())));
        }
    }

    private void verifyData(ByteArrayOutputStream byteArrayOutputStream, String string, byte[] byArray) throws Exception {
        CMSEnvelopedDataParser cMSEnvelopedDataParser = new CMSEnvelopedDataParser(byteArrayOutputStream.toByteArray());
        RecipientInformationStore recipientInformationStore = cMSEnvelopedDataParser.getRecipientInfos();
        EnvelopedDataStreamTest.assertEquals((String)cMSEnvelopedDataParser.getEncryptionAlgOID(), (String)string);
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataStreamTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            CMSTypedStream cMSTypedStream = recipientInformation.getContentStream(_reciKP.getPrivate(), "BC");
            EnvelopedDataStreamTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, CMSTestUtil.streamToByteArray(cMSTypedStream.getContentStream())));
        }
    }

    public void testKeyTransAES128BufferedStream() throws Exception {
        int n;
        byte[] byArray = new byte[2000];
        for (int i = 0; i != 2000; ++i) {
            byArray[i] = (byte)(i & 0xFF);
        }
        CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
        cMSEnvelopedDataStreamGenerator.addKeyTransRecipient(_reciCert);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = cMSEnvelopedDataStreamGenerator.open(byteArrayOutputStream, CMSEnvelopedDataGenerator.AES128_CBC, "BC");
        for (n = 0; n != 2000; ++n) {
            outputStream.write(byArray[n]);
        }
        outputStream.close();
        this.verifyData(byteArrayOutputStream, CMSEnvelopedDataGenerator.AES128_CBC, byArray);
        n = byteArrayOutputStream.toByteArray().length;
        cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
        cMSEnvelopedDataStreamGenerator.addKeyTransRecipient(_reciCert);
        byteArrayOutputStream = new ByteArrayOutputStream();
        outputStream = cMSEnvelopedDataStreamGenerator.open(byteArrayOutputStream, CMSEnvelopedDataGenerator.AES128_CBC, "BC");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 300);
        for (int i = 0; i != 2000; ++i) {
            bufferedOutputStream.write(byArray[i]);
        }
        bufferedOutputStream.close();
        this.verifyData(byteArrayOutputStream, CMSEnvelopedDataGenerator.AES128_CBC, byArray);
        EnvelopedDataStreamTest.assertTrue((byteArrayOutputStream.toByteArray().length < n ? 1 : 0) != 0);
    }

    public void testKeyTransAES128Buffered() throws Exception {
        int n;
        byte[] byArray = new byte[2000];
        for (int i = 0; i != 2000; ++i) {
            byArray[i] = (byte)(i & 0xFF);
        }
        CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
        cMSEnvelopedDataStreamGenerator.addKeyTransRecipient(_reciCert);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = cMSEnvelopedDataStreamGenerator.open(byteArrayOutputStream, CMSEnvelopedDataGenerator.AES128_CBC, "BC");
        for (n = 0; n != 2000; ++n) {
            outputStream.write(byArray[n]);
        }
        outputStream.close();
        this.verifyData(byteArrayOutputStream, CMSEnvelopedDataGenerator.AES128_CBC, byArray);
        n = byteArrayOutputStream.toByteArray().length;
        cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
        cMSEnvelopedDataStreamGenerator.setBufferSize(300);
        cMSEnvelopedDataStreamGenerator.addKeyTransRecipient(_reciCert);
        byteArrayOutputStream = new ByteArrayOutputStream();
        outputStream = cMSEnvelopedDataStreamGenerator.open(byteArrayOutputStream, CMSEnvelopedDataGenerator.AES128_CBC, "BC");
        for (int i = 0; i != 2000; ++i) {
            outputStream.write(byArray[i]);
        }
        outputStream.close();
        this.verifyData(byteArrayOutputStream, CMSEnvelopedDataGenerator.AES128_CBC, byArray);
        EnvelopedDataStreamTest.assertTrue((byteArrayOutputStream.toByteArray().length < n ? 1 : 0) != 0);
    }

    public void testKeyTransAES128() throws Exception {
        byte[] byArray = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
        cMSEnvelopedDataStreamGenerator.addKeyTransRecipient(_reciCert);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = cMSEnvelopedDataStreamGenerator.open(byteArrayOutputStream, CMSEnvelopedDataGenerator.AES128_CBC, "BC");
        outputStream.write(byArray);
        outputStream.close();
        CMSEnvelopedDataParser cMSEnvelopedDataParser = new CMSEnvelopedDataParser(byteArrayOutputStream.toByteArray());
        RecipientInformationStore recipientInformationStore = cMSEnvelopedDataParser.getRecipientInfos();
        EnvelopedDataStreamTest.assertEquals((String)cMSEnvelopedDataParser.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataStreamTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            CMSTypedStream cMSTypedStream = recipientInformation.getContentStream(_reciKP.getPrivate(), "BC");
            EnvelopedDataStreamTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, CMSTestUtil.streamToByteArray(cMSTypedStream.getContentStream())));
        }
    }

    public void testAESKEK() throws Exception {
        byte[] byArray = "WallaWallaWashington".getBytes();
        SecretKey secretKey = CMSTestUtil.makeAES192Key();
        CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5};
        cMSEnvelopedDataStreamGenerator.addKEKRecipient(secretKey, byArray2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = cMSEnvelopedDataStreamGenerator.open(byteArrayOutputStream, "1.2.840.113549.3.7", "BC");
        outputStream.write(byArray);
        outputStream.close();
        CMSEnvelopedDataParser cMSEnvelopedDataParser = new CMSEnvelopedDataParser(byteArrayOutputStream.toByteArray());
        RecipientInformationStore recipientInformationStore = cMSEnvelopedDataParser.getRecipientInfos();
        EnvelopedDataStreamTest.assertEquals((String)cMSEnvelopedDataParser.getEncryptionAlgOID(), (String)"1.2.840.113549.3.7");
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataStreamTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)"2.16.840.1.101.3.4.1.25");
            CMSTypedStream cMSTypedStream = recipientInformation.getContentStream(secretKey, "BC");
            EnvelopedDataStreamTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, CMSTestUtil.streamToByteArray(cMSTypedStream.getContentStream())));
        }
    }

    public static Test suite() throws Exception {
        EnvelopedDataStreamTest.init();
        return new CMSTestSetup((Test)new TestSuite(class$org$bouncycastle$cms$test$EnvelopedDataStreamTest == null ? (class$org$bouncycastle$cms$test$EnvelopedDataStreamTest = EnvelopedDataStreamTest.class$("org.bouncycastle.cms.test.EnvelopedDataStreamTest")) : class$org$bouncycastle$cms$test$EnvelopedDataStreamTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _initialised = false;
    }
}

