/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.SecretKey;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.CMSTestUtil;

public class EnvelopedDataTest
extends TestCase {
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static boolean _initialised;
    static /* synthetic */ Class class$org$bouncycastle$cms$test$EnvelopedDataTest;

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Class)(class$org$bouncycastle$cms$test$EnvelopedDataTest == null ? (class$org$bouncycastle$cms$test$EnvelopedDataTest = EnvelopedDataTest.class$("org.bouncycastle.cms.test.EnvelopedDataTest")) : class$org$bouncycastle$cms$test$EnvelopedDataTest));
    }

    public static Test suite() throws Exception {
        EnvelopedDataTest.init();
        return new CMSTestSetup((Test)new TestSuite(class$org$bouncycastle$cms$test$EnvelopedDataTest == null ? (class$org$bouncycastle$cms$test$EnvelopedDataTest = EnvelopedDataTest.class$("org.bouncycastle.cms.test.EnvelopedDataTest")) : class$org$bouncycastle$cms$test$EnvelopedDataTest));
    }

    public void testKeyTrans() throws Exception {
        byte[] byArray = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        cMSEnvelopedDataGenerator.addKeyTransRecipient(_reciCert);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.7");
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] byArray2 = recipientInformation.getContent(_reciKP.getPrivate(), "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
    }

    public void testKeyTransAES128() throws Exception {
        byte[] byArray = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        cMSEnvelopedDataGenerator.addKeyTransRecipient(_reciCert);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), CMSEnvelopedDataGenerator.AES128_CBC, "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] byArray2 = recipientInformation.getContent(_reciKP.getPrivate(), "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
    }

    public void testKeyTransAES192() throws Exception {
        byte[] byArray = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        cMSEnvelopedDataGenerator.addKeyTransRecipient(_reciCert);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), CMSEnvelopedDataGenerator.AES192_CBC, "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES192_CBC);
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
            byte[] byArray2 = recipientInformation.getContent(_reciKP.getPrivate(), "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
    }

    public void testKeyTransAES256() throws Exception {
        byte[] byArray = "WallaWallaWashington".getBytes();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        cMSEnvelopedDataGenerator.addKeyTransRecipient(_reciCert);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), CMSEnvelopedDataGenerator.AES256_CBC, "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"2.16.840.1.101.3.4.1.42");
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            byte[] byArray2 = recipientInformation.getContent(_reciKP.getPrivate(), "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
    }

    public void testKeyTransRC4() throws Exception {
        byte[] byArray = "WallaWallaBouncyCastle".getBytes();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        cMSEnvelopedDataGenerator.addKeyTransRecipient(_reciCert);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.4", "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.4");
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            byte[] byArray2 = recipientInformation.getContent(_reciKP.getPrivate(), "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
    }

    public void testKeyTrans128RC4() throws Exception {
        byte[] byArray = "WallaWallaBouncyCastle".getBytes();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        cMSEnvelopedDataGenerator.addKeyTransRecipient(_reciCert);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate((CMSProcessable)new CMSProcessableByteArray(byArray), "1.2.840.113549.3.4", 128, "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.4");
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            byte[] byArray2 = recipientInformation.getContent(_reciKP.getPrivate(), "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
    }

    public void testKeyTransODES() throws Exception {
        byte[] byArray = "WallaWallaBouncyCastle".getBytes();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        cMSEnvelopedDataGenerator.addKeyTransRecipient(_reciCert);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.3.14.3.2.7", "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.3.14.3.2.7");
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            byte[] byArray2 = recipientInformation.getContent(_reciKP.getPrivate(), "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
    }

    public void testKeyTransSmallAES() throws Exception {
        byte[] byArray = new byte[]{0, 1, 2, 3};
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        cMSEnvelopedDataGenerator.addKeyTransRecipient(_reciCert);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), CMSEnvelopedDataGenerator.AES128_CBC, "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            byte[] byArray2 = recipientInformation.getContent(_reciKP.getPrivate(), "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
    }

    public void testDESKEK() throws Exception {
        byte[] byArray = "WallaWallaWashington".getBytes();
        SecretKey secretKey = CMSTestUtil.makeDesede192Key();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5};
        cMSEnvelopedDataGenerator.addKEKRecipient(secretKey, byArray2);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.7");
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)"1.2.840.113549.1.9.16.3.6");
            byte[] byArray3 = recipientInformation.getContent(secretKey, "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray3));
        }
    }

    public void testAESKEK() throws Exception {
        byte[] byArray = "WallaWallaWashington".getBytes();
        SecretKey secretKey = CMSTestUtil.makeAES192Key();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5};
        cMSEnvelopedDataGenerator.addKEKRecipient(secretKey, byArray2);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.7");
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)"2.16.840.1.101.3.4.1.25");
            byte[] byArray3 = recipientInformation.getContent(secretKey, "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray3));
        }
    }

    public void testRC2KEK() throws Exception {
        byte[] byArray = "WallaWallaWashington".getBytes();
        SecretKey secretKey = CMSTestUtil.makeRC2128Key();
        CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5};
        cMSEnvelopedDataGenerator.addKEKRecipient(secretKey, byArray2);
        CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        Collection collection = recipientInformationStore.getRecipients();
        Iterator iterator = collection.iterator();
        EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.7");
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)"1.2.840.113549.1.9.16.3.7");
            byte[] byArray3 = recipientInformation.getContent(secretKey, "BC");
            EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray3));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _initialised = false;
    }
}

