/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.mail.smime.CMSProcessableBodyPartInbound;

public class CMSProcessableBodyPartOutbound
implements CMSProcessable {
    private BodyPart bodyPart;
    private String defaultContentTransferEncoding;

    public CMSProcessableBodyPartOutbound(BodyPart bodyPart) {
        this.bodyPart = bodyPart;
    }

    public CMSProcessableBodyPartOutbound(BodyPart bodyPart, String string) {
        this.bodyPart = bodyPart;
        this.defaultContentTransferEncoding = string;
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        try {
            if (this.bodyPart instanceof MimeBodyPart) {
                MimeBodyPart mimeBodyPart = (MimeBodyPart)this.bodyPart;
                String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
                String string = stringArray == null ? this.defaultContentTransferEncoding : stringArray[0];
                if (!string.equalsIgnoreCase("binary")) {
                    outputStream = new CMSProcessableBodyPartInbound.CRLFOutputStream(outputStream);
                }
                this.bodyPart.writeTo(outputStream);
            } else {
                if (!this.defaultContentTransferEncoding.equalsIgnoreCase("binary")) {
                    outputStream = new CMSProcessableBodyPartInbound.CRLFOutputStream(outputStream);
                }
                this.bodyPart.writeTo((OutputStream)new CMSProcessableBodyPartInbound.CRLFOutputStream(outputStream));
            }
        }
        catch (MessagingException messagingException) {
            throw new CMSException("can't write BodyPart to stream.", (Exception)((Object)messagingException));
        }
    }

    public Object getContent() {
        return this.bodyPart;
    }
}

