/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Part;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.test.SMIMETestSetup;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;

public class SMIMESignedTest
extends TestCase {
    boolean DEBUG = true;
    MimeBodyPart msg;
    String signDN;
    KeyPair signKP;
    X509Certificate signCert;
    String origDN;
    KeyPair origKP;
    X509Certificate origCert;
    String reciDN;
    KeyPair reciKP;
    X509Certificate reciCert;
    KeyPair dsaSignKP;
    X509Certificate dsaSignCert;
    KeyPair dsaOrigKP;
    X509Certificate dsaOrigCert;
    static /* synthetic */ Class class$org$bouncycastle$mail$smime$test$SMIMESignedTest;

    public SMIMESignedTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
        TestRunner.run((Class)(class$org$bouncycastle$mail$smime$test$SMIMESignedTest == null ? (class$org$bouncycastle$mail$smime$test$SMIMESignedTest = SMIMESignedTest.class$("org.bouncycastle.mail.smime.test.SMIMESignedTest")) : class$org$bouncycastle$mail$smime$test$SMIMESignedTest));
    }

    public static Test suite() {
        return new SMIMETestSetup((Test)new TestSuite(class$org$bouncycastle$mail$smime$test$SMIMESignedTest == null ? (class$org$bouncycastle$mail$smime$test$SMIMESignedTest = SMIMESignedTest.class$("org.bouncycastle.mail.smime.test.SMIMESignedTest")) : class$org$bouncycastle$mail$smime$test$SMIMESignedTest));
    }

    public void log(Exception exception) {
        if (this.DEBUG) {
            exception.printStackTrace();
        }
    }

    public void log(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public void setUp() {
        if (this.msg == null) {
            try {
                this.msg = SMIMETestUtil.makeMimeBodyPart("Hello world!");
                this.signDN = "O=Bouncy Castle, C=AU";
                this.signKP = SMIMETestUtil.makeKeyPair();
                this.signCert = SMIMETestUtil.makeCertificate(this.signKP, this.signDN, this.signKP, this.signDN);
                this.origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
                this.origKP = SMIMETestUtil.makeKeyPair();
                this.origCert = SMIMETestUtil.makeCertificate(this.origKP, this.origDN, this.signKP, this.signDN);
            }
            catch (Exception exception) {
                this.log(exception);
                SMIMESignedTest.fail();
            }
        }
    }

    public void tearDown() {
    }

    public void testSHA1WithRSA() {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
            sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
            aSN1EncodableVector.add((DEREncodable)new SMIMECapabilitiesAttribute(sMIMECapabilityVector));
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addSigner(this.origKP.getPrivate(), this.origCert, "1.3.14.3.2.26", new AttributeTable((DEREncodableVector)aSN1EncodableVector), null);
            sMIMESignedGenerator.addCertificatesAndCRLs(certStore);
            MimeMultipart mimeMultipart = sMIMESignedGenerator.generate(this.msg, "BC");
            MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(0);
            SMIMESigned sMIMESigned = new SMIMESigned(mimeMultipart);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.msg.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            sMIMESigned.getContent().writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMESignedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)iterator.next();
                Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator2 = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                SMIMESignedTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMESignedTest.fail();
        }
    }

    public void testSHA1WithRSAEncapsulated() {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
            sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
            aSN1EncodableVector.add((DEREncodable)new SMIMECapabilitiesAttribute(sMIMECapabilityVector));
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addSigner(this.origKP.getPrivate(), this.origCert, "1.3.14.3.2.26", new AttributeTable((DEREncodableVector)aSN1EncodableVector), null);
            sMIMESignedGenerator.addCertificatesAndCRLs(certStore);
            MimeBodyPart mimeBodyPart = sMIMESignedGenerator.generateEncapsulated(this.msg, "BC");
            SMIMESigned sMIMESigned = new SMIMESigned((Part)mimeBodyPart);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.msg.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            sMIMESigned.getContent().writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMESignedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)iterator.next();
                Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator2 = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                SMIMESignedTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMESignedTest.fail();
        }
    }

    public void testMD5WithRSA() {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addSigner(this.origKP.getPrivate(), this.origCert, "1.2.840.113549.2.5");
            sMIMESignedGenerator.addCertificatesAndCRLs(certStore);
            MimeMultipart mimeMultipart = sMIMESignedGenerator.generate(this.msg, "BC");
            MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(0);
            SMIMESigned sMIMESigned = new SMIMESigned(mimeMultipart);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.msg.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            sMIMESigned.getContent().writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMESignedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)iterator.next();
                Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator2 = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                SMIMESignedTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMESignedTest.fail();
        }
    }

    public void testSHA224WithRSA() {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addSigner(this.origKP.getPrivate(), this.origCert, SMIMESignedGenerator.DIGEST_SHA224);
            sMIMESignedGenerator.addCertificatesAndCRLs(certStore);
            MimeMultipart mimeMultipart = sMIMESignedGenerator.generate(this.msg, "BC");
            MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(0);
            SMIMESigned sMIMESigned = new SMIMESigned(mimeMultipart);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.msg.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            sMIMESigned.getContent().writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMESignedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)iterator.next();
                Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator2 = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                SMIMESignedTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMESignedTest.fail();
        }
    }

    public void testSHA1withDSA() {
        try {
            this.dsaSignKP = SMIMETestUtil.makeDSAKeyPair();
            this.dsaSignCert = SMIMETestUtil.makeCertificate(this.dsaSignKP, this.signDN, this.dsaSignKP, this.signDN);
            this.dsaOrigKP = SMIMETestUtil.makeDSAKeyPair();
            this.dsaOrigCert = SMIMETestUtil.makeCertificate(this.dsaOrigKP, this.origDN, this.dsaSignKP, this.signDN);
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(this.dsaOrigCert);
            arrayList.add(this.dsaSignCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addSigner(this.dsaOrigKP.getPrivate(), this.dsaOrigCert, "1.3.14.3.2.26");
            sMIMESignedGenerator.addCertificatesAndCRLs(certStore);
            MimeMultipart mimeMultipart = sMIMESignedGenerator.generate(this.msg, "BC");
            MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(0);
            SMIMESigned sMIMESigned = new SMIMESigned(mimeMultipart);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.msg.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            sMIMESigned.getContent().writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMESignedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)iterator.next();
                Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator2 = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                SMIMESignedTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMESignedTest.fail();
        }
    }

    public void testSHA256WithRSABinary() {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
            sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
            aSN1EncodableVector.add((DEREncodable)new SMIMECapabilitiesAttribute(sMIMECapabilityVector));
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addSigner(this.origKP.getPrivate(), this.origCert, SMIMESignedGenerator.DIGEST_SHA256, new AttributeTable((DEREncodableVector)aSN1EncodableVector), null);
            sMIMESignedGenerator.addCertificatesAndCRLs(certStore);
            InternetHeaders internetHeaders = new InternetHeaders();
            internetHeaders.setHeader("Content-Transfer-Encoding", "binary");
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 10, 11, 12, 13, 14, 10, 10, 15, 16};
            MimeBodyPart mimeBodyPart = new MimeBodyPart(internetHeaders, byArray);
            MimeMultipart mimeMultipart = sMIMESignedGenerator.generate(mimeBodyPart, "BC");
            MimeBodyPart mimeBodyPart2 = (MimeBodyPart)mimeMultipart.getBodyPart(0);
            SMIMESigned sMIMESigned = new SMIMESigned(mimeMultipart);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            sMIMESigned.getContent().writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            SMIMESignedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray2, byArray3));
            certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)iterator.next();
                Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator2 = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                SMIMESignedTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMESignedTest.fail();
        }
    }

    public void testCertificateManagement() {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addCertificatesAndCRLs(certStore);
            MimeBodyPart mimeBodyPart = sMIMESignedGenerator.generateCertificateManagement("BC");
            SMIMESigned sMIMESigned = new SMIMESigned((Part)mimeBodyPart);
            certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            SMIMESignedTest.assertEquals((int)2, (int)certStore.getCertificates(null).size());
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMESignedTest.fail();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

