/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1.test;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.sasn1.Asn1InputStream;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1Object;
import org.bouncycastle.sasn1.Asn1ObjectIdentifier;
import org.bouncycastle.sasn1.Asn1Sequence;
import org.bouncycastle.sasn1.BerSequenceGenerator;
import org.bouncycastle.sasn1.DerSequenceGenerator;
import org.bouncycastle.util.encoders.Hex;

public class Asn1SequenceTest
extends TestCase {
    private static final byte[] seqData = Hex.decode((String)"3006020100060129");
    private static final byte[] nestedSeqData = Hex.decode((String)"300b0201000601293003020101");
    private static final byte[] expTagSeqData = Hex.decode((String)"a1083006020100060129");
    private static final byte[] implTagSeqData = Hex.decode((String)"a106020100060129");
    private static final byte[] nestedSeqExpTagData = Hex.decode((String)"300d020100060129a1053003020101");
    private static final byte[] nestedSeqImpTagData = Hex.decode((String)"300b020100060129a103020101");
    private static final byte[] berSeqData = Hex.decode((String)"30800201000601290000");
    private static final byte[] berDerNestedSeqData = Hex.decode((String)"308002010006012930030201010000");
    private static final byte[] berNestedSeqData = Hex.decode((String)"3080020100060129308002010100000000");
    private static final byte[] berExpTagSeqData = Hex.decode((String)"a180308002010006012900000000");
    static /* synthetic */ Class class$org$bouncycastle$sasn1$test$Asn1SequenceTest;

    public void testDerWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DerSequenceGenerator derSequenceGenerator = new DerSequenceGenerator(byteArrayOutputStream);
        derSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        derSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        derSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"basic DER writing test failed.", (boolean)Arrays.equals(seqData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedDerWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DerSequenceGenerator derSequenceGenerator = new DerSequenceGenerator(byteArrayOutputStream);
        derSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        derSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        DerSequenceGenerator derSequenceGenerator2 = new DerSequenceGenerator(derSequenceGenerator.getRawOutputStream());
        derSequenceGenerator2.addObject(new Asn1Integer(BigInteger.valueOf(1L)));
        derSequenceGenerator2.close();
        derSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"nested DER writing test failed.", (boolean)Arrays.equals(nestedSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testDerExplicitTaggedSequenceWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DerSequenceGenerator derSequenceGenerator = new DerSequenceGenerator(byteArrayOutputStream, 1, true);
        derSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        derSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        derSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"explicit tag writing test failed.", (boolean)Arrays.equals(expTagSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testDerImplicitTaggedSequenceWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DerSequenceGenerator derSequenceGenerator = new DerSequenceGenerator(byteArrayOutputStream, 1, false);
        derSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        derSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        derSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"implicit tag writing test failed.", (boolean)Arrays.equals(implTagSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedExplicitTagDerWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DerSequenceGenerator derSequenceGenerator = new DerSequenceGenerator(byteArrayOutputStream);
        derSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        derSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        DerSequenceGenerator derSequenceGenerator2 = new DerSequenceGenerator(derSequenceGenerator.getRawOutputStream(), 1, true);
        derSequenceGenerator2.addObject(new Asn1Integer(BigInteger.valueOf(1L)));
        derSequenceGenerator2.close();
        derSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"nested explicit tagged DER writing test failed.", (boolean)Arrays.equals(nestedSeqExpTagData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedImplicitTagDerWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DerSequenceGenerator derSequenceGenerator = new DerSequenceGenerator(byteArrayOutputStream);
        derSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        derSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        DerSequenceGenerator derSequenceGenerator2 = new DerSequenceGenerator(derSequenceGenerator.getRawOutputStream(), 1, false);
        derSequenceGenerator2.addObject(new Asn1Integer(BigInteger.valueOf(1L)));
        derSequenceGenerator2.close();
        derSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"nested implicit tagged DER writing test failed.", (boolean)Arrays.equals(nestedSeqImpTagData, byteArrayOutputStream.toByteArray()));
    }

    public void testBerWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(byteArrayOutputStream);
        berSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        berSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        berSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"basic BER writing test failed.", (boolean)Arrays.equals(berSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedBerDerWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(byteArrayOutputStream);
        berSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        berSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        DerSequenceGenerator derSequenceGenerator = new DerSequenceGenerator(berSequenceGenerator.getRawOutputStream());
        derSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(1L)));
        derSequenceGenerator.close();
        berSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"nested BER/DER writing test failed.", (boolean)Arrays.equals(berDerNestedSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedBerWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(byteArrayOutputStream);
        berSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        berSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        BerSequenceGenerator berSequenceGenerator2 = new BerSequenceGenerator(berSequenceGenerator.getRawOutputStream());
        berSequenceGenerator2.addObject(new Asn1Integer(BigInteger.valueOf(1L)));
        berSequenceGenerator2.close();
        berSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"nested BER writing test failed.", (boolean)Arrays.equals(berNestedSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testDerReading() throws Exception {
        Asn1InputStream asn1InputStream = new Asn1InputStream(seqData);
        Asn1Sequence asn1Sequence = (Asn1Sequence)((Object)asn1InputStream.readObject());
        Asn1Object asn1Object = null;
        int n = 0;
        Asn1SequenceTest.assertNotNull((String)"null sequence returned", (Object)asn1Sequence);
        while ((asn1Object = asn1Sequence.readObject()) != null) {
            switch (n) {
                case 0: {
                    Asn1SequenceTest.assertTrue((boolean)(asn1Object instanceof Asn1Integer));
                    break;
                }
                case 1: {
                    Asn1SequenceTest.assertTrue((boolean)(asn1Object instanceof Asn1ObjectIdentifier));
                }
            }
            ++n;
        }
        Asn1SequenceTest.assertEquals((String)"wrong number of objects in sequence", (int)2, (int)n);
    }

    public void testNestedReading(byte[] byArray) throws Exception {
        Asn1InputStream asn1InputStream = new Asn1InputStream(byArray);
        Asn1Sequence asn1Sequence = (Asn1Sequence)((Object)asn1InputStream.readObject());
        Asn1Object asn1Object = null;
        int n = 0;
        Asn1SequenceTest.assertNotNull((String)"null sequence returned", (Object)asn1Sequence);
        while ((asn1Object = asn1Sequence.readObject()) != null) {
            switch (n) {
                case 0: {
                    Asn1SequenceTest.assertTrue((boolean)(asn1Object instanceof Asn1Integer));
                    break;
                }
                case 1: {
                    Asn1SequenceTest.assertTrue((boolean)(asn1Object instanceof Asn1ObjectIdentifier));
                    break;
                }
                case 2: {
                    Asn1SequenceTest.assertTrue((boolean)(asn1Object instanceof Asn1Sequence));
                    Asn1Sequence asn1Sequence2 = (Asn1Sequence)((Object)asn1Object);
                    asn1Sequence2.readObject();
                }
            }
            ++n;
        }
        Asn1SequenceTest.assertEquals((String)"wrong number of objects in sequence", (int)3, (int)n);
    }

    public void testNestedDerReading() throws Exception {
        this.testNestedReading(nestedSeqData);
    }

    public void testBerReading() throws Exception {
        Asn1InputStream asn1InputStream = new Asn1InputStream(berSeqData);
        Asn1Sequence asn1Sequence = (Asn1Sequence)((Object)asn1InputStream.readObject());
        Asn1Object asn1Object = null;
        int n = 0;
        Asn1SequenceTest.assertNotNull((String)"null sequence returned", (Object)asn1Sequence);
        while ((asn1Object = asn1Sequence.readObject()) != null) {
            switch (n) {
                case 0: {
                    Asn1SequenceTest.assertTrue((boolean)(asn1Object instanceof Asn1Integer));
                    break;
                }
                case 1: {
                    Asn1SequenceTest.assertTrue((boolean)(asn1Object instanceof Asn1ObjectIdentifier));
                }
            }
            ++n;
        }
        Asn1SequenceTest.assertEquals((String)"wrong number of objects in sequence", (int)2, (int)n);
    }

    public void testNestedBerDerReading() throws Exception {
        this.testNestedReading(berDerNestedSeqData);
    }

    public void testNestedBerReading() throws Exception {
        this.testNestedReading(berNestedSeqData);
    }

    public void testBerExplicitTaggedSequenceWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(byteArrayOutputStream, 1, true);
        berSequenceGenerator.addObject(new Asn1Integer(BigInteger.valueOf(0L)));
        berSequenceGenerator.addObject(new Asn1ObjectIdentifier("1.1"));
        berSequenceGenerator.close();
        Asn1SequenceTest.assertTrue((String)"explicit BER tag writing test failed.", (boolean)Arrays.equals(berExpTagSeqData, byteArrayOutputStream.toByteArray()));
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$sasn1$test$Asn1SequenceTest == null ? (class$org$bouncycastle$sasn1$test$Asn1SequenceTest = Asn1SequenceTest.class$("org.bouncycastle.sasn1.test.Asn1SequenceTest")) : class$org$bouncycastle$sasn1$test$Asn1SequenceTest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

