/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSContentInfoParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.sasn1.Asn1Object;
import org.bouncycastle.sasn1.Asn1OctetString;
import org.bouncycastle.sasn1.Asn1Sequence;
import org.bouncycastle.sasn1.Asn1Set;
import org.bouncycastle.sasn1.DerSequence;
import org.bouncycastle.sasn1.cms.ContentInfoParser;
import org.bouncycastle.sasn1.cms.SignedDataParser;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private SignedDataParser _signedData;
    private CMSTypedStream _signedContent;
    private Map _digests;
    private CertStore _certStore;
    private SignerInformationStore _signerInfoStore;

    public CMSSignedDataParser(byte[] byArray) throws CMSException {
        this(CMSSignedDataParser.readContentInfo(new ByteArrayInputStream(byArray)));
    }

    public CMSSignedDataParser(CMSTypedStream cMSTypedStream, byte[] byArray) throws CMSException {
        this(cMSTypedStream, CMSSignedDataParser.readContentInfo(new ByteArrayInputStream(byArray)));
    }

    public CMSSignedDataParser(CMSTypedStream cMSTypedStream, InputStream inputStream) throws CMSException {
        this(cMSTypedStream, CMSSignedDataParser.readContentInfo(inputStream));
    }

    public CMSSignedDataParser(InputStream inputStream) throws CMSException {
        this(CMSSignedDataParser.readContentInfo(inputStream));
    }

    CMSSignedDataParser(CMSTypedStream cMSTypedStream, ContentInfoParser contentInfoParser) throws CMSException {
        super(contentInfoParser);
        try {
            Object object;
            Object object2;
            Asn1Object asn1Object;
            this._signedContent = cMSTypedStream;
            this._signedData = new SignedDataParser((Asn1Sequence)((Object)this._contentInfo.getContent(16)));
            this._digests = new HashMap();
            Asn1Set asn1Set = this._signedData.getDigestAlgorithms();
            while ((asn1Object = asn1Set.readObject()) != null) {
                object2 = AlgorithmIdentifier.getInstance((Object)new ASN1InputStream(((DerSequence)asn1Object).getEncoded()).readObject());
                try {
                    object = MessageDigest.getInstance(CMSUtils.getDigestAlgName(object2.getObjectId().toString()));
                    this._digests.put(CMSUtils.getDigestAlgName(object2.getObjectId().toString()), object);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
            if (this._signedContent == null) {
                object2 = (Asn1OctetString)((Object)this._signedData.getEncapContentInfo().getContent(4));
                if (object2 != null) {
                    this._signedContent = new CMSTypedStream(object2.getOctetStream());
                }
            } else {
                object2 = (Asn1OctetString)((Object)this._signedData.getEncapContentInfo().getContent(4));
                object = object2.getOctetStream();
                while (((InputStream)object).read() >= 0) {
                }
            }
        }
        catch (IOException iOException) {
            throw new CMSException("io exception: " + iOException.getMessage(), iOException);
        }
        if (this._digests.isEmpty()) {
            throw new CMSException("no digests could be created for message.");
        }
    }

    public CMSSignedDataParser(ContentInfoParser contentInfoParser) throws CMSException {
        this(null, contentInfoParser);
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            HashMap hashMap = new HashMap();
            for (Object object : this._digests.keySet()) {
                hashMap.put(object, ((MessageDigest)this._digests.get(object)).digest());
            }
            try {
                Object object;
                object = this._signedData.getSignerInfos();
                Asn1Object asn1Object = null;
                while ((asn1Object = object.readObject()) != null) {
                    DerSequence derSequence = (DerSequence)asn1Object;
                    SignerInfo signerInfo = SignerInfo.getInstance((Object)new ASN1InputStream(derSequence.getEncoded()).readObject());
                    byte[] byArray = (byte[])hashMap.get(CMSUtils.getDigestAlgName(signerInfo.getDigestAlgorithm().getObjectId().getId()));
                    arrayList.add(new SignerInformation(signerInfo, new DERObjectIdentifier(this._signedContent.getContentType()), null, byArray));
                }
            }
            catch (IOException iOException) {
                throw new CMSException("io exception: " + iOException.getMessage(), iOException);
            }
            this._signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this._signerInfoStore;
    }

    public CertStore getCertificatesAndCRLs(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (this._certStore == null) {
            ArrayList<Object> arrayList;
            block16: {
                CertificateFactory certificateFactory;
                arrayList = new ArrayList<Object>();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    certificateFactory = CertificateFactory.getInstance("X.509", string2);
                }
                catch (CertificateException certificateException) {
                    throw new CMSException("can't get certificate factory.", certificateException);
                }
                try {
                    DerSequence derSequence;
                    Asn1Set asn1Set = this._signedData.getCertificates();
                    if (asn1Set != null) {
                        while ((derSequence = (DerSequence)asn1Set.readObject()) != null) {
                            try {
                                arrayList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(derSequence.getEncoded())));
                            }
                            catch (IOException iOException) {
                                throw new CMSException("can't re-encode certificate!", iOException);
                            }
                            catch (CertificateException certificateException) {
                                throw new CMSException("can't re-encode certificate!", certificateException);
                            }
                            byteArrayOutputStream.reset();
                        }
                    }
                    if ((asn1Set = this._signedData.getCrls()) == null) break block16;
                    while ((derSequence = (DerSequence)asn1Set.readObject()) != null) {
                        try {
                            arrayList.add(certificateFactory.generateCRL(new ByteArrayInputStream(derSequence.getEncoded())));
                        }
                        catch (IOException iOException) {
                            throw new CMSException("can't re-encode CRL!", iOException);
                        }
                        catch (CRLException cRLException) {
                            throw new CMSException("can't re-encode CRL!", cRLException);
                        }
                        byteArrayOutputStream.reset();
                    }
                }
                catch (IOException iOException) {
                    throw new CMSException("io exception: " + iOException.getMessage(), iOException);
                }
            }
            try {
                this._certStore = CertStore.getInstance(string, (CertStoreParameters)new CollectionCertStoreParameters(arrayList), string2);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new CMSException("can't setup the CertStore", invalidAlgorithmParameterException);
            }
        }
        return this._certStore;
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent != null) {
            InputStream inputStream = this._signedContent.getContentStream();
            Iterator iterator = this._digests.values().iterator();
            while (iterator.hasNext()) {
                inputStream = new DigestInputStream(inputStream, (MessageDigest)iterator.next());
            }
            return new CMSTypedStream(this._signedContent.getContentType(), inputStream);
        }
        return null;
    }
}

