/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerId;

public class SignerInformation {
    private SignerId sid;
    private SignerInfo info;
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier encryptionAlgorithm;
    private ASN1Set signedAttributes;
    private ASN1Set unsignedAttributes;
    private CMSProcessable content;
    private byte[] signature;
    private DERObjectIdentifier contentType;
    private byte[] _digest;

    SignerInformation(SignerInfo signerInfo, DERObjectIdentifier dERObjectIdentifier, CMSProcessable cMSProcessable, byte[] byArray) {
        this.info = signerInfo;
        this.sid = new SignerId();
        this.contentType = dERObjectIdentifier;
        try {
            SignerIdentifier signerIdentifier = signerInfo.getSID();
            if (signerIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)signerIdentifier.getId());
                this.sid.setSubjectKeyIdentifier(aSN1OctetString.getOctets());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)signerIdentifier.getId());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                aSN1OutputStream.writeObject((Object)issuerAndSerialNumber.getName());
                this.sid.setIssuer(byteArrayOutputStream.toByteArray());
                this.sid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid sid in SignerInfo");
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm();
        this.signedAttributes = signerInfo.getAuthenticatedAttributes();
        this.unsignedAttributes = signerInfo.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        this.signature = signerInfo.getEncryptedDigest().getOctets();
        this.content = cMSProcessable;
        this._digest = byArray;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)dEREncodable);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public SignerId getSID() {
        return this.sid;
    }

    public String getDigestAlgOID() {
        return this.digestAlgorithm.getObjectId().getId();
    }

    public byte[] getDigestAlgParams() {
        try {
            return this.encodeObj(this.digestAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting digest parameters " + exception);
        }
    }

    public String getEncryptionAlgOID() {
        return this.encryptionAlgorithm.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encryptionAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    String getDigestAlgName() {
        String string = this.getDigestAlgOID();
        if ("1.2.840.113549.2.5".equals(string)) {
            return "MD5";
        }
        if ("1.3.14.3.2.26".equals(string)) {
            return "SHA1";
        }
        if (CMSSignedDataGenerator.DIGEST_SHA224.equals(string)) {
            return "SHA224";
        }
        if (CMSSignedDataGenerator.DIGEST_SHA256.equals(string)) {
            return "SHA256";
        }
        if (CMSSignedDataGenerator.DIGEST_SHA384.equals(string)) {
            return "SHA384";
        }
        if (CMSSignedDataGenerator.DIGEST_SHA512.equals(string)) {
            return "SHA512";
        }
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equals(string)) {
            return "SHA1";
        }
        if (PKCSObjectIdentifiers.sha224WithRSAEncryption.getId().equals(string)) {
            return "SHA224";
        }
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equals(string)) {
            return "SHA256";
        }
        if (PKCSObjectIdentifiers.sha384WithRSAEncryption.getId().equals(string)) {
            return "SHA384";
        }
        if (PKCSObjectIdentifiers.sha512WithRSAEncryption.getId().equals(string)) {
            return "SHA512";
        }
        if (TeleTrusTObjectIdentifiers.ripemd128.getId().equals(string)) {
            return "RIPEMD128";
        }
        if (TeleTrusTObjectIdentifiers.ripemd160.getId().equals(string)) {
            return "RIPEMD160";
        }
        if (TeleTrusTObjectIdentifiers.ripemd256.getId().equals(string)) {
            return "RIPEMD256";
        }
        if (CryptoProObjectIdentifiers.gostR3411.getId().equals(string)) {
            return "GOST3411";
        }
        return string;
    }

    String getEncryptionAlgName() {
        String string = this.getEncryptionAlgOID();
        if ("1.2.840.10040.4.3".equals(string)) {
            return "DSA";
        }
        if ("1.2.840.10040.4.1".equals(string)) {
            return "DSA";
        }
        if ("1.2.840.113549.1.1.1".equals(string)) {
            return "RSA";
        }
        if (CMSSignedDataGenerator.ENCRYPTION_GOST3410.equals(string)) {
            return "GOST3410";
        }
        if (CMSSignedDataGenerator.ENCRYPTION_ECGOST3410.equals(string)) {
            return "ECGOST3410";
        }
        if ("1.2.840.113549.1.1.5".equals(string)) {
            return "RSA";
        }
        if (string.startsWith("1.3.36.3.3.1")) {
            return "RSA";
        }
        return string;
    }

    public AttributeTable getSignedAttributes() {
        if (this.signedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.signedAttributes);
    }

    public AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unsignedAttributes);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getEncodedSignedAttributes() throws IOException {
        if (this.signedAttributes != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)byteArrayOutputStream);
            dEROutputStream.writeObject((Object)this.signedAttributes);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    private boolean doVerify(PublicKey publicKey, AttributeTable attributeTable, String string) throws CMSException, NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest messageDigest;
        Signature signature;
        if (string != null) {
            signature = Signature.getInstance(this.getDigestAlgName() + "with" + this.getEncryptionAlgName(), string);
            try {
                messageDigest = MessageDigest.getInstance(this.getDigestAlgName(), string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                messageDigest = MessageDigest.getInstance(this.getDigestAlgName());
            }
        } else {
            signature = Signature.getInstance(this.getDigestAlgName() + "with" + this.getEncryptionAlgName());
            messageDigest = MessageDigest.getInstance(this.getDigestAlgName());
        }
        try {
            signature.initVerify(publicKey);
            if (this.signedAttributes == null) {
                this.content.write(new CMSSignedDataGenerator.SigOutputStream(signature));
            } else {
                Object object;
                byte[] byArray;
                if (this.content != null) {
                    this.content.write(new CMSSignedDataGenerator.DigOutputStream(messageDigest));
                    byArray = messageDigest.digest();
                } else {
                    byArray = this._digest;
                }
                Attribute attribute = attributeTable.get(CMSAttributes.messageDigest);
                Attribute attribute2 = attributeTable.get(CMSAttributes.contentType);
                if (attribute == null) {
                    throw new SignatureException("no hash for content found in signed attributes");
                }
                if (attribute2 == null) {
                    throw new SignatureException("no content type id found in signed attributes");
                }
                DERObject dERObject = attribute.getAttrValues().getObjectAt(0).getDERObject();
                if (dERObject instanceof ASN1OctetString) {
                    object = ((ASN1OctetString)dERObject).getOctets();
                    if (!MessageDigest.isEqual(byArray, object)) {
                        throw new SignatureException("content hash found in signed attributes different");
                    }
                } else if (dERObject instanceof DERNull && byArray != null) {
                    throw new SignatureException("NULL hash found in signed attributes when one expected");
                }
                if (!(object = (Object)((DERObjectIdentifier)attribute2.getAttrValues().getObjectAt(0))).equals((Object)this.contentType)) {
                    throw new SignatureException("contentType in signed attributes different");
                }
                signature.update(this.getEncodedSignedAttributes());
            }
            return signature.verify(this.getSignature());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key not appropriate to signature in message.", invalidKeyException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        catch (SignatureException signatureException) {
            throw new CMSException("invalid signature format in message: + " + signatureException.getMessage(), signatureException);
        }
    }

    public boolean verify(PublicKey publicKey, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.doVerify(publicKey, this.getSignedAttributes(), string);
    }

    public boolean verify(X509Certificate x509Certificate, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        Attribute attribute;
        AttributeTable attributeTable = this.getSignedAttributes();
        if (attributeTable != null && (attribute = attributeTable.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance((Object)attribute.getAttrValues().getObjectAt(0).getDERObject());
            x509Certificate.checkValidity(time.getDate());
        }
        return this.doVerify(x509Certificate.getPublicKey(), attributeTable, string);
    }

    SignerInfo toSignerInfo() {
        return this.info;
    }

    public static SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable attributeTable) {
        SignerInfo signerInfo = signerInformation.info;
        DERSet dERSet = null;
        if (attributeTable != null) {
            Hashtable hashtable = attributeTable.toHashtable();
            Iterator iterator = hashtable.values().iterator();
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            while (iterator.hasNext()) {
                aSN1EncodableVector.add((DEREncodable)Attribute.getInstance(iterator.next()));
            }
            dERSet = new DERSet((DEREncodableVector)aSN1EncodableVector);
        }
        return new SignerInformation(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), dERSet), signerInformation.contentType, signerInformation.content, null);
    }
}

