/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.util.encoders.Base64;

public class SignedDataStreamTest
extends TestCase {
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static boolean _initialised;

    public SignedDataStreamTest(String string) {
        super(string);
    }

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
        }
    }

    private void verifySignatures(CMSSignedDataParser cMSSignedDataParser) throws Exception {
        CertStore certStore = cMSSignedDataParser.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore signerInformationStore = cMSSignedDataParser.getSignerInfos();
        Collection collection = signerInformationStore.getSigners();
        for (SignerInformation signerInformation : collection) {
            Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
            Iterator<? extends Certificate> iterator = collection2.iterator();
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            SignedDataStreamTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
        }
    }

    private void verifyEncodedData(ByteArrayOutputStream byteArrayOutputStream) throws CMSException, IOException, Exception {
        CMSSignedDataParser cMSSignedDataParser = new CMSSignedDataParser(byteArrayOutputStream.toByteArray());
        cMSSignedDataParser.getSignedContent().drain();
        this.verifySignatures(cMSSignedDataParser);
    }

    public void testSha1EncapsulatedSignature() throws Exception {
        byte[] byArray = Base64.decode((String)"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");
        CMSSignedDataParser cMSSignedDataParser = new CMSSignedDataParser(byArray);
        cMSSignedDataParser.getSignedContent().drain();
        this.verifySignatures(cMSSignedDataParser);
    }

    public void testSHA1WithRSA() throws Exception {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        arrayList.add(_origCert);
        arrayList.add(_signCert);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
        CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
        cMSSignedDataStreamGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.3.14.3.2.26", "BC");
        cMSSignedDataStreamGenerator.addCertificatesAndCRLs(certStore);
        OutputStream outputStream = cMSSignedDataStreamGenerator.open(byteArrayOutputStream);
        outputStream.write("Hello World!".getBytes());
        outputStream.close();
        CMSSignedDataParser cMSSignedDataParser = new CMSSignedDataParser(new CMSTypedStream(new ByteArrayInputStream("Hello World!".getBytes())), byteArrayOutputStream.toByteArray());
        cMSSignedDataParser.getSignedContent().drain();
        this.verifySignatures(cMSSignedDataParser);
        cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
        cMSSignedDataStreamGenerator.addSigners(cMSSignedDataParser.getSignerInfos());
        cMSSignedDataStreamGenerator.addCertificatesAndCRLs(cMSSignedDataParser.getCertificatesAndCRLs("Collection", "BC"));
        byteArrayOutputStream.reset();
        outputStream = cMSSignedDataStreamGenerator.open(byteArrayOutputStream, true);
        outputStream.write("Hello World!".getBytes());
        outputStream.close();
        this.verifyEncodedData(byteArrayOutputStream);
    }

    public void testSHA1WithRSAEncapsulatedBufferedStream() throws Exception {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        arrayList.add(_origCert);
        arrayList.add(_signCert);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
        CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
        cMSSignedDataStreamGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.3.14.3.2.26", "BC");
        cMSSignedDataStreamGenerator.addCertificatesAndCRLs(certStore);
        OutputStream outputStream = cMSSignedDataStreamGenerator.open(byteArrayOutputStream, true);
        for (int i = 0; i != 2000; ++i) {
            outputStream.write(i & 0xFF);
        }
        outputStream.close();
        CMSSignedDataParser cMSSignedDataParser = new CMSSignedDataParser(byteArrayOutputStream.toByteArray());
        cMSSignedDataParser.getSignedContent().drain();
        this.verifySignatures(cMSSignedDataParser);
        int n = byteArrayOutputStream.toByteArray().length;
        byteArrayOutputStream = new ByteArrayOutputStream();
        cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
        cMSSignedDataStreamGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.3.14.3.2.26", "BC");
        cMSSignedDataStreamGenerator.addCertificatesAndCRLs(certStore);
        outputStream = cMSSignedDataStreamGenerator.open(byteArrayOutputStream, true);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 300);
        for (int i = 0; i != 2000; ++i) {
            bufferedOutputStream.write(i & 0xFF);
        }
        bufferedOutputStream.close();
        this.verifyEncodedData(byteArrayOutputStream);
        SignedDataStreamTest.assertTrue((byteArrayOutputStream.toByteArray().length < n ? 1 : 0) != 0);
    }

    public void testSHA1WithRSAEncapsulatedBuffered() throws Exception {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        arrayList.add(_origCert);
        arrayList.add(_signCert);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
        CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
        cMSSignedDataStreamGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.3.14.3.2.26", "BC");
        cMSSignedDataStreamGenerator.addCertificatesAndCRLs(certStore);
        OutputStream outputStream = cMSSignedDataStreamGenerator.open(byteArrayOutputStream, true);
        for (int i = 0; i != 2000; ++i) {
            outputStream.write(i & 0xFF);
        }
        outputStream.close();
        CMSSignedDataParser cMSSignedDataParser = new CMSSignedDataParser(byteArrayOutputStream.toByteArray());
        cMSSignedDataParser.getSignedContent().drain();
        this.verifySignatures(cMSSignedDataParser);
        int n = byteArrayOutputStream.toByteArray().length;
        byteArrayOutputStream = new ByteArrayOutputStream();
        cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
        cMSSignedDataStreamGenerator.setBufferSize(300);
        cMSSignedDataStreamGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.3.14.3.2.26", "BC");
        cMSSignedDataStreamGenerator.addCertificatesAndCRLs(certStore);
        outputStream = cMSSignedDataStreamGenerator.open(byteArrayOutputStream, true);
        for (int i = 0; i != 2000; ++i) {
            outputStream.write(i & 0xFF);
        }
        outputStream.close();
        this.verifyEncodedData(byteArrayOutputStream);
        SignedDataStreamTest.assertTrue((byteArrayOutputStream.toByteArray().length < n ? 1 : 0) != 0);
    }

    public void testSHA1WithRSAEncapsulated() throws Exception {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        arrayList.add(_origCert);
        arrayList.add(_signCert);
        CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
        CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
        cMSSignedDataStreamGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.3.14.3.2.26", "BC");
        cMSSignedDataStreamGenerator.addCertificatesAndCRLs(certStore);
        OutputStream outputStream = cMSSignedDataStreamGenerator.open(byteArrayOutputStream, true);
        outputStream.write("Hello World!".getBytes());
        outputStream.close();
        CMSSignedDataParser cMSSignedDataParser = new CMSSignedDataParser(byteArrayOutputStream.toByteArray());
        cMSSignedDataParser.getSignedContent().drain();
        this.verifySignatures(cMSSignedDataParser);
        cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
        cMSSignedDataStreamGenerator.addSigners(cMSSignedDataParser.getSignerInfos());
        cMSSignedDataStreamGenerator.addCertificatesAndCRLs(cMSSignedDataParser.getCertificatesAndCRLs("Collection", "BC"));
        byteArrayOutputStream.reset();
        outputStream = cMSSignedDataStreamGenerator.open(byteArrayOutputStream, true);
        outputStream.write("Hello World!".getBytes());
        outputStream.close();
        this.verifyEncodedData(byteArrayOutputStream);
    }

    public static Test suite() throws Exception {
        SignedDataStreamTest.init();
        return new CMSTestSetup((Test)new TestSuite(SignedDataStreamTest.class));
    }

    static {
        _initialised = false;
    }
}

