/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.internet.MimeBodyPart;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.test.CMSTestSetup;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.util.encoders.Base64;

public class SignedDataTest
extends TestCase {
    boolean DEBUG = true;
    MimeBodyPart msg;
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static KeyPair _signGostKP;
    private static X509Certificate _signGostCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static KeyPair _origGostKP;
    private static X509Certificate _origGostCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static KeyPair _dsaSignKP;
    private static X509Certificate _dsaSignCert;
    private static KeyPair _dsaOrigKP;
    private static X509Certificate _dsaOrigCert;
    private static boolean _initialised;
    private byte[] disorderedMessage = Base64.decode((String)"SU9fc3RkaW5fdXNlZABfX2xpYmNfc3RhcnRfbWFpbgBnZXRob3N0aWQAX19nbW9uX3M=");
    private byte[] disorderedSet = Base64.decode((String)"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");

    public SignedDataTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(SignedDataTest.class);
    }

    public static Test suite() throws Exception {
        SignedDataTest.init();
        return new CMSTestSetup((Test)new TestSuite(SignedDataTest.class));
    }

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _signGostKP = CMSTestUtil.makeGostKeyPair();
            _signGostCert = CMSTestUtil.makeCertificate(_signGostKP, _signDN, _signGostKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _origGostKP = CMSTestUtil.makeGostKeyPair();
            _origGostCert = CMSTestUtil.makeCertificate(_origGostKP, _origDN, _signGostKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
        }
    }

    public void testSHA1AndMD5WithRSAEncapsulatedRepeated() {
        try {
            X509Certificate x509Certificate;
            Iterator<? extends Certificate> iterator;
            Collection<? extends Certificate> collection;
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray("Hello World!".getBytes());
            arrayList.add(_origCert);
            arrayList.add(_signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.3.14.3.2.26");
            cMSSignedDataGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.2.840.113549.2.5");
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            SignedDataTest.assertEquals((int)2, (int)signerInformationStore.size());
            Collection collection2 = signerInformationStore.getSigners();
            Iterator iterator2 = collection2.iterator();
            SignerId signerId = null;
            while (iterator2.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)iterator2.next();
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                signerId = signerInformation.getSID();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            collection2 = signerInformationStore.getSigners(signerId);
            SignedDataTest.assertEquals((int)2, (int)collection2.size());
            cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigners(cMSSignedData.getSignerInfos());
            cMSSignedDataGenerator.addCertificatesAndCRLs(cMSSignedData.getCertificatesAndCRLs("Collection", "BC"));
            cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedData = CMSSignedData.replaceSigners(cMSSignedData, signerInformationStore);
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            SignedDataTest.fail();
        }
    }

    public void testSHA1WithRSAEncapsulated() {
        try {
            X509Certificate x509Certificate;
            Iterator<? extends Certificate> iterator;
            Collection<? extends Certificate> collection;
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray("Hello World!".getBytes());
            arrayList.add(_origCert);
            arrayList.add(_signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.3.14.3.2.26");
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigners(cMSSignedData.getSignerInfos());
            cMSSignedDataGenerator.addCertificatesAndCRLs(cMSSignedData.getCertificatesAndCRLs("Collection", "BC"));
            cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedData = CMSSignedData.replaceSigners(cMSSignedData, signerInformationStore);
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            SignedDataTest.fail();
        }
    }

    public void testSHA224WithRSAEncapsulated() {
        try {
            X509Certificate x509Certificate;
            Iterator<? extends Certificate> iterator;
            Collection<? extends Certificate> collection;
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray("Hello World!".getBytes());
            arrayList.add(_origCert);
            arrayList.add(_signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataGenerator.DIGEST_SHA224);
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigners(cMSSignedData.getSignerInfos());
            cMSSignedDataGenerator.addCertificatesAndCRLs(cMSSignedData.getCertificatesAndCRLs("Collection", "BC"));
            cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedData = CMSSignedData.replaceSigners(cMSSignedData, signerInformationStore);
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            SignedDataTest.fail();
        }
    }

    public void testSHA256WithRSAEncapsulated() {
        try {
            X509Certificate x509Certificate;
            Iterator<? extends Certificate> iterator;
            Collection<? extends Certificate> collection;
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray("Hello World!".getBytes());
            arrayList.add(_origCert);
            arrayList.add(_signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(_origKP.getPrivate(), _origCert, CMSSignedDataGenerator.DIGEST_SHA256);
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigners(cMSSignedData.getSignerInfos());
            cMSSignedDataGenerator.addCertificatesAndCRLs(cMSSignedData.getCertificatesAndCRLs("Collection", "BC"));
            cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedData = CMSSignedData.replaceSigners(cMSSignedData, signerInformationStore);
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            SignedDataTest.fail();
        }
    }

    public void testGOST3411WithGOST3410Encapsulated() {
        try {
            X509Certificate x509Certificate;
            Iterator<? extends Certificate> iterator;
            Collection<? extends Certificate> collection;
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray("Hello World!".getBytes());
            arrayList.add(_origGostCert);
            arrayList.add(_signGostCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(_origGostKP.getPrivate(), _origGostCert, CMSSignedDataGenerator.DIGEST_GOST3411);
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigners(cMSSignedData.getSignerInfos());
            cMSSignedDataGenerator.addCertificatesAndCRLs(cMSSignedData.getCertificatesAndCRLs("Collection", "BC"));
            cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedData = CMSSignedData.replaceSigners(cMSSignedData, signerInformationStore);
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            SignedDataTest.fail();
        }
    }

    public void testUnsortedAttributes() {
        try {
            CMSSignedData cMSSignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(this.disorderedMessage), this.disorderedSet);
            CertStore certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection) {
                Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            SignedDataTest.fail();
        }
    }

    public void testNullContentWithSigner() {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(_origCert);
            arrayList.add(_signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(_origKP.getPrivate(), _origCert, "1.3.14.3.2.26");
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(null, false, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection) {
                Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            SignedDataTest.fail();
        }
    }

    static {
        _initialised = false;
    }
}

