/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.SMIMECompressed;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.test.SMIMETestSetup;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;

public class SMIMECompressedTest
extends TestCase {
    boolean DEBUG = true;
    MimeBodyPart msg;
    String signDN;
    KeyPair signKP;
    X509Certificate signCert;
    String origDN;
    KeyPair origKP;
    X509Certificate origCert;
    String reciDN;
    KeyPair reciKP;
    X509Certificate reciCert;
    KeyPair dsaSignKP;
    X509Certificate dsaSignCert;
    KeyPair dsaOrigKP;
    X509Certificate dsaOrigCert;

    public SMIMECompressedTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
        TestRunner.run(SMIMECompressedTest.class);
    }

    public static Test suite() {
        return new SMIMETestSetup((Test)new TestSuite(SMIMECompressedTest.class));
    }

    public void log(Exception exception) {
        if (this.DEBUG) {
            exception.printStackTrace();
        }
    }

    public void log(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public void setUp() {
        try {
            this.msg = SMIMETestUtil.makeMimeBodyPart("Hello world!");
            this.signDN = "O=Bouncy Castle, C=AU";
            this.signKP = SMIMETestUtil.makeKeyPair();
            this.signCert = SMIMETestUtil.makeCertificate(this.signKP, this.signDN, this.signKP, this.signDN);
            this.origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
            this.origKP = SMIMETestUtil.makeKeyPair();
            this.origCert = SMIMETestUtil.makeCertificate(this.origKP, this.origDN, this.signKP, this.signDN);
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMECompressedTest.fail();
        }
    }

    public void tearDown() {
    }

    public void testSHA1WithRSA() {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
            sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
            aSN1EncodableVector.add((DEREncodable)new SMIMECapabilitiesAttribute(sMIMECapabilityVector));
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addSigner(this.origKP.getPrivate(), this.origCert, "1.3.14.3.2.26", new AttributeTable((DEREncodableVector)aSN1EncodableVector), null);
            sMIMESignedGenerator.addCertificatesAndCRLs(certStore);
            MimeMultipart mimeMultipart = sMIMESignedGenerator.generate(this.msg, "BC");
            String string = new ContentType(mimeMultipart.getContentType()).getParameter("boundary");
            MimeMessage mimeMessage = new MimeMessage((Session)null);
            mimeMessage.setContent((Object)mimeMultipart, mimeMultipart.getContentType());
            mimeMessage.saveChanges();
            SMIMECompressedGenerator sMIMECompressedGenerator = new SMIMECompressedGenerator();
            MimeBodyPart mimeBodyPart = sMIMECompressedGenerator.generate(mimeMessage, "1.2.840.113549.1.9.16.3.8");
            SMIMECompressed sMIMECompressed = new SMIMECompressed(mimeBodyPart);
            MimeBodyPart mimeBodyPart2 = (MimeBodyPart)mimeMultipart.getBodyPart(0);
            SMIMESigned sMIMESigned = new SMIMESigned((MimeMultipart)SMIMEUtil.toMimeBodyPart(sMIMECompressed.getContent()).getContent());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.msg.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            sMIMESigned.getContent().writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMECompressedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection) {
                Collection<? extends Certificate> collection2 = certStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                SMIMECompressedTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMECompressedTest.fail();
        }
    }
}

