/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.internet.MimeBodyPart;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.test.SMIMETestSetup;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;

public class SMIMEEnvelopedTest
extends TestCase {
    public boolean DEBUG = true;
    private static String _signDN;
    private static KeyPair _signKP;
    private static X509Certificate _signCert;
    private static String _origDN;
    private static KeyPair _origKP;
    private static X509Certificate _origCert;
    private static String _reciDN;
    private static KeyPair _reciKP;
    private static X509Certificate _reciCert;
    private static boolean _initialised;

    private static void init() throws Exception {
        if (!_initialised) {
            _initialised = true;
            _signDN = "O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _signKP, _signDN);
            _origDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _signKP, _signDN);
            _reciDN = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            _reciKP = CMSTestUtil.makeKeyPair();
            _reciCert = CMSTestUtil.makeCertificate(_reciKP, _reciDN, _signKP, _signDN);
        }
    }

    public SMIMEEnvelopedTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
        TestRunner.run(SMIMEEnvelopedTest.class);
    }

    public static Test suite() throws Exception {
        SMIMEEnvelopedTest.init();
        return new SMIMETestSetup((Test)new TestSuite(SMIMEEnvelopedTest.class));
    }

    public void log(Exception exception) {
        if (this.DEBUG) {
            exception.printStackTrace();
        }
    }

    public void log(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testDESEDE3Encrypted() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addKeyTransRecipient(_reciCert);
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.2.840.113549.3.7", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            recipientId.setSerialNumber(_reciCert.getSerialNumber());
            recipientId.setIssuer(_reciCert.getIssuerX500Principal().getEncoded());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(_reciKP.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMEEnvelopedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMEEnvelopedTest.fail();
        }
    }

    public void testIDEAEncrypted() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addKeyTransRecipient(_reciCert);
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.3.6.1.4.1.188.7.1.1.2", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            recipientId.setSerialNumber(_reciCert.getSerialNumber());
            recipientId.setIssuer(_reciCert.getIssuerX500Principal().getEncoded());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(_reciKP.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMEEnvelopedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMEEnvelopedTest.fail();
        }
    }

    public void testRC2Encrypted() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addKeyTransRecipient(_reciCert);
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.2.840.113549.3.2", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            recipientId.setSerialNumber(_reciCert.getSerialNumber());
            recipientId.setIssuer(_reciCert.getIssuerX500Principal().getEncoded());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(_reciKP.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMEEnvelopedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMEEnvelopedTest.fail();
        }
    }

    public void testCASTEncrypted() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addKeyTransRecipient(_reciCert);
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.2.840.113533.7.66.10", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            recipientId.setSerialNumber(_reciCert.getSerialNumber());
            recipientId.setIssuer(_reciCert.getIssuerX500Principal().getEncoded());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(_reciKP.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMEEnvelopedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMEEnvelopedTest.fail();
        }
    }

    public void testSubKeyId() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1", "BC");
            messageDigest.update(_reciCert.getPublicKey().getEncoded());
            sMIMEEnvelopedGenerator.addKeyTransRecipient(_reciCert.getPublicKey(), messageDigest.digest());
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.2.840.113549.3.7", "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            messageDigest.update(_reciCert.getPublicKey().getEncoded());
            recipientId.setSubjectKeyIdentifier(messageDigest.digest());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(_reciKP.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMEEnvelopedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMEEnvelopedTest.fail();
        }
    }

    public void testCapEncrypt() {
        try {
            MimeBodyPart mimeBodyPart = SMIMETestUtil.makeMimeBodyPart("WallaWallaWashington");
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1", "BC");
            messageDigest.update(_reciCert.getPublicKey().getEncoded());
            sMIMEEnvelopedGenerator.addKeyTransRecipient(_reciCert.getPublicKey(), messageDigest.digest());
            MimeBodyPart mimeBodyPart2 = sMIMEEnvelopedGenerator.generate(mimeBodyPart, "1.2.840.113549.3.2", 40, "BC");
            SMIMEEnveloped sMIMEEnveloped = new SMIMEEnveloped(mimeBodyPart2);
            RecipientId recipientId = new RecipientId();
            messageDigest.update(_reciCert.getPublicKey().getEncoded());
            recipientId.setSubjectKeyIdentifier(messageDigest.digest());
            RecipientInformationStore recipientInformationStore = sMIMEEnveloped.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get(recipientId);
            MimeBodyPart mimeBodyPart3 = SMIMEUtil.toMimeBodyPart(recipientInformation.getContent(_reciKP.getPrivate(), "BC"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart3.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            SMIMEEnvelopedTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
        }
        catch (Exception exception) {
            this.log(exception);
            SMIMEEnvelopedTest.fail();
        }
    }

    static {
        _initialised = false;
    }
}

