/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1.cms;

import java.io.IOException;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1Object;
import org.bouncycastle.sasn1.Asn1Sequence;
import org.bouncycastle.sasn1.Asn1Set;
import org.bouncycastle.sasn1.Asn1TaggedObject;
import org.bouncycastle.sasn1.cms.ContentInfoParser;

public class SignedDataParser {
    private Asn1Sequence _seq;
    private Asn1Integer _version;
    private Asn1Object _nextObject;

    public SignedDataParser(Asn1Sequence asn1Sequence) throws IOException {
        this._seq = asn1Sequence;
        this._version = (Asn1Integer)asn1Sequence.readObject();
    }

    public Asn1Integer getVersion() {
        return this._version;
    }

    public Asn1Set getDigestAlgorithms() throws IOException {
        return (Asn1Set)((Object)this._seq.readObject());
    }

    public ContentInfoParser getEncapContentInfo() throws IOException {
        return new ContentInfoParser((Asn1Sequence)((Object)this._seq.readObject()));
    }

    public Asn1Set getCertificates() throws IOException {
        this._nextObject = this._seq.readObject();
        if (this._nextObject instanceof Asn1TaggedObject && ((Asn1TaggedObject)this._nextObject).getTagNumber() == 0) {
            Asn1Set asn1Set = (Asn1Set)((Object)((Asn1TaggedObject)this._nextObject).getObject(17, false));
            this._nextObject = null;
            return asn1Set;
        }
        return null;
    }

    public Asn1Set getCrls() throws IOException {
        if (this._nextObject == null) {
            this._nextObject = this._seq.readObject();
        }
        if (this._nextObject instanceof Asn1TaggedObject && ((Asn1TaggedObject)this._nextObject).getTagNumber() == 1) {
            Asn1Set asn1Set = (Asn1Set)((Object)((Asn1TaggedObject)this._nextObject).getObject(17, false));
            this._nextObject = null;
            return asn1Set;
        }
        return null;
    }

    public Asn1Set getSignerInfos() throws IOException {
        if (this._nextObject == null) {
            this._nextObject = this._seq.readObject();
        }
        return (Asn1Set)((Object)this._nextObject);
    }
}

