/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public class PGPPublicKeyRing {
    ArrayList keys = new ArrayList();

    public PGPPublicKeyRing(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        Packet packet;
        BCPGInputStream bCPGInputStream = inputStream instanceof BCPGInputStream ? (BCPGInputStream)inputStream : new BCPGInputStream(inputStream);
        int n = bCPGInputStream.nextPacketTag();
        if (n != 6 && n != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(n));
        }
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Packet> arrayList3 = new ArrayList<Packet>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        PublicKeyPacket publicKeyPacket = (PublicKeyPacket)bCPGInputStream.readPacket();
        TrustPacket trustPacket = null;
        if (bCPGInputStream.nextPacketTag() == 12) {
            trustPacket = (TrustPacket)bCPGInputStream.readPacket();
        }
        while (bCPGInputStream.nextPacketTag() == 2) {
            try {
                packet = (SignaturePacket)bCPGInputStream.readPacket();
                if (bCPGInputStream.nextPacketTag() == 12) {
                    arrayList.add(new PGPSignature((SignaturePacket)packet, (TrustPacket)bCPGInputStream.readPacket()));
                    continue;
                }
                arrayList.add(new PGPSignature((SignaturePacket)packet));
            }
            catch (PGPException pGPException) {
                throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
            }
        }
        while (bCPGInputStream.nextPacketTag() == 13 || bCPGInputStream.nextPacketTag() == 17) {
            packet = bCPGInputStream.readPacket();
            if (packet instanceof UserIDPacket) {
                object2 = (UserIDPacket)packet;
                arrayList2.add(((UserIDPacket)object2).getID());
            } else {
                object2 = (UserAttributePacket)packet;
                arrayList2.add(new PGPUserAttributeSubpacketVector(((UserAttributePacket)object2).getSubpackets()));
            }
            if (bCPGInputStream.nextPacketTag() == 12) {
                arrayList3.add(bCPGInputStream.readPacket());
            } else {
                arrayList3.add(null);
            }
            object2 = new ArrayList();
            arrayList4.add(object2);
            while (bCPGInputStream.nextPacketTag() == 2) {
                try {
                    object = (SignaturePacket)bCPGInputStream.readPacket();
                    if (bCPGInputStream.nextPacketTag() == 12) {
                        ((ArrayList)object2).add(new PGPSignature((SignaturePacket)object, (TrustPacket)bCPGInputStream.readPacket()));
                        continue;
                    }
                    ((ArrayList)object2).add(new PGPSignature((SignaturePacket)object));
                }
                catch (PGPException pGPException) {
                    throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
                }
            }
        }
        this.keys.add(new PGPPublicKey(publicKeyPacket, trustPacket, arrayList, arrayList2, arrayList3, arrayList4));
        while (bCPGInputStream.nextPacketTag() == 14) {
            packet = (PublicKeyPacket)bCPGInputStream.readPacket();
            object2 = null;
            if (bCPGInputStream.nextPacketTag() == 12) {
                object2 = (TrustPacket)bCPGInputStream.readPacket();
            }
            object = new ArrayList();
            try {
                while (bCPGInputStream.nextPacketTag() == 2) {
                    SignaturePacket signaturePacket = (SignaturePacket)bCPGInputStream.readPacket();
                    if (bCPGInputStream.nextPacketTag() == 12) {
                        ((ArrayList)object).add(new PGPSignature(signaturePacket, (TrustPacket)bCPGInputStream.readPacket()));
                        continue;
                    }
                    ((ArrayList)object).add(new PGPSignature(signaturePacket));
                }
            }
            catch (PGPException pGPException) {
                throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
            }
            this.keys.add(new PGPPublicKey((PublicKeyPacket)packet, (TrustPacket)object2, (ArrayList)object));
        }
    }

    PGPPublicKeyRing(ArrayList arrayList) {
        this.keys = arrayList;
    }

    public PGPPublicKeyRing(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n = 0;
        while (n != this.keys.size()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(n);
            pGPPublicKey.encode(outputStream);
            ++n;
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    public PGPPublicKey getPublicKey(long l) throws PGPException {
        int n = 0;
        while (n != this.keys.size()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(n);
            if (l == pGPPublicKey.getKeyID()) {
                return pGPPublicKey;
            }
            ++n;
        }
        return null;
    }

    public Iterator getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(pGPPublicKeyRing.keys);
        boolean bl = false;
        int n = 0;
        while (n != arrayList.size()) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(n);
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                bl = true;
                arrayList.set(n, pGPPublicKey);
            }
            ++n;
        }
        if (!bl) {
            arrayList.add(pGPPublicKey);
        }
        return new PGPPublicKeyRing(arrayList);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList arrayList = new ArrayList(pGPPublicKeyRing.keys);
        boolean bl = false;
        int n = 0;
        while (n < arrayList.size()) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(n);
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                bl = true;
                arrayList.remove(n);
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        return new PGPPublicKeyRing(arrayList);
    }
}

