/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public class PGPSecretKeyRing {
    ArrayList keys;

    /*
     * Unable to fully structure code
     */
    public PGPSecretKeyRing(InputStream var1_1) throws IOException, PGPException {
        super();
        this.keys = new ArrayList<E>();
        var2_2 = var1_1 instanceof BCPGInputStream != false ? (BCPGInputStream)var1_1 : new BCPGInputStream(var1_1);
        var3_3 = var2_2.nextPacketTag();
        if (var3_3 != 5 && var3_3 != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(var3_3));
        }
        var4_4 = (SecretKeyPacket)var2_2.readPacket();
        var5_5 = null;
        var6_6 = new ArrayList<PGPSignature>();
        var7_7 = new ArrayList<Object>();
        var8_8 = new ArrayList<Packet>();
        var9_9 = new ArrayList<ArrayList<E>>();
        try {
            var10_10 = MessageDigest.getInstance("SHA1");
            if (true) ** GOTO lbl21
        }
        catch (NoSuchAlgorithmException v0) {
            throw new IOException("can't find SHA1 digest");
        }
        do {
            var2_2.readPacket();
lbl21:
            // 2 sources

        } while (var2_2.nextPacketTag() == 61);
        if (var2_2.nextPacketTag() == 12) {
            var5_5 = (TrustPacket)var2_2.readPacket();
        }
        while (var2_2.nextPacketTag() == 2) {
            try {
                var6_6.add(new PGPSignature(var2_2));
            }
            catch (PGPException var11_11) {
                throw new IOException("can't create signature object: " + var11_11.getMessage() + ", cause: " + var11_11.getUnderlyingException().toString());
            }
        }
        while (var2_2.nextPacketTag() == 13 || var2_2.nextPacketTag() == 17) {
            var11_12 = var2_2.readPacket();
            var12_13 = new ArrayList<PGPSignature>();
            if (var11_12 instanceof UserIDPacket) {
                var13_14 = (UserIDPacket)var11_12;
                var7_7.add(var13_14.getID());
            } else {
                var13_14 = (UserAttributePacket)var11_12;
                var7_7.add(new PGPUserAttributeSubpacketVector(var13_14.getSubpackets()));
            }
            if (var2_2.nextPacketTag() == 12) {
                var8_8.add(var2_2.readPacket());
            } else {
                var8_8.add(null);
            }
            var9_9.add(var12_13);
            while (var2_2.nextPacketTag() == 2) {
                var13_14 = (SignaturePacket)var2_2.readPacket();
                if (var2_2.nextPacketTag() == 12) {
                    var12_13.add(new PGPSignature((SignaturePacket)var13_14, (TrustPacket)var2_2.readPacket()));
                    continue;
                }
                var12_13.add(new PGPSignature((SignaturePacket)var13_14));
            }
        }
        this.keys.add(new PGPSecretKey(var4_4, var5_5, var10_10, var6_6, var7_7, var8_8, var9_9));
        while (var2_2.nextPacketTag() == 7) {
            var11_12 = (SecretSubkeyPacket)var2_2.readPacket();
            var12_13 = null;
            var13_14 = new ArrayList<E>();
            while (var2_2.nextPacketTag() == 61) {
                var2_2.readPacket();
            }
            if (var2_2.nextPacketTag() == 12) {
                var12_13 = (TrustPacket)var2_2.readPacket();
            }
            while (var2_2.nextPacketTag() == 2) {
                var14_15 = (SignaturePacket)var2_2.readPacket();
                if (var2_2.nextPacketTag() == 12) {
                    var13_14.add(new PGPSignature(var14_15, (TrustPacket)var2_2.readPacket()));
                    continue;
                }
                var13_14.add(new PGPSignature(var14_15));
            }
            this.keys.add(new PGPSecretKey((SecretKeyPacket)var11_12, (TrustPacket)var12_13, var10_10, (ArrayList)var13_14));
        }
    }

    PGPSecretKeyRing(ArrayList arrayList) {
        this.keys = new ArrayList();
        this.keys = arrayList;
    }

    public PGPSecretKeyRing(byte[] byArray) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray));
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n = 0;
        while (n != this.keys.size()) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(n);
            pGPSecretKey.encode(outputStream);
            ++n;
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public PGPSecretKey getSecretKey(long l) {
        int n = 0;
        while (n != this.keys.size()) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(n);
            if (l == pGPSecretKey.getKeyID()) {
                return pGPSecretKey;
            }
            ++n;
        }
        return null;
    }

    public Iterator getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys);
        boolean bl = false;
        int n = 0;
        while (n != arrayList.size()) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(n);
            if (pGPSecretKey2.getKeyID() == pGPSecretKey.getKeyID()) {
                bl = true;
                arrayList.set(n, pGPSecretKey);
            }
            ++n;
        }
        if (!bl) {
            arrayList.add(pGPSecretKey);
        }
        return new PGPSecretKeyRing(arrayList);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList arrayList = new ArrayList(pGPSecretKeyRing.keys);
        boolean bl = false;
        int n = 0;
        while (n < arrayList.size()) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(n);
            if (pGPSecretKey2.getKeyID() == pGPSecretKey.getKeyID()) {
                bl = true;
                arrayList.remove(n);
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        return new PGPSecretKeyRing(arrayList);
    }
}

