/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PGPArmoredTest
implements Test {
    byte[] sample = Base64.decode((String)"mQGiBEA83v0RBADzKVLVCnpWQxX0LCsevw/3OLs0H7MOcLBQ4wMO9sYmzGYnxpVj+4e4PiCP7QBayWyy4lugL6Lnw7tESvq3A4v3fefcxaCTkJrryiKn4+Cgy5rIBbrSKNtCEhVi7xjtdnDjP5kFKgHYjVOeIKn4Cz/yzPG3qz75kDknldLfyHxp2wCgwW1vAE5EnZU4/UmY7l8kTNkMltMEAJP4/uY4zcRwLI9Q2raPqAOJTYLd7h+3k/BxI0gIw96niQ3KmUZDlobbWBI+VHM6H99vcttKU3BgevNf8M9Gx/AbtW3SS4De64wNSU3189XDG8vXf0vuyW/K6Pcrb8exJWY0E1zZQ1WXT0gZW0kH3g5ro//Tusuil9q2lVLF2ovJA/0W+57bPzi318dWeNs0tTq6Njbc/GTGFUAVJ8Ss5v2u6h7gyJ1DB334ExF/UdqZGldp0ugkEXaSwBa2R7d3HBgaYcoPCk1TrovZzEY8gm7JNVy7GW6mdOZuDOHTxyADEEP2JPxh6eRcZbzhGuJuYIifIIeLOTI5Dc4XKeV32a+bWrQidGVzdCAoVGVzdCBrZXkpIDx0ZXN0QHViaWNhbGwuY29tPohkBBMRAgAkBQJAPN79AhsDBQkB4TOABgsJCAcDAgMVAgMDFgIBAh4BAheAAAoJEJh8Njfhe8KmGDcAoJWr8xgPr75y/Cp1kKn12oCCOb8zAJ4pxSvk4K6tB2jYbdeSrmoWBZLdMLACAAC5AQ0EQDzfARAEAJeUAPvUzJJbKcc55Iyb13+Gfb8xBWE3HinQzhGr1v6A1aIZbRj47UPAD/tQxwz8VAwJySx82ggNLxCk4jW9YtTL3uZqfczsJngV25GoIN10f4/j2BVqZAaX3q79a3eMiql1T0oEAGmD7tO1LkTvWfm3VvA0+t8/6ZeRLEiIqAOHAAQNBACD0mVMlAUgd7REYy/1mL99Zlu9XU0uKyUex99sJNrcx1aj8rIiZtWaHz6CN1XptdwpDeSYEOFZ0PSuqH9ByM3OfjU/ya0//xdvhwYXupn6P1Kep85efMBA9jUv/DeBOzRWMFG6sC6yk8NGG7Swea7EHKeQI40G3jgO/+xANtMyTIhPBBgRAgAPBQJAPN8BAhsMBQkB4TOAAAoJEJh8Njfhe8KmG7kAn00mTPGJCWqmskmzgdzeky5fWd7rAKCNCp3uZJhfg0htdgAfIy8ppm05vLACAAA=");
    byte[] marker = Hex.decode((String)"2d2d2d2d2d454e4420504750205055424c4943204b455920424c4f434b2d2d2d2d2d0a");

    public String getName() {
        return "PGPArmoredTest";
    }

    public static void main(String[] stringArray) {
        PGPArmoredTest pGPArmoredTest = new PGPArmoredTest();
        TestResult testResult = pGPArmoredTest.perform();
        System.out.println(testResult.toString());
    }

    private int markerCount(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            if (byArray[n] == 45) {
                int n3 = 0;
                while (n3 < this.marker.length) {
                    if (byArray[n + n3] != this.marker[n3]) break;
                    ++n3;
                }
                if (n3 == this.marker.length) {
                    ++n2;
                }
                n += n3;
                continue;
            }
            ++n;
        }
        return n2;
    }

    public TestResult perform() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
            armoredOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length != 0) {
                return new SimpleTestResult(false, "No data should have been written");
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
            armoredOutputStream.write(this.sample);
            armoredOutputStream.close();
            armoredOutputStream.close();
            if (this.markerCount(byteArrayOutputStream.toByteArray()) != 1) {
                return new SimpleTestResult(false, "More than one end marker found");
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString(), exception);
        }
    }
}

