/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.CompressionAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;

public class PGPCompressedDataGenerator
implements CompressionAlgorithmTags {
    private int algorithm;
    private int compression;
    private OutputStream out;
    private DeflaterOutputStream dOut;
    private BCPGOutputStream pkOut;

    public PGPCompressedDataGenerator(int n) {
        this(n, -1);
    }

    public PGPCompressedDataGenerator(int n, int n2) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("unknown compression algorithm");
        }
        if (n2 != -1 && (n2 < 0 || n2 > 9)) {
            throw new IllegalArgumentException("unknown compression level: " + n2);
        }
        this.algorithm = n;
        this.compression = n2;
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        this.out = outputStream;
        if (this.algorithm == 1) {
            this.pkOut = new BCPGOutputStream(outputStream, 8);
            this.pkOut.write(1);
            this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression, true));
        } else {
            this.pkOut = new BCPGOutputStream(outputStream, 8);
            this.pkOut.write(2);
            this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression));
        }
        return this.dOut;
    }

    public OutputStream open(OutputStream outputStream, byte[] byArray) throws IOException, PGPException {
        this.out = outputStream;
        if (this.algorithm == 1) {
            this.pkOut = new BCPGOutputStream(outputStream, 8, byArray);
            this.pkOut.write(1);
            this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression, true));
        } else {
            this.pkOut = new BCPGOutputStream(outputStream, 8, byArray);
            this.pkOut.write(2);
            this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression));
        }
        return this.dOut;
    }

    public void close() throws IOException {
        if (this.dOut == null) {
            throw new IOException("generator not opened.");
        }
        this.dOut.finish();
        ((FilterOutputStream)this.dOut).flush();
        this.pkOut.finish();
        this.pkOut.flush();
        this.out.flush();
    }
}

