/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PGPPBETest
implements Test {
    byte[] enc1 = Base64.decode((String)"jA0EAwMC5M5wWBP2HBZgySvUwWFAmMRLn7dWiZN6AkQMvpE3b6qwN3SSun7zInw2hxxdgFzVGfbjuB8w");
    byte[] enc1crc = Base64.decode((String)"H66L");
    char[] pass = new char[]{'h', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd'};

    private boolean notEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return true;
        }
        for (int i = 0; i != byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return true;
        }
        return false;
    }

    private byte[] decryptMessage(byte[] byArray) throws Exception {
        int n;
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(byArray);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)pGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream = pGPPBEEncryptedData.getDataStream(this.pass, "BC");
        PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(inputStream);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory2.nextObject();
        pGPObjectFactory2 = new PGPObjectFactory(pGPCompressedData.getDataStream());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory2.nextObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!pGPLiteralData.getFileName().equals("test.txt") && !pGPLiteralData.getFileName().equals("_CONSOLE")) {
            throw new RuntimeException("wrong filename in packet");
        }
        InputStream inputStream2 = pGPLiteralData.getInputStream();
        while ((n = inputStream2.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public TestResult perform() {
        try {
            byte[] byArray = this.decryptMessage(this.enc1);
            if (byArray[0] != 104 || byArray[1] != 101 || byArray[2] != 108) {
                return new SimpleTestResult(false, this.getName() + ": wrong plain text in packet");
            }
            byte[] byArray2 = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 33, 10};
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
            PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
            OutputStream outputStream = pGPLiteralDataGenerator.open(pGPCompressedDataGenerator.open(byteArrayOutputStream), 'b', "_CONSOLE", byArray2.length, new Date());
            outputStream.write(byArray2);
            pGPLiteralDataGenerator.close();
            pGPCompressedDataGenerator.close();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(3, new SecureRandom(), "BC");
            pGPEncryptedDataGenerator.addMethod(this.pass);
            OutputStream outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)byteArrayOutputStream2, byteArrayOutputStream.toByteArray().length);
            outputStream2.write(byteArrayOutputStream.toByteArray());
            outputStream2.close();
            byArray = this.decryptMessage(byteArrayOutputStream2.toByteArray());
            if (this.notEqual(byArray, byArray2)) {
                return new SimpleTestResult(false, this.getName() + ": wrong plain text in generated packet");
            }
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray3 = new byte[1233];
            secureRandom.nextBytes(byArray3);
            byteArrayOutputStream = new ByteArrayOutputStream();
            pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
            pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
            outputStream = pGPLiteralDataGenerator.open(pGPCompressedDataGenerator.open(byteArrayOutputStream), 'b', "_CONSOLE", new Date(), new byte[16]);
            outputStream.write(byArray3);
            pGPLiteralDataGenerator.close();
            pGPCompressedDataGenerator.close();
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(3, secureRandom, "BC");
            pGPEncryptedDataGenerator.addMethod(this.pass);
            outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)byteArrayOutputStream2, new byte[16]);
            outputStream2.write(byteArrayOutputStream.toByteArray());
            pGPEncryptedDataGenerator.close();
            byArray = this.decryptMessage(byteArrayOutputStream2.toByteArray());
            if (this.notEqual(byArray, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": wrong plain text in generated packet");
            }
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(3, true, secureRandom, "BC");
            pGPEncryptedDataGenerator.addMethod(this.pass);
            outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)byteArrayOutputStream2, new byte[16]);
            outputStream2.write(byteArrayOutputStream.toByteArray());
            pGPEncryptedDataGenerator.close();
            byArray = this.decryptMessage(byteArrayOutputStream2.toByteArray());
            if (this.notEqual(byArray, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": wrong plain text in generated packet");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "PGPPBETest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PGPPBETest pGPPBETest = new PGPPBETest();
        TestResult testResult = pGPPBETest.perform();
        System.out.println(testResult.toString());
    }
}

