/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1Null;
import org.bouncycastle.sasn1.Asn1Object;
import org.bouncycastle.sasn1.Asn1ObjectIdentifier;
import org.bouncycastle.sasn1.Asn1TaggedObject;
import org.bouncycastle.sasn1.BerOctetString;
import org.bouncycastle.sasn1.BerSequence;
import org.bouncycastle.sasn1.BerSet;
import org.bouncycastle.sasn1.DefiniteLengthInputStream;
import org.bouncycastle.sasn1.DerOctetString;
import org.bouncycastle.sasn1.DerSequence;
import org.bouncycastle.sasn1.DerSet;
import org.bouncycastle.sasn1.IndefiniteLengthInputStream;

public class Asn1InputStream {
    InputStream _in;
    private boolean _eofFound;

    public Asn1InputStream(InputStream inputStream) {
        this._in = inputStream;
    }

    public Asn1InputStream(byte[] byArray) {
        this._in = new ByteArrayInputStream(byArray);
    }

    InputStream getParentStream() {
        return this._in;
    }

    private int readLength() throws IOException {
        int n = this._in.read();
        if (n < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2 = n & 0x7F;
            if (n2 > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            n = 0;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this._in.read();
                if (n4 < 0) {
                    throw new IOException("EOF found reading length");
                }
                n = (n << 8) + n4;
                ++n3;
            }
            if (n < 0) {
                throw new IOException("corrupted steam - negative length found");
            }
        }
        return n;
    }

    public Asn1Object readObject() throws IOException {
        int n;
        int n2 = this._in.read();
        if (n2 == -1) {
            if (this._eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this._eofFound = true;
            return null;
        }
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(false);
        }
        int n3 = this.readLength();
        int n4 = n = n2 & 0xFFFFFFDF;
        if ((n2 & 0x80) != 0 && (n4 = n2 & 0x1F) == 31) {
            n4 = 0;
            int n5 = this._in.read();
            while (n5 >= 0 && (n5 & 0x80) != 0) {
                n4 |= n5 & 0x7F;
                n4 <<= 7;
                n5 = this._in.read();
            }
            n4 |= n5 & 0x7F;
        }
        if (n3 < 0) {
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this._in);
            switch (n) {
                case 5: {
                    return new Asn1Null(n2);
                }
                case 4: {
                    return new BerOctetString(n2, indefiniteLengthInputStream);
                }
                case 16: {
                    return new BerSequence(n2, indefiniteLengthInputStream);
                }
                case 17: {
                    return new BerSet(n2, indefiniteLengthInputStream);
                }
            }
            return new Asn1TaggedObject(n2, n4, indefiniteLengthInputStream);
        }
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this._in, n3);
        switch (n) {
            case 2: {
                return new Asn1Integer(n2, definiteLengthInputStream.toByteArray());
            }
            case 5: {
                return new Asn1Null(n2);
            }
            case 6: {
                return new Asn1ObjectIdentifier(n2, definiteLengthInputStream.toByteArray());
            }
            case 4: {
                return new DerOctetString(n2, definiteLengthInputStream.toByteArray());
            }
            case 16: {
                return new DerSequence(n2, definiteLengthInputStream.toByteArray());
            }
            case 17: {
                return new DerSet(n2, definiteLengthInputStream.toByteArray());
            }
        }
        return new Asn1TaggedObject(n2, n4, definiteLengthInputStream);
    }
}

