/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertIssuer;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.AttributeCertificateInfo;
import org.bouncycastle.asn1.x509.V2AttributeCertificateInfoGenerator;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.x509.AttributeCertificateHolder;
import org.bouncycastle.x509.AttributeCertificateIssuer;
import org.bouncycastle.x509.X509Attribute;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509Util;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class X509V2AttributeCertificateGenerator {
    private V2AttributeCertificateInfoGenerator acInfoGen = new V2AttributeCertificateInfoGenerator();
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private Hashtable extensions = null;
    private Vector extOrdering = null;

    public void addAttribute(X509Attribute x509Attribute) {
        this.acInfoGen.addAttribute(Attribute.getInstance(x509Attribute.toASN1Object()));
    }

    public void addExtension(String string, boolean bl, ASN1Encodable aSN1Encodable) throws IOException {
        this.addExtension(string, bl, aSN1Encodable.getEncoded());
    }

    public void addExtension(String string, boolean bl, byte[] byArray) {
        if (this.extensions == null) {
            this.extensions = new Hashtable();
            this.extOrdering = new Vector();
        }
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        this.extensions.put(dERObjectIdentifier, new X509Extension(bl, (ASN1OctetString)new DEROctetString(byArray)));
        this.extOrdering.addElement(dERObjectIdentifier);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey privateKey, String string) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateCertificate(privateKey, string, null);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey privateKey, String string, SecureRandom secureRandom) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        Object object;
        Signature signature = null;
        if (this.sigOID == null) {
            throw new IllegalStateException("no signature algorithm specified");
        }
        try {
            signature = Signature.getInstance(this.sigOID.getId(), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                signature = Signature.getInstance(this.signatureAlgorithm, string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new SecurityException("exception creating signature: " + noSuchAlgorithmException2.toString());
            }
        }
        if (secureRandom != null) {
            signature.initSign(privateKey, secureRandom);
        } else {
            signature.initSign(privateKey);
        }
        if (this.extensions != null) {
            this.acInfoGen.setExtensions(new X509Extensions(this.extOrdering, this.extensions));
        }
        AttributeCertificateInfo attributeCertificateInfo = this.acInfoGen.generateAttributeCertificateInfo();
        try {
            object = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)object);
            dEROutputStream.writeObject(attributeCertificateInfo);
            signature.update(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (Exception exception) {
            throw new SecurityException("exception encoding Attribute cert - " + exception);
        }
        object = new ASN1EncodableVector();
        ((DEREncodableVector)object).add(attributeCertificateInfo);
        ((DEREncodableVector)object).add(this.sigAlgId);
        ((DEREncodableVector)object).add(new DERBitString(signature.sign()));
        try {
            return new X509V2AttributeCertificate(new AttributeCertificate(new DERSequence((DEREncodableVector)object)));
        }
        catch (IOException iOException) {
            throw new RuntimeException("constructed invalid certificate!");
        }
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }

    public void reset() {
        this.acInfoGen = new V2AttributeCertificateInfoGenerator();
        this.extensions = null;
        this.extOrdering = null;
    }

    public void setHolder(AttributeCertificateHolder attributeCertificateHolder) {
        this.acInfoGen.setHolder(attributeCertificateHolder.holder);
    }

    public void setIssuer(AttributeCertificateIssuer attributeCertificateIssuer) {
        this.acInfoGen.setIssuer(AttCertIssuer.getInstance(attributeCertificateIssuer.form));
    }

    public void setIssuerUniqueId(boolean[] blArray) {
        throw new RuntimeException("not implemented (yet)");
    }

    public void setNotAfter(Date date) {
        this.acInfoGen.setEndDate(new DERGeneralizedTime(date));
    }

    public void setNotBefore(Date date) {
        this.acInfoGen.setStartDate(new DERGeneralizedTime(date));
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.acInfoGen.setSerialNumber(new DERInteger(bigInteger));
    }

    public void setSignatureAlgorithm(String string) {
        this.signatureAlgorithm = string;
        try {
            this.sigOID = X509Util.getAlgorithmOID(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = new AlgorithmIdentifier(this.sigOID, new DERNull());
        this.acInfoGen.setSignature(this.sigAlgId);
    }
}

