/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.Certificate;
import cryptix.pgp.FormatException;
import cryptix.pgp.KeyRingTrust;
import cryptix.pgp.KeyStore;
import cryptix.pgp.Packet;
import cryptix.pgp.PacketFactory;
import cryptix.pgp.PacketInputStream;
import cryptix.pgp.Signature;
import cryptix.pgp.UserId;
import cryptix.security.rsa.PublicKey;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public final class UserIdCertificate {
    private UserId name;
    private KeyRingTrust usertrust;
    private Signature[] sigs;
    private KeyRingTrust[] sigtrust;

    UserIdCertificate(UserId userId, KeyRingTrust keyRingTrust, Vector vector, Vector vector2) throws FormatException {
        this.name = userId;
        this.usertrust = keyRingTrust;
        this.initSigs(vector, vector2);
    }

    UserIdCertificate(PacketInputStream packetInputStream) throws IOException {
        this.restore(packetInputStream);
    }

    private final void initSigs(Vector vector, Vector vector2) throws FormatException {
        if (vector != null && vector2 != null) {
            int n = vector2.size();
            if (n != vector.size()) {
                throw new FormatException("Number of trust packets incorrect for number of signatures");
            }
            if (n > 0) {
                this.sigs = new Signature[n];
                vector.copyInto(this.sigs);
                this.sigtrust = new KeyRingTrust[n];
                vector2.copyInto(this.sigtrust);
                return;
            }
        }
        this.sigs = new Signature[0];
        this.sigtrust = new KeyRingTrust[0];
    }

    public String userName() {
        return this.name.toString();
    }

    public UserId userId() {
        return this.name;
    }

    public Signature[] signatures() {
        int n = this.sigs.length;
        Signature[] signatureArray = new Signature[n];
        System.arraycopy(this.sigs, 0, signatureArray, 0, n);
        return signatureArray;
    }

    boolean checkSignatures(KeyStore keyStore, Certificate certificate) {
        int n = this.sigs.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                PublicKey publicKey = keyStore.getKey(this.sigs[n2].getKeyId());
                if (publicKey != null) {
                    if (!KeyStore.checkSignature(publicKey, this.sigs[n2], certificate, this.name)) {
                        return false;
                    }
                } else {
                    System.err.println("Key id " + (Object)((Object)this.sigs[n2].getKeyId()) + " not found (Signature ignored)");
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException Signature ignored");
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Username:").append(this.name).append('\n').append(this.usertrust).append('\n');
        int n = this.sigs.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.sigs[n2]).append('\n').append(this.sigtrust[n2]).append('\n');
            ++n2;
        }
        return stringBuffer.toString();
    }

    void restore(PacketInputStream packetInputStream) throws IOException {
        Packet packet = packetInputStream.readPacket();
        if (!(packet instanceof UserId)) {
            throw new IOException("UserIdCetrificate must start with an UserId packet");
        }
        this.name = (UserId)packet;
        packet = packetInputStream.readPacket();
        if (!(packet instanceof KeyRingTrust)) {
            throw new IOException("KeyRingTrust expected not " + packet.getClass().getName());
        }
        this.usertrust = (KeyRingTrust)packet;
        Vector<Packet> vector = new Vector<Packet>();
        Vector<Packet> vector2 = new Vector<Packet>();
        while ((packet = packetInputStream.readPacket()) instanceof Signature) {
            if (packet == null) break;
            vector.addElement(packet);
            packet = packetInputStream.readPacket();
            if (!(packet instanceof KeyRingTrust)) {
                throw new IOException("KeyRingTrust expected not " + packet.getClass().getName());
            }
            vector2.addElement(packet);
        }
        packetInputStream.pushback(packet);
        this.initSigs(vector, vector2);
    }

    void write(DataOutput dataOutput) throws IOException {
        PacketFactory.write(dataOutput, this.name);
        PacketFactory.write(dataOutput, this.usertrust);
        int n = this.sigs.length;
        int n2 = 0;
        while (n2 < n) {
            PacketFactory.write(dataOutput, this.sigs[n2]);
            PacketFactory.write(dataOutput, this.sigtrust[n2]);
            ++n2;
        }
    }

    int getTrustValue() {
        return this.usertrust.trustValue() & 3;
    }
}

