/*
 * Decompiled with CFR 0.152.
 */
package cryptix;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import netscape.security.PrivilegeManager;

public class CryptixProperties {
    private static final int MAJOR_VERSION = 3;
    private static final int MINOR_VERSION = 1;
    private static final int INTER_VERSION = 1;
    private static final boolean IS_SNAPSHOT = false;
    private static final String CVS_DATE = "$Date: 1999/10/13 20:11:24 $";
    public static final boolean NATIVE_ALLOWED = true;
    static final String HTML_INFO = "<h1>" + CryptixProperties.getVersionString() + "</h1>\n" + "<p>\n" + "<b>Copyright</b> &copy; 1995-1999\n" + "<a href=\"http://www.systemics.com/\">Systemics Ltd</a> on behalf of the\n" + "<a href=\"http://www.cryptix.org/\">Cryptix Development Team</a>.\n" + "<br>All rights reserved.\n" + "<p>\n" + "This library includes, or is derived from software developed by\n" + "(and owned by):\n" + "<blockquote>\n" + "  Jill&nbsp;Baker, Paulo&nbsp;Barreto, George&nbsp;Barwood,\n" + "  Antoon&nbsp;Bosselaers, Ian&nbsp;Brown, Lawrence&nbsp;Brown,\n" + "  Joan&nbsp;Daemen, Richard&nbsp;De&nbsp;Moliner,\n" + "  John&nbsp;F.&nbspDumas, Jeroen&nbsp;Van&nbsp;Gelderen,\n" + "  Peter&nbsp;Gutmann, Ian&nbsp;Grigg,\n" + "  Mark&nbsp;A.&nbsp;Herschberg, Uwe&nbsp;Hollerbach,\n" + "  David&nbsp;Hopwood, Gary&nbsp;Howland, Geoffrey&nbsp;Keating,\n" + "  Sascha&nbsp;Kettler, Jonathon&nbsp;Knudsen, A.M.&nbsp;Kuchling,\n" + "  Matthew&nbsp;Kwan, Jerry&nbsp;McBride, Andrew&nsbp;E.&nsbp;Mileski,\n" + "  Raif&nbsp;Naffah, NIST, Bryan&nbsp;Olson, Zoran&nbsp;Rajic,\n" + "  Vincent&nbsp;Rijmen, RSA&nbsp;Data&nbsp;Security&nbsp;Inc.,\n" + "  Bruce&nbsp;Schneier, Systemics&nbsp;Ltd., Mike&nbsp;Wynn,\n" + "  Edwin&nbsp;Woudt, Thomas&nbsp;Wu, Eric&nbsp;Young, Yuliang&nbsp;Zheng.\n" + "</blockquote>\n" + "<p>\n" + "See the <a href=\"http://www.cryptix.org/\">site</a>\n" + "for further details.\n";
    static final String PRODUCT_NAME = "Cryptix";
    static final String LIB_DIRNAME = "cryptix-lib";
    static final String[] PROPERTIES_FILES = new String[]{"Cryptix.properties", "Local.properties"};
    private static final Properties properties = new Properties();
    private static String lib_path;

    private CryptixProperties() {
    }

    public static int getMajorVersion() {
        return 3;
    }

    public static int getMinorVersion() {
        return 1;
    }

    public static int getIntermediateVersion() {
        return 1;
    }

    public static boolean isVersionAtLeast(int n, int n2, int n3) {
        if (n < 3) {
            return true;
        }
        if (n > 3) {
            return false;
        }
        if (n2 < 1) {
            return true;
        }
        if (n2 > 1) {
            return false;
        }
        return n3 <= 1;
    }

    public static String getReleaseDate() {
        try {
            return CVS_DATE.substring(7, 17);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return "unknown";
        }
    }

    public static String getVersionString() {
        StringBuffer stringBuffer = new StringBuffer("Cryptix-Java ").append(3).append(".").append(1);
        stringBuffer.append(".").append(1);
        return stringBuffer.toString();
    }

    public static String getHtmlInfo() {
        return HTML_INFO;
    }

    public static void main(String[] stringArray) {
        System.out.println(CryptixProperties.getVersionString());
        System.out.println();
        if (Security.getProvider(PRODUCT_NAME) == null) {
            System.out.println("Cryptix is not installed as a provider in the java.security file.");
            System.out.println("Enter \"java cryptix.provider.Install\" to correct this.");
        } else {
            System.out.println("Cryptix is correctly installed in the java.security file.");
        }
        try {
            String string = CryptixProperties.getLibraryPath();
            System.out.println("The library directory is");
            System.out.println("  " + string);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public static String getLibraryPath() throws IOException {
        if (lib_path == null) {
            throw new IOException("Cryptix library directory (cryptix-lib) could not be found");
        }
        return lib_path;
    }

    private static void setProperties() {
        try {
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("path.separator");
        String string3 = System.getProperty("file.separator");
        try {
            PrivilegeManager.revertPrivilege((String)"UniversalPropertyRead");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string4 = stringTokenizer.nextToken();
            if (string4.endsWith(".zip") || string4.endsWith(".jar")) {
                int n = string4.lastIndexOf(string3);
                if (n == -1) continue;
                file = new File(string4.substring(0, n), LIB_DIRNAME);
            } else {
                file = new File(string4, LIB_DIRNAME);
            }
            try {
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            if (file.isDirectory()) {
                String string5 = file.getAbsolutePath();
                if (!string5.endsWith(string3)) {
                    string5 = String.valueOf(string5) + string3;
                }
                int n = 0;
                while (n < PROPERTIES_FILES.length) {
                    File file2 = new File(string5, PROPERTIES_FILES[n]);
                    if (file2.isFile()) {
                        try {
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                            properties.load(bufferedInputStream);
                            ((FilterInputStream)bufferedInputStream).close();
                            lib_path = string5;
                            bl = true;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    ++n;
                }
                if (bl) {
                    return;
                }
            }
            try {
                PrivilegeManager.revertPrivilege((String)"UniversalFileRead");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        System.err.println("Warning: failed to load the Cryptix properties file.\nMake sure that the CLASSPATH entry for Cryptix is an absolute path.");
    }

    public static void save(OutputStream outputStream, String string) {
        properties.save(outputStream, string);
    }

    public static String getProperty(String string) {
        return properties.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        return properties.getProperty(string, string2);
    }

    public static Enumeration propertyNames() {
        return properties.propertyNames();
    }

    public static void list(PrintStream printStream) {
        properties.list(printStream);
    }

    public static void list(PrintWriter printWriter) {
        properties.list(printWriter);
    }

    static {
        try {
            CryptixProperties.setProperties();
        }
        catch (Exception exception) {
            String string = "Warning: Unable to load the Cryptix properties file";
            if (lib_path != null) {
                string = String.valueOf(string) + " from directory " + lib_path;
            }
            System.err.println(string);
            exception.printStackTrace();
        }
    }
}

