/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.mode;

import cryptix.CryptixException;
import cryptix.provider.mode.FeedbackMode;
import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.security.Cipher;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;

public class CFB
extends FeedbackMode {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("CFB");
    private static final PrintWriter err = Debug.getOutput();
    private byte[] xorBlock;

    private static void debug(String string) {
        err.println("CFB: " + string);
    }

    public CFB() {
        super(true, false, "Cryptix");
    }

    public CFB(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public CFB(Cipher cipher, byte[] byArray) {
        this(cipher);
        this.setInitializationVector(byArray);
    }

    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.xorBlock = new byte[this.length];
    }

    protected int engineBlockSize() {
        return 1;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        this.currentByte = this.length;
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        this.currentByte = this.length;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("CFB: IV is not set");
        }
        if (byArray == byArray2 && n3 > n && (long)n3 < (long)n + (long)n2) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            byArray = byArray3;
            n = 0;
        }
        switch (this.getState()) {
            case 1: {
                int n4 = 0;
                while (n4 < n2) {
                    byArray2[n4 + n3] = this.encryptByte(byArray[n4 + n]);
                    ++n4;
                }
                break;
            }
            case 2: {
                int n5 = 0;
                while (n5 < n2) {
                    byArray2[n5 + n3] = this.decryptByte(byArray[n5 + n]);
                    ++n5;
                }
                break;
            }
            default: {
                throw new CryptixException("CFB: Cipher not initialized");
            }
        }
        return n2;
    }

    private byte encryptByte(byte by) {
        if (this.currentByte >= this.length) {
            this.currentByte = 0;
            if (this.ivStart == null) {
                this.ivStart = new byte[this.length];
                System.arraycopy(this.ivBlock, 0, this.ivStart, 0, this.length);
            }
            this.cipher.update(this.ivBlock, 0, this.length, this.xorBlock, 0);
        }
        this.ivBlock[this.currentByte] = by = (byte)(by ^ this.xorBlock[this.currentByte]);
        ++this.currentByte;
        return by;
    }

    private byte decryptByte(byte by) {
        if (this.currentByte >= this.length) {
            this.currentByte = 0;
            if (this.ivStart == null) {
                this.ivStart = new byte[this.length];
                System.arraycopy(this.ivBlock, 0, this.ivStart, 0, this.length);
            }
            this.cipher.update(this.ivBlock, 0, this.length, this.xorBlock, 0);
        }
        this.ivBlock[this.currentByte] = by;
        by = (byte)(by ^ this.xorBlock[this.currentByte]);
        ++this.currentByte;
        return by;
    }

    protected void next_block() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.ivBlock, this.currentByte, byArray, 0, this.length - this.currentByte);
        System.arraycopy(this.ivBlock, 0, byArray, this.length - this.currentByte, this.currentByte);
        this.ivBlock = byArray;
        this.currentByte = this.length;
    }
}

