/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.security.Cipher;
import java.security.Key;

class TestRC2
extends BaseTest {
    private Cipher alg;

    public static void main(String[] stringArray) {
        new TestRC2().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(5);
        this.alg = Cipher.getInstance((String)"RC2", (String)"Cryptix");
        this.test1();
        this.test2();
    }

    private void test1() throws Exception {
        String[][] stringArrayArray = new String[][]{{"88bca90e90875a7f0f79c384627bafb2", "0000000000000000", "2269552ab0f85ca6"}, {"3000000000000000", "1000000000000001", "30649edf9be7d2c2"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("RC2", Hex.fromString((String)stringArrayArray[n][0]));
            this.out.println("\nTest vector " + (n + 1) + " (Encrypting):\n");
            this.alg.initEncrypt((Key)rawSecretKey);
            this.compareIt(this.alg.crypt(Hex.fromString((String)stringArrayArray[n][1])), Hex.fromString((String)stringArrayArray[n][2]));
            this.out.println("\n..............(Decrypting):\n");
            this.alg.initDecrypt((Key)rawSecretKey);
            this.compareIt(this.alg.crypt(Hex.fromString((String)stringArrayArray[n][2])), Hex.fromString((String)stringArrayArray[n][1]));
            ++n;
        }
    }

    private void test2() throws Exception {
        int[] nArray = new int[512];
        nArray[0] = 117;
        nArray[1] = 149;
        nArray[2] = 195;
        nArray[3] = 230;
        nArray[4] = 17;
        nArray[5] = 74;
        nArray[6] = 9;
        nArray[7] = 120;
        nArray[8] = 12;
        nArray[9] = 74;
        nArray[10] = 212;
        nArray[11] = 82;
        nArray[12] = 51;
        nArray[13] = 142;
        nArray[14] = 31;
        nArray[15] = 253;
        nArray[16] = 154;
        nArray[17] = 27;
        nArray[18] = 233;
        nArray[19] = 73;
        nArray[20] = 143;
        nArray[21] = 129;
        nArray[22] = 61;
        nArray[23] = 118;
        nArray[24] = 83;
        nArray[25] = 52;
        nArray[26] = 73;
        nArray[27] = 182;
        nArray[28] = 119;
        nArray[29] = 141;
        nArray[30] = 202;
        nArray[31] = 216;
        nArray[32] = 199;
        nArray[33] = 138;
        nArray[34] = 141;
        nArray[35] = 43;
        nArray[36] = 169;
        nArray[37] = 172;
        nArray[38] = 102;
        nArray[39] = 8;
        nArray[40] = 93;
        nArray[41] = 14;
        nArray[42] = 83;
        nArray[43] = 213;
        nArray[44] = 156;
        nArray[45] = 38;
        nArray[46] = 194;
        nArray[47] = 209;
        nArray[48] = 196;
        nArray[49] = 144;
        nArray[50] = 193;
        nArray[51] = 235;
        nArray[52] = 190;
        nArray[53] = 12;
        nArray[54] = 230;
        nArray[55] = 109;
        nArray[56] = 27;
        nArray[57] = 107;
        nArray[58] = 27;
        nArray[59] = 19;
        nArray[60] = 182;
        nArray[61] = 185;
        nArray[62] = 25;
        nArray[63] = 184;
        nArray[64] = 71;
        nArray[65] = 194;
        nArray[66] = 90;
        nArray[67] = 145;
        nArray[68] = 68;
        nArray[69] = 122;
        nArray[70] = 149;
        nArray[71] = 231;
        nArray[72] = 94;
        nArray[73] = 78;
        nArray[74] = 241;
        nArray[75] = 103;
        nArray[76] = 121;
        nArray[77] = 205;
        nArray[78] = 232;
        nArray[79] = 191;
        nArray[80] = 10;
        nArray[81] = 149;
        nArray[82] = 133;
        nArray[83] = 14;
        nArray[84] = 50;
        nArray[85] = 175;
        nArray[86] = 150;
        nArray[87] = 137;
        nArray[88] = 68;
        nArray[89] = 79;
        nArray[90] = 211;
        nArray[91] = 119;
        nArray[92] = 16;
        nArray[93] = 143;
        nArray[94] = 152;
        nArray[95] = 253;
        nArray[96] = 203;
        nArray[97] = 212;
        nArray[98] = 231;
        nArray[99] = 38;
        nArray[100] = 86;
        nArray[101] = 117;
        nArray[103] = 153;
        nArray[104] = 11;
        nArray[105] = 204;
        nArray[106] = 126;
        nArray[107] = 12;
        nArray[108] = 163;
        nArray[109] = 196;
        nArray[110] = 170;
        nArray[111] = 163;
        nArray[112] = 4;
        nArray[113] = 163;
        nArray[114] = 135;
        nArray[115] = 210;
        nArray[116] = 15;
        nArray[117] = 59;
        nArray[118] = 143;
        nArray[119] = 187;
        nArray[120] = 205;
        nArray[121] = 66;
        nArray[122] = 161;
        nArray[123] = 189;
        nArray[124] = 49;
        nArray[125] = 29;
        nArray[126] = 122;
        nArray[127] = 67;
        nArray[128] = 3;
        nArray[129] = 221;
        nArray[130] = 165;
        nArray[131] = 171;
        nArray[132] = 7;
        nArray[133] = 136;
        nArray[134] = 150;
        nArray[135] = 174;
        nArray[136] = 128;
        nArray[137] = 193;
        nArray[138] = 139;
        nArray[139] = 10;
        nArray[140] = 246;
        nArray[141] = 109;
        nArray[142] = 255;
        nArray[143] = 49;
        nArray[144] = 150;
        nArray[145] = 22;
        nArray[146] = 235;
        nArray[147] = 120;
        nArray[148] = 78;
        nArray[149] = 73;
        nArray[150] = 90;
        nArray[151] = 210;
        nArray[152] = 206;
        nArray[153] = 144;
        nArray[154] = 215;
        nArray[155] = 247;
        nArray[156] = 114;
        nArray[157] = 168;
        nArray[158] = 23;
        nArray[159] = 71;
        nArray[160] = 182;
        nArray[161] = 95;
        nArray[162] = 98;
        nArray[163] = 9;
        nArray[164] = 59;
        nArray[165] = 30;
        nArray[166] = 13;
        nArray[167] = 185;
        nArray[168] = 229;
        nArray[169] = 186;
        nArray[170] = 83;
        nArray[171] = 47;
        nArray[172] = 175;
        nArray[173] = 236;
        nArray[174] = 71;
        nArray[175] = 80;
        nArray[176] = 131;
        nArray[177] = 35;
        nArray[178] = 230;
        nArray[179] = 113;
        nArray[180] = 50;
        nArray[181] = 125;
        nArray[182] = 249;
        nArray[183] = 68;
        nArray[184] = 68;
        nArray[185] = 50;
        nArray[186] = 203;
        nArray[187] = 115;
        nArray[188] = 103;
        nArray[189] = 206;
        nArray[190] = 200;
        nArray[191] = 47;
        nArray[192] = 93;
        nArray[193] = 68;
        nArray[194] = 192;
        nArray[195] = 208;
        nArray[196] = 11;
        nArray[197] = 103;
        nArray[198] = 214;
        nArray[199] = 80;
        nArray[200] = 160;
        nArray[201] = 117;
        nArray[202] = 205;
        nArray[203] = 75;
        nArray[204] = 112;
        nArray[205] = 222;
        nArray[206] = 221;
        nArray[207] = 119;
        nArray[208] = 235;
        nArray[209] = 155;
        nArray[210] = 16;
        nArray[211] = 35;
        nArray[212] = 27;
        nArray[213] = 107;
        nArray[214] = 91;
        nArray[215] = 116;
        nArray[216] = 19;
        nArray[217] = 71;
        nArray[218] = 57;
        nArray[219] = 109;
        nArray[220] = 98;
        nArray[221] = 137;
        nArray[222] = 116;
        nArray[223] = 33;
        nArray[224] = 212;
        nArray[225] = 61;
        nArray[226] = 249;
        nArray[227] = 180;
        nArray[228] = 46;
        nArray[229] = 68;
        nArray[230] = 110;
        nArray[231] = 53;
        nArray[232] = 142;
        nArray[233] = 156;
        nArray[234] = 17;
        nArray[235] = 169;
        nArray[236] = 178;
        nArray[237] = 24;
        nArray[238] = 78;
        nArray[239] = 203;
        nArray[240] = 239;
        nArray[241] = 12;
        nArray[242] = 216;
        nArray[243] = 231;
        nArray[244] = 168;
        nArray[245] = 119;
        nArray[246] = 239;
        nArray[247] = 150;
        nArray[248] = 143;
        nArray[249] = 19;
        nArray[250] = 144;
        nArray[251] = 236;
        nArray[252] = 155;
        nArray[253] = 61;
        nArray[254] = 53;
        nArray[255] = 165;
        nArray[256] = 88;
        nArray[257] = 92;
        nArray[258] = 176;
        nArray[259] = 9;
        nArray[260] = 41;
        nArray[261] = 14;
        nArray[262] = 47;
        nArray[263] = 205;
        nArray[264] = 231;
        nArray[265] = 181;
        nArray[266] = 236;
        nArray[267] = 102;
        nArray[268] = 217;
        nArray[269] = 8;
        nArray[270] = 75;
        nArray[271] = 228;
        nArray[272] = 64;
        nArray[273] = 85;
        nArray[274] = 166;
        nArray[275] = 25;
        nArray[276] = 217;
        nArray[277] = 221;
        nArray[278] = 127;
        nArray[279] = 195;
        nArray[280] = 22;
        nArray[281] = 111;
        nArray[282] = 148;
        nArray[283] = 135;
        nArray[284] = 247;
        nArray[285] = 203;
        nArray[286] = 39;
        nArray[287] = 41;
        nArray[288] = 18;
        nArray[289] = 66;
        nArray[290] = 100;
        nArray[291] = 69;
        nArray[292] = 153;
        nArray[293] = 133;
        nArray[294] = 20;
        nArray[295] = 193;
        nArray[296] = 93;
        nArray[297] = 83;
        nArray[298] = 161;
        nArray[299] = 140;
        nArray[300] = 134;
        nArray[301] = 76;
        nArray[302] = 227;
        nArray[303] = 162;
        nArray[304] = 183;
        nArray[305] = 85;
        nArray[306] = 87;
        nArray[307] = 147;
        nArray[308] = 152;
        nArray[309] = 129;
        nArray[310] = 38;
        nArray[311] = 82;
        nArray[312] = 14;
        nArray[313] = 172;
        nArray[314] = 242;
        nArray[315] = 227;
        nArray[316] = 6;
        nArray[317] = 110;
        nArray[318] = 35;
        nArray[319] = 12;
        nArray[320] = 145;
        nArray[321] = 190;
        nArray[322] = 228;
        nArray[323] = 221;
        nArray[324] = 83;
        nArray[325] = 4;
        nArray[326] = 245;
        nArray[327] = 253;
        nArray[328] = 4;
        nArray[329] = 5;
        nArray[330] = 179;
        nArray[331] = 91;
        nArray[332] = 217;
        nArray[333] = 156;
        nArray[334] = 115;
        nArray[335] = 19;
        nArray[336] = 93;
        nArray[337] = 61;
        nArray[338] = 155;
        nArray[339] = 195;
        nArray[340] = 53;
        nArray[341] = 238;
        nArray[342] = 4;
        nArray[343] = 158;
        nArray[344] = 246;
        nArray[345] = 155;
        nArray[346] = 56;
        nArray[347] = 103;
        nArray[348] = 191;
        nArray[349] = 45;
        nArray[350] = 123;
        nArray[351] = 209;
        nArray[352] = 234;
        nArray[353] = 165;
        nArray[354] = 149;
        nArray[355] = 216;
        nArray[356] = 191;
        nArray[357] = 192;
        nArray[358] = 6;
        nArray[359] = 111;
        nArray[360] = 248;
        nArray[361] = 211;
        nArray[362] = 21;
        nArray[363] = 9;
        nArray[364] = 235;
        nArray[365] = 12;
        nArray[366] = 108;
        nArray[367] = 170;
        nArray[369] = 108;
        nArray[370] = 128;
        nArray[371] = 122;
        nArray[372] = 98;
        nArray[373] = 62;
        nArray[374] = 248;
        nArray[375] = 76;
        nArray[376] = 61;
        nArray[377] = 51;
        nArray[378] = 193;
        nArray[379] = 149;
        nArray[380] = 210;
        nArray[381] = 62;
        nArray[382] = 227;
        nArray[383] = 32;
        nArray[384] = 196;
        nArray[385] = 13;
        nArray[386] = 224;
        nArray[387] = 85;
        nArray[388] = 129;
        nArray[389] = 87;
        nArray[390] = 200;
        nArray[391] = 34;
        nArray[392] = 212;
        nArray[393] = 184;
        nArray[394] = 197;
        nArray[395] = 105;
        nArray[396] = 216;
        nArray[397] = 73;
        nArray[398] = 174;
        nArray[399] = 213;
        nArray[400] = 157;
        nArray[401] = 78;
        nArray[402] = 15;
        nArray[403] = 215;
        nArray[404] = 243;
        nArray[405] = 121;
        nArray[406] = 88;
        nArray[407] = 107;
        nArray[408] = 75;
        nArray[409] = 127;
        nArray[410] = 246;
        nArray[411] = 132;
        nArray[412] = 237;
        nArray[413] = 106;
        nArray[414] = 24;
        nArray[415] = 159;
        nArray[416] = 116;
        nArray[417] = 134;
        nArray[418] = 212;
        nArray[419] = 155;
        nArray[420] = 156;
        nArray[421] = 75;
        nArray[422] = 173;
        nArray[423] = 155;
        nArray[424] = 162;
        nArray[425] = 75;
        nArray[426] = 150;
        nArray[427] = 171;
        nArray[428] = 249;
        nArray[429] = 36;
        nArray[430] = 55;
        nArray[431] = 44;
        nArray[432] = 138;
        nArray[433] = 143;
        nArray[434] = 255;
        nArray[435] = 177;
        nArray[436] = 13;
        nArray[437] = 85;
        nArray[438] = 53;
        nArray[439] = 73;
        nArray[441] = 167;
        nArray[442] = 122;
        nArray[443] = 61;
        nArray[444] = 181;
        nArray[445] = 242;
        nArray[446] = 5;
        nArray[447] = 225;
        nArray[448] = 185;
        nArray[449] = 159;
        nArray[450] = 205;
        nArray[451] = 134;
        nArray[452] = 96;
        nArray[453] = 134;
        nArray[454] = 58;
        nArray[455] = 21;
        nArray[456] = 154;
        nArray[457] = 212;
        nArray[458] = 171;
        nArray[459] = 228;
        nArray[460] = 15;
        nArray[461] = 164;
        nArray[462] = 137;
        nArray[463] = 52;
        nArray[464] = 22;
        nArray[465] = 61;
        nArray[466] = 221;
        nArray[467] = 229;
        nArray[468] = 66;
        nArray[469] = 166;
        nArray[470] = 88;
        nArray[471] = 85;
        nArray[472] = 64;
        nArray[473] = 253;
        nArray[474] = 104;
        nArray[475] = 60;
        nArray[476] = 191;
        nArray[477] = 216;
        nArray[478] = 192;
        nArray[479] = 15;
        nArray[480] = 18;
        nArray[481] = 18;
        nArray[482] = 154;
        nArray[483] = 40;
        nArray[484] = 77;
        nArray[485] = 234;
        nArray[486] = 204;
        nArray[487] = 76;
        nArray[488] = 222;
        nArray[489] = 254;
        nArray[490] = 88;
        nArray[491] = 190;
        nArray[492] = 113;
        nArray[493] = 55;
        nArray[494] = 84;
        nArray[495] = 28;
        nArray[496] = 4;
        nArray[497] = 113;
        nArray[498] = 38;
        nArray[499] = 200;
        nArray[500] = 212;
        nArray[501] = 158;
        nArray[502] = 39;
        nArray[503] = 85;
        nArray[504] = 171;
        nArray[505] = 24;
        nArray[506] = 26;
        nArray[507] = 183;
        nArray[508] = 233;
        nArray[509] = 64;
        nArray[510] = 176;
        nArray[511] = 192;
        int[] nArray2 = nArray;
        byte[] byArray = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        byte[] byArray2 = new byte[512];
        byte[] byArray3 = new byte[512];
        RawSecretKey rawSecretKey = new RawSecretKey("RC2", byArray);
        int n = 0;
        while (n < nArray2.length) {
            byArray3[n] = (byte)nArray2[n];
            ++n;
        }
        this.out.println("\nTest vector 5 (Encrypting):\n");
        this.alg.initEncrypt((Key)rawSecretKey);
        byArray2 = this.alg.crypt(byArray3);
        this.out.println("\n..............(Decrypting):\n");
        this.alg.initDecrypt((Key)rawSecretKey);
        byte[] byArray4 = this.alg.crypt(byArray2);
        this.compareIt(byArray4, byArray3);
    }

    private void compareIt(byte[] byArray, byte[] byArray2) {
        this.out.println("  computed: " + Hex.dumpString((byte[])byArray));
        this.out.println(" certified: " + Hex.dumpString((byte[])byArray2));
        this.passIf(ArrayUtil.areEqual((byte[])byArray, (byte[])byArray2), " ***** RC2 OUTPUT");
    }

    TestRC2() {
    }
}

