/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.mime;

import cryptix.util.mime.ISOLatin1;
import cryptix.util.mime.TransferEncoding;

public class QuotedPrintable
extends TransferEncoding {
    public String encode(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        StringBuffer stringBuffer2 = new StringBuffer(240);
        StringBuffer stringBuffer3 = new StringBuffer(80);
        int n2 = 0;
        while (n2 < n) {
            char c = (char)byArray[n2];
            if (c == '\r' && n2 != n - 1 && byArray[n2 + 1] == 10) {
                this.encodeEndOfLine(stringBuffer, stringBuffer2, stringBuffer3);
                ++n2;
            } else if (c == ' ' || c == '\t') {
                stringBuffer3.append(c);
            } else {
                if (stringBuffer3.length() != 0) {
                    stringBuffer2.append((Object)stringBuffer3);
                    stringBuffer3.setLength(0);
                }
                if (c >= '!' && c <= '~' && c != '=') {
                    stringBuffer2.append(c);
                } else {
                    this.appendHex(stringBuffer2, c);
                }
            }
            ++n2;
        }
        if (stringBuffer2.length() != 0 || stringBuffer3.length() != 0) {
            this.encodeEndOfLine(stringBuffer, stringBuffer2, stringBuffer3);
        }
        return stringBuffer.toString();
    }

    private void encodeEndOfLine(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        int n = 0;
        while (n < stringBuffer3.length()) {
            this.appendHex(stringBuffer2, stringBuffer3.charAt(n));
            ++n;
        }
        String string = stringBuffer2.toString();
        int n2 = string.length();
        n = 0;
        while (n < n2) {
            int n3 = n + 75;
            if (n3 == n2 - 1 || n3 > n2) {
                n3 = n2;
            }
            if (n3 > 2) {
                if (string.charAt(n3 - 1) == '=') {
                    --n3;
                }
                if (string.charAt(n3 - 2) == '=') {
                    n3 -= 2;
                }
            }
            stringBuffer.append(string.substring(n, n3));
            if (n3 != n2) {
                stringBuffer.append('=');
            }
            stringBuffer.append("\r\n");
            n = n3;
        }
        stringBuffer2.setLength(0);
        stringBuffer3.setLength(0);
    }

    private void appendHex(StringBuffer stringBuffer, int n) {
        stringBuffer.append('=');
        stringBuffer.append("0123456789ABCDEF".charAt((n &= 0xFF) >> 4));
        stringBuffer.append("0123456789ABCDEF".charAt(n & 0xF));
    }

    public byte[] decode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringBuffer stringBuffer2 = new StringBuffer(80);
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '=' && n2 + 2 < n) {
                char c2 = string.charAt(++n2);
                char c3 = string.charAt(++n2);
                if (c2 != '\r' || c3 != '\n') {
                    int n3 = "0123456789ABCDEF".indexOf(c2);
                    int n4 = "0123456789ABCDEF".indexOf(c3);
                    if (n3 == -1 || n4 == -1) {
                        stringBuffer.append('=');
                        stringBuffer.append(c2);
                        stringBuffer.append(c3);
                    } else {
                        stringBuffer.append((char)(n3 << 4 | n4));
                    }
                }
            } else if (c == ' ' || c == '\t') {
                stringBuffer2.append(c);
            } else {
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append((Object)stringBuffer2);
                }
                stringBuffer.append(c);
                stringBuffer2.setLength(0);
            }
            ++n2;
        }
        return ISOLatin1.toByteArray(stringBuffer.toString());
    }

    public static boolean isProbablyEncoded(String string) {
        int n = string.length();
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            char c;
            char c2 = string.charAt(n3);
            if (n3 - n2 > 76) {
                return false;
            }
            if (c2 == '=' && n3 + 2 < n) {
                c = string.charAt(++n3);
                char c3 = string.charAt(++n3);
                if (c == '\r' && c3 == '\n') {
                    bl = false;
                    n2 = n3 + 1;
                } else {
                    if ("0123456789ABCDEF".indexOf(c) == -1) {
                        return false;
                    }
                    if ("0123456789ABCDEF".indexOf(c3) == -1) {
                        return false;
                    }
                }
            } else if (c2 == '\r' && n3 + 1 < n) {
                if (bl) {
                    return false;
                }
                if ((c = string.charAt(++n3)) != '\n') {
                    return false;
                }
                n2 = n3 + 1;
            } else if (c2 == ' ' || c2 == '\t') {
                bl = true;
            } else if (c2 >= '!' && c2 <= '~' && c2 != '=') {
                bl = false;
            } else {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean isProbablyEncoded(byte[] byArray) {
        return QuotedPrintable.isProbablyEncoded(ISOLatin1.toString(byArray));
    }
}

