
# Manifest file for Cryptix Algorithms - also needs SPT + a JCE
#
# Version numbers
#
# 0.0.1 was a test release, as are others that are not mentioned
# 0.0.2 jumps to David's full 2.2.2 release, is manifest driven
# 0.0.6 was 3.0.0 release
# 0.1.0 was 18 months later (Cryptix 3.1.0)
# 0.1.1 Cryptix 3.1.1  Only the URL's in the license changed.

name=ALG
version=0-1-1

# dependencies - any JCE ?
-f java/security/AsymmetricCipher.class
-f cryptix/provider/Cryptix.class
depends=SPT IJCE

* This is the Cryptix Algorithms Archive - only algorithms included.
* This archive accompanies the Support archive.  A JCE is needed such
* as the Cryptix IJCE.
* To make it make a "small" JAR:
*    + copy this file to small.man,
*    + change the name to SMALL
*    + chop out unneeded algorithms below
*    + run "util/buildjar.sh small.man"
*
* The only necessary parts are these:
*
*      + cryptix/provider/cipher/cipher.class
*      + cryptix/provider/key/cipherKeyGenerator.class
* or
*      + cryptix/provider/md/md.class
*
* By default, tests are included for support reasons, they are
* extracted from the manifest by testjar.sh for remote testing.

#
#  algorithms
#
# cipher=Blowfish
cipher=Blowfish DES DES_EDE3 CAST5 IDEA LOKI91 RC2 RC4 SAFER Square SPEED
cryptix/provider/cipher/<cipher>.java
cryptix/provider/key/<cipher>KeyGenerator.java
cryptix/test/Test<cipher>.java

#Warning: Include these if Maker is included in TOOLS.jar (tools.man)
#
#cryptix/util/test/data/<cipher>.mtest

#
#  This is here because it needs SAFER.  Should be rewritten to use
#  an independant/internal algorithm.
#
cryptix/test/TestIJCE.java
tests=cryptix.test.TestIJCE

# tests can be cumulative
# tests= cryptix.test.TestBlowfish

tests= cryptix.test.TestDES cryptix.test.TestDES_EDE3
tests= cryptix.test.TestBlowfish cryptix.test.TestCAST5 cryptix.test.TestIDEA
tests= cryptix.test.TestLOKI91 cryptix.test.TestRC2 cryptix.test.TestRC4
tests= cryptix.test.TestSAFER cryptix.test.TestSquare cryptix.test.TestSPEED

#
#  digests
#
# md=MD2
md=MD2 MD4 RIPEMD128 RIPEMD160 HAVAL SHA1 SHA0 MD5
cryptix/provider/md/<md>.java
cryptix/provider/mac/HMAC_<md>.java
cryptix/test/Test<md>.java
cryptix/test/TestHMAC.java

#Warning: Include these if Maker is included in TOOLS.jar (tools.man)
#
#cryptix/util/test/data/<md>.mtest

tests= cryptix.test.TestHMAC
tests= cryptix.test.TestMD2 cryptix.test.TestMD4
tests= cryptix.test.TestRIPEMD128 cryptix.test.TestRIPEMD160
tests= cryptix.test.TestHAVAL
tests= cryptix.test.TestSHA1 cryptix.test.TestSHA0 cryptix.test.TestMD5
