/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.mime;

import cryptix.util.mime.ISOLatin1;

public class Base64 {
    private static final int LINEBREAK_LENGTH = 48;
    protected static final char[] enc_table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    protected static final byte[] dec_table;

    public String encode(byte[] byArray) {
        return ISOLatin1.toString(this.encodeAsByteArray(byArray));
    }

    public byte[] encodeAsByteArray(byte[] byArray) {
        byte by;
        byte by2;
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        int n4 = n3 % 3;
        int n5 = (n3 + 48 - 1) / 48 * 2 + (n3 + 2) / 3 * 4 + (n3 == 0 ? 2 : 0);
        byte[] byArray2 = new byte[n5];
        int n6 = n3 / 3;
        while (n6 > 0) {
            by2 = byArray[n++];
            by = byArray[n++];
            byte by3 = byArray[n++];
            byArray2[n2++] = (byte)enc_table[by2 >>> 2 & 0x3F];
            byArray2[n2++] = (byte)enc_table[(by2 << 4 & 0x30) + (by >>> 4 & 0xF)];
            byArray2[n2++] = (byte)enc_table[(by << 2 & 0x3C) + (by3 >>> 6 & 3)];
            byArray2[n2++] = (byte)enc_table[by3 & 0x3F];
            if (n % 48 == 0) {
                byArray2[n2++] = 13;
                byArray2[n2++] = 10;
            }
            --n6;
        }
        if (n4 == 1) {
            by2 = byArray[n++];
            byArray2[n2++] = (byte)enc_table[by2 >>> 2 & 0x3F];
            byArray2[n2++] = (byte)enc_table[by2 << 4 & 0x30];
            byArray2[n2++] = 61;
            byArray2[n2++] = 61;
        } else if (n4 == 2) {
            by2 = byArray[n++];
            by = byArray[n++];
            byArray2[n2++] = (byte)enc_table[by2 >>> 2 & 0x3F];
            byArray2[n2++] = (byte)enc_table[(by2 << 4 & 0x30) + (by >>> 4 & 0xF)];
            byArray2[n2++] = (byte)enc_table[by << 2 & 0x3C];
            byArray2[n2++] = 61;
        }
        if (n == 0 || n % 48 != 0) {
            byArray2[n2++] = 13;
            byArray2[n2++] = 10;
        }
        if (n2 != n5) {
            throw new InternalError("Bug in Base64.java: incorrect length calculated for base64 output");
        }
        return byArray2;
    }

    public byte[] decode(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            if (byArray[n4] > 32) {
                ++n3;
            }
            if (byArray[n4] == 61) {
                ++n;
            }
            --n4;
        }
        if (n3 % 4 != 0) {
            throw new IllegalArgumentException("Length not a multiple of 4");
        }
        int n5 = n3 / 4 * 3 - n;
        byte[] byArray2 = new byte[n5];
        n4 = 0;
        byte[] byArray3 = new byte[4];
        int n6 = 0;
        int n7 = 0;
        byArray3[3] = 61;
        byArray3[2] = 61;
        byArray3[1] = 61;
        byArray3[0] = 61;
        while (n4 < n2) {
            byte by;
            if ((by = byArray[n4++]) > 32) {
                byArray3[n7++] = by;
            }
            if (n7 != 4) continue;
            n6 += this.decode(byArray2, n6, byArray3[0], byArray3[1], byArray3[2], byArray3[3]);
            n7 = 0;
            byArray3[3] = 61;
            byArray3[2] = 61;
            byArray3[1] = 61;
            byArray3[0] = 61;
        }
        if (n7 > 0) {
            this.decode(byArray2, n6, byArray3[0], byArray3[1], byArray3[2], byArray3[3]);
        }
        return byArray2;
    }

    public byte[] decode(String string) throws IllegalArgumentException {
        return this.decode(ISOLatin1.toByteArrayLossless(string));
    }

    private int decode(byte[] byArray, int n, byte by, byte by2, byte by3, byte by4) {
        byte by5 = dec_table[by];
        byte by6 = dec_table[by2];
        byte by7 = dec_table[by3];
        byte by8 = dec_table[by4];
        if (by5 == -1 || by6 == -1 || by7 == -1 && by3 != 61 || by8 == -1 && by4 != 61) {
            throw new IllegalArgumentException("Invalid character [" + (by & 0xFF) + ", " + (by2 & 0xFF) + ", " + (by3 & 0xFF) + ", " + (by4 & 0xFF) + "]");
        }
        byArray[n++] = (byte)(by5 << 2 | by6 >>> 4);
        if (by3 == 61) {
            return 1;
        }
        byArray[n++] = (byte)(by6 << 4 | by7 >>> 2);
        if (by4 == 61) {
            return 2;
        }
        byArray[n++] = (byte)(by7 << 6 | by8);
        return 3;
    }

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = 62;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        byArray[123] = -1;
        byArray[124] = -1;
        byArray[125] = -1;
        byArray[126] = -1;
        byArray[127] = -1;
        byArray[128] = -1;
        byArray[129] = -1;
        byArray[130] = -1;
        byArray[131] = -1;
        byArray[132] = -1;
        byArray[133] = -1;
        byArray[134] = -1;
        byArray[135] = -1;
        byArray[136] = -1;
        byArray[137] = -1;
        byArray[138] = -1;
        byArray[139] = -1;
        byArray[140] = -1;
        byArray[141] = -1;
        byArray[142] = -1;
        byArray[143] = -1;
        byArray[144] = -1;
        byArray[145] = -1;
        byArray[146] = -1;
        byArray[147] = -1;
        byArray[148] = -1;
        byArray[149] = -1;
        byArray[150] = -1;
        byArray[151] = -1;
        byArray[152] = -1;
        byArray[153] = -1;
        byArray[154] = -1;
        byArray[155] = -1;
        byArray[156] = -1;
        byArray[157] = -1;
        byArray[158] = -1;
        byArray[159] = -1;
        byArray[160] = -1;
        byArray[161] = -1;
        byArray[162] = -1;
        byArray[163] = -1;
        byArray[164] = -1;
        byArray[165] = -1;
        byArray[166] = -1;
        byArray[167] = -1;
        byArray[168] = -1;
        byArray[169] = -1;
        byArray[170] = -1;
        byArray[171] = -1;
        byArray[172] = -1;
        byArray[173] = -1;
        byArray[174] = -1;
        byArray[175] = -1;
        byArray[176] = -1;
        byArray[177] = -1;
        byArray[178] = -1;
        byArray[179] = -1;
        byArray[180] = -1;
        byArray[181] = -1;
        byArray[182] = -1;
        byArray[183] = -1;
        byArray[184] = -1;
        byArray[185] = -1;
        byArray[186] = -1;
        byArray[187] = -1;
        byArray[188] = -1;
        byArray[189] = -1;
        byArray[190] = -1;
        byArray[191] = -1;
        byArray[192] = -1;
        byArray[193] = -1;
        byArray[194] = -1;
        byArray[195] = -1;
        byArray[196] = -1;
        byArray[197] = -1;
        byArray[198] = -1;
        byArray[199] = -1;
        byArray[200] = -1;
        byArray[201] = -1;
        byArray[202] = -1;
        byArray[203] = -1;
        byArray[204] = -1;
        byArray[205] = -1;
        byArray[206] = -1;
        byArray[207] = -1;
        byArray[208] = -1;
        byArray[209] = -1;
        byArray[210] = -1;
        byArray[211] = -1;
        byArray[212] = -1;
        byArray[213] = -1;
        byArray[214] = -1;
        byArray[215] = -1;
        byArray[216] = -1;
        byArray[217] = -1;
        byArray[218] = -1;
        byArray[219] = -1;
        byArray[220] = -1;
        byArray[221] = -1;
        byArray[222] = -1;
        byArray[223] = -1;
        byArray[224] = -1;
        byArray[225] = -1;
        byArray[226] = -1;
        byArray[227] = -1;
        byArray[228] = -1;
        byArray[229] = -1;
        byArray[230] = -1;
        byArray[231] = -1;
        byArray[232] = -1;
        byArray[233] = -1;
        byArray[234] = -1;
        byArray[235] = -1;
        byArray[236] = -1;
        byArray[237] = -1;
        byArray[238] = -1;
        byArray[239] = -1;
        byArray[240] = -1;
        byArray[241] = -1;
        byArray[242] = -1;
        byArray[243] = -1;
        byArray[244] = -1;
        byArray[245] = -1;
        byArray[246] = -1;
        byArray[247] = -1;
        byArray[248] = -1;
        byArray[249] = -1;
        byArray[250] = -1;
        byArray[251] = -1;
        byArray[252] = -1;
        byArray[253] = -1;
        byArray[254] = -1;
        byArray[255] = -1;
        dec_table = byArray;
    }
}

