/*
 * Copyright (c) 1997, 1998 Systemics Ltd on behalf of
 * the Cryptix Development Team under the Cryptix general license.
 * All rights reserved.
 *
 * If you have the Cryptix NIST-KIT installed you need to make some changes to the source code.
 * Please refer to the readme.txt for more details.
 *
 * I am sorry for the terrible code btw. I haven't had the time to rewrite it yet.
 * 
 * Erwin van der Koogh
 * vdkoogh@mediaport.org
 */

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

class Benchmark
{

    private static final int POINTNUM = 10;
    private static final Color[] COLOR = {Color.blue, Color.red, Color.magenta, Color.orange, Color.cyan, Color.green};
    
    private JPanel              myContentPane;
    private DefaultListModel    myModel;
    private JFrame              myFrame;
    private JList               mySourceList;
    private JButton             myTestButton;
    private GridBagLayout       gridbag;
    private JTabbedPane         myTabbedPane;
    private GraphBean           myGraph;
    private JPopupMenu          myPopupMenu;
    private int                 myKeySize = 256;
    private boolean             stop;
    private JComboBox           myKeysizeBox;
    private JTextField          myAmountField;

    
    public Benchmark()
    {
        
        InitFrame();
        
        ListInit();
        
        myFrame.show();
        
      
    }
    
    private void InitFrame()
    {
        
        String lf = UIManager.getSystemLookAndFeelClassName();

		if (lf != null)
		{
			try
			{
				UIManager.setLookAndFeel(lf);
			}
			catch( Exception e)
			{
				System.out.println(e);
			}
		}
			
		myFrame     = new JFrame("Test");
		myFrame.setSize(600,500);
		
		myContentPane   = (JPanel)myFrame.getContentPane();
		myTabbedPane    = new JTabbedPane();
	    myContentPane.add(myTabbedPane, "Center");
				
		JMenuBar myMenu     = new JMenuBar();
		JMenu myFileMenu    = new JMenu("File");
        JMenu myListMenu    = new JMenu("List");
        myPopupMenu         = new JPopupMenu();
		myMenu.add(myFileMenu);
        myMenu.add(myListMenu);
        myFileMenu.setMnemonic('F');
        myListMenu.setMnemonic('L');
        
		JMenuItem myExitItem        = new JMenuItem("Exit");
		JMenuItem myListAddItem     = new JMenuItem("Add to list");
		JMenuItem myListRemoveItem  = new JMenuItem("Remove from list");
		JMenuItem myListClearItem   = new JMenuItem("Clear list");
		myFileMenu.add(myExitItem);
		myListMenu.add(myListAddItem);
		myListMenu.add(myListRemoveItem);
		myListMenu.add(myListClearItem);
		myExitItem.setMnemonic('x');
		myListAddItem.setMnemonic('A');
		myListRemoveItem.setMnemonic('R');
        myListClearItem.setMnemonic('c');
        
		
		myFrame.getRootPane().setJMenuBar( myMenu );
		
        myTestButton            = new JButton("Test");
        mySourceList            = new JList();
        JScrollPane scrollpane  = new JScrollPane( mySourceList );
        myKeysizeBox            = new JComboBox();
        myAmountField           = new JTextField("4096", 10);
        scrollpane.setPreferredSize(new Dimension(250,150));
        myKeysizeBox.addItem(new Integer(128));
        myKeysizeBox.addItem(new Integer(196));
        myKeysizeBox.addItem(new Integer(256));
        myAmountField.setHorizontalAlignment(4);

        
        gridbag                 = new GridBagLayout();
        GridBagConstraints c    = new GridBagConstraints();
        JPanel center           = new JPanel(gridbag);

        c.weightx = 1;
        c.weighty = 1;
        c.fill = GridBagConstraints.NONE;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridwidth = 1;
        
        gridbag.setConstraints(scrollpane, c);
        
        c.gridx = 4;
        c.gridy = 10;
        
        gridbag.setConstraints(myTestButton, c);
        
        c.gridx = 4;
        c.gridy = 0;
        gridbag.setConstraints(myKeysizeBox, c);
        
        c.gridx = 4;
        c.gridy = 1;
        gridbag.setConstraints(myAmountField, c);
        
        center.add(scrollpane);
        center.add(myTestButton);
        center.add(myKeysizeBox);
        center.add(myAmountField);
        
        JPanel graph = new JPanel(new BorderLayout());
        myGraph = new GraphBean();
        myGraph.setYName("Rounds");
        myGraph.setXName("Seconds");
        
        graph.add(myGraph, "Center");
        
        myTabbedPane.addTab("Algorithms", center);
        myTabbedPane.addTab("Graph", graph);


		myExitItem.addActionListener( new ActionListener()
			{
				public void actionPerformed( ActionEvent e)
				{
					Exit();
				}
			});
			
	    myListAddItem.addActionListener( new ActionListener()
	        {
	            public void actionPerformed( ActionEvent e)
	            {
	                ListAdd();
	            }
	        });
	        
	    myListClearItem.addActionListener( new ActionListener()
	        {
	            public void actionPerformed( ActionEvent e)
	            {
	                ListClear();
	            }
	        });
	        
	    myListRemoveItem.addActionListener( new ActionListener()
	        {
	            public void actionPerformed( ActionEvent e)
	            {
	                ListRemove();
	            }
	        });

		myFrame.addWindowListener( new WindowAdapter()
			{
				public void windowClosing(WindowEvent e)
				{
                    Exit();
				}
			} );
			
		myTestButton.addActionListener( new ActionListener()
		    {
		        public void actionPerformed( ActionEvent e)
		        {
		            myTabbedPane.setSelectedIndex(1);
		        }
		    });
		    
		myTabbedPane.addChangeListener( new ChangeListener()
		    {
		        public void stateChanged( ChangeEvent e)
		        {
		            if(myTabbedPane.getSelectedIndex() == 1)
		            {
		                Test();
		            }
		            
		        }
		    });
		    
        mySourceList.addMouseListener( new MouseAdapter()
            {
		        public void mouseClicked(MouseEvent ev)
		        {
		            if(SwingUtilities.isRightMouseButton(ev))
		            {
		                myPopupMenu.show(mySourceList, ev.getX(), ev.getY());
		            }
		        }
		    });
		    
		    
        }
        
    private void Exit()
    {
        try
	    {
	        FileOutputStream fos = new FileOutputStream("list.dat");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(myModel);
            oos.flush();
            fos.close();
        }
        catch(IOException ex)
        {
            System.out.println(ex);
        }
                
   		System.exit(0);
   	}
   	
   	private void ListAdd()
   	{
   	    try
   	    {
   	        String response = JOptionPane.showInputDialog("Enter de algorithm to add");
   	        if(response != null)
   	            myModel.addElement(response);
   	    }
   	    catch(Exception e)
   	    {
   	        System.out.println(e);
   	    }
   	    
   	}
   	
   	private void ListRemove()
   	{
   	    Object[] temp = mySourceList.getSelectedValues();
   	    for(int i = 0; i < temp.length; i++)
   	    {
   	        myModel.removeElement(temp[i]);
   	    }
   	    mySourceList.repaint();
   	}
   	
   	private void ListClear()
   	{
   	    myModel.removeAllElements();
   	}
   	    
    private void ListInit()
	{
        
        try
        {
            FileInputStream fis = new FileInputStream("list.dat");
            ObjectInputStream ois = new ObjectInputStream(fis);
            
            myModel = (DefaultListModel)ois.readObject();
            fis.close();
        }
        catch(Exception ex)
        {
            System.out.println(ex);
            myModel = new DefaultListModel();
        }
        
        mySourceList.setModel(myModel);
         
    }

    private void Test()
    {
        int numbergraphs    = mySourceList.getSelectedValues().length;
        double[][][] data   = new double[numbergraphs][POINTNUM][2];
        Color[] colors      = new Color[numbergraphs];
        
        Object[] legenda = mySourceList.getSelectedValues();

     
        for (int g = 0; g < numbergraphs; g++)
        {
            stop = false;
            colors[g] = COLOR[g % 5];
            Integer keysize = (Integer)(myKeysizeBox.getSelectedItem());
            int interval    = Integer.parseInt(myAmountField.getText());
            System.out.println("Keysize:  " + keysize.intValue());
            TestAlgoThread test = new TestAlgoThread((String)legenda[g], keysize.intValue(), data[g], (interval*1024)/(16 * (POINTNUM - 1)));
            test.addThreadStateListener(new ThreadStateListener()
                {
                    public void ThreadStateChanged(ThreadStateChangedEvent ev)
                    {
                        if(ev.getStatus() == TestAlgoThread.STATUS_FINISHED)
                        {
                            stop = true;
                        }
                        
                    }
                });

            System.gc();
            try
                {
                    Thread.sleep(3000);
                }
                catch(InterruptedException ex)
                {
                    System.out.println(ex);
                }
            test.start();
            while(!stop)
            {
                try
                {
                    Thread.sleep(10);
                }
                catch(InterruptedException ex)
                {
                    System.out.println(ex);
                }
                
            }
        }
          
        processResults(data);
        myGraph.setLegenda(legenda);
        myGraph.setData(data);
        myGraph.setColors(colors);


    }

    private void processResults(double[][][] data)
    {
        int Xmax = 0;
        int Ymax = 0;
        int Xfactor     = 1;
        String XName    = "bytes";
        int Yfactor     = 1;
        String YName    = "ms";
            
        for(int g = 0; g < data.length; g++)
        {
        
            for(int index = 1; index < POINTNUM;index++)
            {
                data[g][index][1] += data[g][index - 1][1];
            }
            
            int localXmax = (int)(data[g][POINTNUM - 1][0]);
            if(localXmax > Xmax)
                Xmax = localXmax;
                            
            int localYmax = (int)(data[g][POINTNUM - 1][1]);
            if(localYmax > Ymax)
                Ymax = localYmax;
            
                
        }
        
        if((Xmax / 1024) >= 10)
        {
            Xfactor     = 1024;
            XName    = "KB";
        }
                
        if((Xmax / (1024 * 1024)) >= 10)
        {
            Xfactor     = 1024000;
            XName    = "MB";
        }
        
        if((Ymax / 100) >= 10)
        {
            Yfactor     = 100;
            YName    = "sec";
        }
                
        if((Ymax / 60000) >= 10)
        {
            Yfactor     = 60000;
            YName    = "min";
        }
        
        for(int g = 0; g < data.length; g++)
        {
            for(int i = 0; i <POINTNUM;i++)
            {
                data[g][i][0] /= (Xmax);
                data[g][i][1] /= Ymax;
            }
        }
        
        
        myGraph.setEndX((Xmax / Xfactor) + 1);
        myGraph.setEndY((Ymax / Yfactor) + 1);
        myGraph.setXName(XName);
        myGraph.setYName(YName);
        
    }
    

    
	public static void main(String[] argv)
	{
	    Benchmark bench = new Benchmark();
	}
	
}
