import java.security.InvalidKeyException;

public class Benchmark_ECB extends NIST.NIST_ECB
{
    private static final byte[] key128 = { 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7 };
    private static final byte[] key196 = { 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7 };
    private static final byte[] key256 = { 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7 };
    
    public Benchmark_ECB(String aes) throws NoSuchMethodException, ClassNotFoundException
    {
        super(aes);
    }
    
    public void init(int keysize) throws InvalidKeyException
    {
        switch(keysize)
        {
            case 128: init(key128);break;
            case 196: init(key196);break;
            case 256: init(key256);break;
            default: System.out.println("Not a valid keylength");
        }
        
    }
    
    public void init(byte[] key) throws InvalidKeyException
    {
        super.init(NIST.NIST_Cipher.ENCRYPT_STATE, key);
    }
    
        

    public byte[] update (byte[] in, int inOff, int inLen)
    {
        return super.update(in, inOff, inLen);
    }
    
}
