import com.sun.java.swing.*;
import java.awt.*;

class GraphBean extends JComponent
{
    
    public static final int left = 40;          // x-coordinate of the left side
    public static final int margin = 20;        // y-coordinate of the bottom side
    
    private String          myXName = "";       // name of the x-axis
    private String          myYName = "";       // name of the y-axis
    private double[][][]    myData;             // array with points.. 1st is the graph, 2nd the x-coordinates 3th the y-coordinate
    private Object[]        myLegenda;          // Description of the graphs.. won't display if length = 0
    private Color[]         myColors;           // colors of the graph(s)
    private int             myIntervalX = 10;   // number of numbers on the x-axis
    private int             myIntervalY = 10;    // number of numbers on the y-axis
    private double          myBeginX = 0;       // starting value of the x-axis
    private double          myEndX = 7;         // end value of the x-axis
    private double          myBeginY = 0;       // starting value of the y-axis
    private double          myEndY = 12;        // end value of the y-axis
    private int             myWidth;            
    private int             myHeight;
    private int             myDotSize = 0;      // dotsize
    private boolean         myIsLine = true;    // wether of not to display the graph as a line.
    

    public GraphBean()
    {
        myData      = new double[1][1][2];
        myData[0][0][0] = 1;
        myData[0][0][1] = 2;
        myLegenda   = new Object[1];
        myLegenda[0] = "";
        myColors    = new Color[1];
        myColors[0] = new Color(23423);
    }
    
    public void setXName(String name)
    {
        myXName = name;
    }
    
    public String getXName()
    {
        return myXName;
    }
        
    public void setYName( String name)
    {
        myYName = name;
    }
    
    public String getYName()
    {
        return myYName;
    }
    
    public void setData(double[][][] data)
    {
        myData = data;
    }
    
    public double[][][] getData()
    {
        return myData;
    }
    
    public void setLegenda(Object[] legenda)
    {
        myLegenda = legenda;
    }
    
    public Object[] getLegenda()
    {
        return myLegenda;
    }
    
    public void setIntervalX( int x)
    {
        myIntervalX = x;
    }
    
    public int getIntervalX()
    {
        return myIntervalX;
    }
    
    public void setIntervalY(int y)
    {
        myIntervalY = y;
    }
    
    public int getIntervalY(int y)
    {
        return myIntervalY;
    }
    
    public void setBeginX(double beginx)
    {
        myBeginX = beginx;
    }
    
    public double getBeginX()
    {
        return myBeginX;
    }
    
    public void setBeginY(double beginy)
    {
        myBeginY = beginy;
    }
    
    public double getBeginY()
    {
        return myBeginY;
    }
    
    public void setEndX(double endx)
    {
        myEndX = endx;
    }
    
    public double getEndx()
    {
        return myEndY;
    }
    
    public void setEndY(double endy)
    {
        myEndY = endy;
    }
    
    public double getEndY()
    {
        return myEndY;
    }
    
    public void setDotSize(int size)
    {
        myDotSize = size;
    }
    
    public int getDotSize()
    {
        return myDotSize;
    }
    
    public void setLine(boolean line)
    {
        myIsLine = line;
    }
    
    public boolean isLine()
    {
        return myIsLine;
    }
       
    public void setColors(Color[] colors)
    {

        myColors = colors;
    }
    
    public Color[] getColors()
    {
        return myColors;
    }
    
    
    protected void paintComponent(Graphics g)
    {
         
        myWidth = getWidth();
        myHeight = getHeight();
        
        int bottom = (myHeight - 30);
        int graphHeight = bottom - margin;
        int graphWidth  = myWidth - left - margin;
        
        int cx = 0;
        int cy = 0;
             
        Font f = new Font("Mono Spaced", Font.PLAIN, 10);
        g.setFont(f);
        
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        
        g.drawString(myYName, 15,15);
        g.drawString(myXName, ( myWidth - fm.stringWidth(myXName) - 15 ), (myHeight - 5) );
        
        g.drawLine(left, margin, left, bottom + 5 );
        g.drawLine(left - 5, bottom, myWidth - margin, bottom);
                
        cx = 5;
        cy = margin;
        
        
        for(int i = 0; i <= myIntervalY; i++)
        {
            cy = margin + (int)( i * ((double)graphHeight / (myIntervalY)));
            
            String text = new Float(myEndY - (i * (myEndY / myIntervalY))).toString();
            g.drawString( text, left - 10 - fm.stringWidth(text), cy + (fontHeight/2));
            if (i != myIntervalY)
                g.drawLine(left - 5, cy, left + graphWidth , cy) ;
        }
        
        cy = bottom + 3 + fontHeight;
        
        for(int i = 0; i <= myIntervalX; i++)
        {
            cx = left + (int)( i * ((double)graphWidth / (myIntervalX)));
                        
            String text = new Float(i * (myEndX / myIntervalX)).toString();
            g.drawString(text, cx - (fm.stringWidth(text) / 2), cy);
            if (i != 0)
                g.drawLine(cx, bottom - graphHeight, cx, bottom +5);
        }
        
        g.setFont(new Font("Sans Serif", Font.PLAIN, 12));
        fm = g.getFontMetrics();
            
        for(int gr = 0; gr < myData.length; gr++)
        {
            int oldx = left + (int)(myData[gr][0][0] * graphWidth);
            int oldy = bottom - (int)(myData[gr][0][1] * graphHeight);
            
            g.setColor(myColors[gr]);
            cx = left + graphWidth - fm.stringWidth(myLegenda[gr].toString());
            cy = margin + ( ( gr + 1 ) * fm.getHeight());
            g.drawString(myLegenda[gr].toString(), cx, cy);
            
            for(int x = 0; x < myData[gr].length; x++)
            {
                cx = left + (int)(myData[gr][x][0] * graphWidth);
                cy = bottom - (int)(myData[gr][x][1] * graphHeight);
  
                g.fillOval( cx - (myDotSize / 2), cy -(myDotSize / 2),myDotSize,myDotSize);
                if (myIsLine)
                {
                    g.drawLine( oldx, oldy, cx, cy);
                    oldx = cx;
                    oldy = cy;
                }
                
            }
       
                      
        }
        
    }
    
    
}
