import com.sun.java.swing.event.*;
import java.awt.event.*;

class TestAlgoThread extends Thread
{
    
    public static final int STATUS_IDLE         = 0;
    public static final int STATUS_RUNNING      = 1;
    public static final int STATUS_FINISHED     = 2;
    public static final int STATUS_TERMINATED   = 3;
    private static final int BLOCK_SIZE         = 16;
    
    private String              myAlgorithm;
    private double[][]          myResults;
    private int                 myInterval;
    private EventListenerList   myEventList = new EventListenerList();
    private int                 myStatus = STATUS_IDLE;
    private static int          count = 0;
    private byte[]              data;
    private long                myBeginTime;
    private int                 myKeySize;
    
    public TestAlgoThread(String algorithm, int keysize, double[][] results, int interval)
    {
        myAlgorithm = algorithm;
        myKeySize   = keysize;
        myResults   = results;
        myInterval  = interval;
        
        setStatus(STATUS_IDLE);

    }
    
    public void start()
    {
        System.out.println("Algorithm: " + myAlgorithm);
        int blockinterval = myInterval * BLOCK_SIZE;
        data = new byte[(myResults.length * blockinterval)];
        for(int i = 0; i <data.length; i++)
        {
            data[i] = 7;
        }

        try
        {
            setStatus(STATUS_RUNNING);
            Benchmark_ECB testECB = new Benchmark_ECB(myAlgorithm);
            
            myBeginTime = System.currentTimeMillis();
            long myCalcTime  = System.currentTimeMillis();
            
            testECB.init(myKeySize);
            
            myResults[0][0] = 0;
            myResults[0][1] = (System.currentTimeMillis() - myCalcTime);
            System.out.println("Init: " + (System.currentTimeMillis() - myCalcTime));
            
           
            for(int i =1;i < myResults.length; i++)
            {
                testECB.update(data, i * blockinterval, blockinterval);
                
                System.out.println("Time" + i + ":" + (System.currentTimeMillis() - myCalcTime));
                myResults[i][0] = blockinterval * i + 1;
                myResults[i][1] = (System.currentTimeMillis() - myCalcTime);
                myCalcTime = System.currentTimeMillis();
            }

            System.out.println("Total: " + (System.currentTimeMillis() - myBeginTime));
            
            setStatus(STATUS_FINISHED);
        }
        catch(NoSuchMethodException ex2)
        {
            setStatus(STATUS_TERMINATED);
            System.out.println(ex2);
        }
        catch(ClassNotFoundException ex3)
        {
            setStatus(STATUS_TERMINATED);
            System.out.println(ex3);
        }
        catch(Exception ex4)
        {
            setStatus(STATUS_TERMINATED);
            System.out.println(ex4);
        }
        
        
    }
    
    private void setStatus(int status)
    {
        myStatus = status;
        fireThreadStateChangedEvent();
    }
    
    public void addThreadStateListener(ThreadStateListener l)
    {
        myEventList.add(ThreadStateListener.class, l);
    }
    
    public void removeThreadStateListener(ThreadStateListener l)
    {
        myEventList.remove(ThreadStateListener.class, l);
    }
    
    protected void fireThreadStateChangedEvent()
    {
        try
        {
        Object[] listeners = myEventList.getListenerList();
        for (int i = listeners.length-2; i>=0; i-=2)
        {
            ThreadStateChangedEvent ev = new ThreadStateChangedEvent(this, myStatus);
            if (listeners[i]==ThreadStateListener.class)
            {
                ((ThreadStateListener)listeners[i+1]).ThreadStateChanged(ev);
            }
        }
        }
        catch(Exception ex)
        {
            System.out.println(ex);
        }
            
    }
}
