/*
 * Decompiled with CFR 0.152.
 */
package MARS;

import MARS.MARS_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class MARS_Algorithm {
    static final String NAME = "MARS_Algorithm";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err = null;
    static final boolean TRACE = MARS_Properties.isTraceable("MARS_Algorithm");
    static final int BLOCK_SIZE = 16;
    static final int ROUNDS = 32;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] S = new int[]{164676729, 684261344, -2069205959, -1649577337, 2113903587, -735673503, -915562028, 2037697683, -2049943506, 709580549, 480340578, -1011013731, 253699557, 1365260079, -963264005, 1300230628, -1369478156, 225635910, -14426486, -1311797629, -246873374, 1050156610, -1946861898, 2135685292, -2090655869, 630653445, 1991239556, 981021140, 1334076496, 1550107638, 554327832, -963089882, 687138854, 979413020, -750737820, 2124947652, 1382451141, 2128466219, 849419549, -1667305338, -2131302351, -1418787667, 1459329875, -1959917220, -1232775506, -769324275, 692746017, -501239213, -1374460087, -399855994, -1825156860, -1723839898, 2024244444, -1231312821, 67397523, 601578526, 1187701206, 803373364, 1512192322, 409193819, -1047476509, 132102214, 1857587222, 755878986, -1530089895, 932734733, -872770413, 1330126149, -352547672, -619632170, -1337680352, 257165307, 1634195880, -772515997, 1303025347, 1005345112, -1414815724, -1228090879, 953558943, 40378901, -1892193067, 153887614, -1077582445, 847813932, -2058666347, 96181059, 2110610893, -1607560596, -85645339, 916570928, 873652654, -229116830, 1011817841, 815982601, 1759901009, -1671316924, 1575815864, 1976437192, -1772816066, 1770785994, 607957988, 721824663, 255561118, 14700767, -60989082, -480275832, -1065790195, 93433576, -1907155340, 1979594104, 795706010, -167042642, -1779897459, 1721321579, -1877115493, -43160015, 277916911, -530117160, -625809774, -848477339, -449235692, 989021680, 1648491597, 1175298979, 2077177641, -1947086368, 346734704, 361229653, 989691198, -755851775, 698995190, -273609645, -818182385, -1273719972, 1715758573, 38456007, 1504134337, 489240231, -598209882, -816362328, 67795472, 1826101255, -1969701300, -1395744669, -1019309387, -773791683, -1289596546, 546487571, 946547786, 1390992728, 1483042299, 1350697841, 1098979478, -482873474, -744509159, -914420234, 1761517595, -1588549915, 1428523362, -344984549, -674640518, -1508258402, -1125083786, 645054579, -268174532, 1253549323, 344199786, 1216063921, -1504720442, -157975223, 951085685, -578789427, 1674613967, -182675042, 447009603, -1203154284, -828404071, -1073948816, -943557172, 931419047, 2065808947, 964641213, 1318375729, -1832116328, 1494608465, -1711775305, -912782712, 494206303, -1331390984, 1632497360, -1250455830, 1497463085, -91176456, 871900340, -996781198, 1073141072, 1285947072, -2043614876, 1530903510, 2107796040, -1308417254, 69825812, 761500422, 783364425, 379867762, 1394891168, -1906358158, -110704679, 118656448, 222616418, -1345792723, 0x6316131, -667359282, 465837312, 976129039, -360479874, -1182502019, 330975377, -990332599, -1495880525, -1575629362, -2091285621, 1808902705, -176562862, 565788563, -183015551, 410910174, -380966026, 725155156, 1126031834, -1422309339, -1697446769, -538299734, 1704227811, 1648326755, -214668199, -1422215547, 860268811, 1800815678, -958529032, -1925046336, -1693527796, -1997430295, 1421996073, 2112542075, -1921276890, 1291130762, 1427799242, 446324488, -53063239, 627069314, -518011197, -1224894858, 863711271, -1211569388, -1637887952, 1800921940, -1382990601, 2115397773, 1485253225, 741328863, -477508410, 812879345, 136619828, -512132469, -1532439173, 1532827963, -928501605, 1945741688, 1933151538, 257513278, -371250429, -391792952, -2071132412, -1730178110, 1913265603, 1750017434, -1808029624, -1506344622, -2042929501, -780429429, 1838897391, 175115732, -1489160513, -1905653719, -2037007340, -480562105, -1824864920, -2003521502, 793844775, -570700740, 0x6662B6, 293372926, 1309848596, -1027823770, 976219152, -195681248, 1434005034, 1190516823, -824564274, -1017111237, 1811983174, -273900504, -1279045561, 1629355747, 628896263, -36338558, 991221839, 599706468, -1602882653, 143625901, 128840024, 2006357052, -87376067, -1063833395, -144205463, -633017875, 746933266, 898850723, 788888991, 1762010360, 481344253, 2064498118, -2129714245, -91055590, 1838586391, 1732417435, 1957461253, 17720772, -2036082333, -116935264, -805033005, 361594115, 679117397, -1146603921, 158260275, 563178107, 2008378246, -1793711367, -1496979888, -1930815535, -846437700, -1546243021, 898263293, 261856572, -693491365, -30197686, -1073712242, -848827601, -487887422, -1758229758, 113898054, 1100804525, 730054725, 925102474, -883216247, 369879767, 1565083222, 905488203, 508456094, 235965, 1732667520, -1273542607, -1393286222, -897492301, 1516475879, 808085445, -1948564373, 277843876, 270679770, -1833388917, 2134429934, -1423506988, 40031253, -1356707280, -1277654342, -122502225, -621285520, -862465097, -379499668, 732872692, 1895204815, 946639190, -838258971, 32013734, 1827217002, -1149514620, -946721760, -1657048579, 101597638, -682029291, 1308867399, 406591886, 1676587584, 769389722, 1834793556, -1841868625, -102677962, 2016941611, 1500671090, -2118752416, -1154931007, 1218498061, -1497347731, -1388097413, 1905084778, -1645193297, 1152499174, 88299228, -562238155, -719711349, 1644727497, 897778449, -915473246, 1752139500, -1904751768, 1675744952, -938502280, 2042925565, 457992178, 1919520125, 1580633137, -136749522, -1579988673, -589741250, -1989208750, 1271188090, -1496204556, -1515622964, 200248134, -1586889305, 1960788151, 1310754820, -1703582201, 59672520, 539041348, -1954884417, -968868043, 407429997, -2135052232, 509774108, 1681727751, -1090201864, 554249356, -163253367, 125321294, 2071506360, -1564136109, 1108703934, -1574617554, 2079585454, -2131389191, -1791912729, 2011927277, -1283364560, -628255946, -1086032791, -227699581, -294670635, 1899434549, -566075533, -1260019901, 2109615438, 758624645, 1239194211, -1732010600, 318884258, 949689279, 202922125, -1541291590, 2057537116, 1910539608, 1012726954, 2099485860, 43506141, -673437648, 1261928491, 1948822356, -1360133305, 1262467973, 1764699912, 323901326, 920248511, -1366597681, -306626865, 723985550, 386839023, 2110095318, 511053590, -1324128767, -2041701477, -672500967, 985166269, -811280529, -484714622, 230601833, -1413914527, 1399912541, -5210569, -634334981, -339118154, 194556943, 978128870, -548421013, 362607146, -1030170910, 729345898, 1638484672, -1420422777, 351183088, -552779420, 430928110};

    static void debug(String string) {
        ((PrintWriter)null).println(">>> MARS_Algorithm: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> MARS_Algorithm." + string);
        }
    }

    public static Object makeKey(byte[] byArray) throws InvalidKeyException {
        int n;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            throw new InvalidKeyException("Missing key material");
        }
        if (n2 % 4 != 0) {
            throw new InvalidKeyException("Key material != n*32 bits");
        }
        int n3 = n2 / 4;
        if (n3 < 4 || n3 > 39) {
            throw new InvalidKeyException("Illegal key length");
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4 / 4;
            nArray[n5] = nArray[n5] | (byArray[n4] & 0xFF) << n4 * 8;
            ++n4;
        }
        int[] nArray2 = new int[47];
        System.arraycopy(S, 0, nArray2, 0, 7);
        n4 = 0;
        while (n4 < 39) {
            n = nArray2[n4] ^ nArray2[n4 + 5];
            n = n << 3 | n >>> 29;
            nArray2[n4 + 7] = n ^ nArray[n4 % n3] ^ n4;
            ++n4;
        }
        nArray2[46] = n3;
        int n6 = 0;
        while (n6 < 7) {
            n4 = 8;
            while (n4 < 47) {
                n = nArray2[n4] + S[nArray2[n4 - 1] & 0x1FF];
                nArray2[n4] = n << 9 | n >>> 23;
                ++n4;
            }
            n = nArray2[7] + S[nArray2[46] & 0x1FF];
            nArray2[7] = n << 9 | n >>> 23;
            ++n6;
        }
        int[] nArray3 = new int[40];
        n4 = 0;
        while (n4 < 40) {
            nArray3[7 * n4 % 40] = nArray2[n4 + 7];
            ++n4;
        }
        n4 = 5;
        while (n4 < 36) {
            int n7;
            int n8 = nArray3[n4] | 3;
            int n9 = 0;
            int n10 = 0;
            int n11 = 1023;
            while (n10 < 23) {
                n7 = n8 & n11;
                if (n7 == 0 || n7 == n11) {
                    n9 |= n11;
                }
                ++n10;
                n11 <<= 1;
            }
            n7 = ~n8;
            n6 = nArray3[n4 + 3] & 0x1F;
            int n12 = S[265 + (nArray3[n4] & 3)];
            n12 = n12 << n6 | n12 >>> 32 - n6;
            nArray3[n4] = n8 ^ n12 & (n9 &= 0xFFFFFFFC & (n8 << 1 ^ n7) & (n8 >>> 1 ^ n7));
            n4 += 2;
        }
        return nArray3;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        int n2;
        int[] nArray = (int[])object;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n6 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        n3 += nArray[0];
        n4 += nArray[1];
        n5 += nArray[2];
        n6 += nArray[3];
        int n7 = 0;
        while (n7 < 8) {
            n4 ^= S[n3 & 0xFF];
            n4 += S[256 + (n3 >>> 8 & 0xFF)];
            n5 += S[n3 >>> 16 & 0xFF];
            n6 ^= S[256 + (n3 >>> 24 & 0xFF)];
            n3 = n3 >>> 24 | n3 << 8;
            switch (n7) {
                case 0: 
                case 4: {
                    n3 += n6;
                    break;
                }
                case 1: 
                case 5: {
                    n3 += n4;
                }
            }
            n2 = n3;
            n3 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2;
            ++n7;
        }
        n7 = 0;
        while (n7 < 16) {
            int[] nArray2 = MARS_Algorithm.E(n3, nArray[2 * n7 + 4], nArray[2 * n7 + 5]);
            n3 = n3 << 13 | n3 >>> 19;
            n5 += nArray2[1];
            if (n7 < 8) {
                n4 += nArray2[0];
                n6 ^= nArray2[2];
            } else {
                n6 += nArray2[0];
                n4 ^= nArray2[2];
            }
            n2 = n3;
            n3 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2;
            ++n7;
        }
        n7 = 0;
        while (n7 < 8) {
            switch (n7) {
                case 2: 
                case 6: {
                    n3 -= n6;
                    break;
                }
                case 3: 
                case 7: {
                    n3 -= n4;
                }
            }
            n6 -= S[256 + (n3 >>> 16 & 0xFF)];
            n2 = n3 = n3 << 24 | n3 >>> 8;
            n3 = n4 ^= S[256 + (n3 & 0xFF)];
            n4 = n5 -= S[n3 >>> 24 & 0xFF];
            n5 = n6 ^= S[n3 >>> 8 & 0xFF];
            n6 = n2;
            ++n7;
        }
        byte[] byArray2 = new byte[]{(byte)(n3 -= nArray[36]), (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24), (byte)(n4 -= nArray[37]), (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)(n5 -= nArray[38]), (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24), (byte)(n6 -= nArray[39]), (byte)(n6 >>> 8), (byte)(n6 >>> 16), (byte)(n6 >>> 24)};
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        int n2;
        int[] nArray = (int[])object;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n6 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        n3 += nArray[36];
        n4 += nArray[37];
        n5 += nArray[38];
        n6 += nArray[39];
        int n7 = 7;
        while (n7 >= 0) {
            n2 = n6;
            n6 = n5;
            n5 = n4;
            n4 = n3;
            n3 = n2;
            n3 = n3 >>> 24 | n3 << 8;
            n6 ^= S[n3 >>> 8 & 0xFF];
            n6 += S[256 + (n3 >>> 16 & 0xFF)];
            n5 += S[n3 >>> 24 & 0xFF];
            n4 ^= S[256 + (n3 & 0xFF)];
            switch (n7) {
                case 2: 
                case 6: {
                    n3 += n6;
                    break;
                }
                case 3: 
                case 7: {
                    n3 += n4;
                }
            }
            --n7;
        }
        n7 = 15;
        while (n7 >= 0) {
            n2 = n6;
            n6 = n5;
            n5 = n4;
            n4 = n3;
            n3 = n2;
            n3 = n3 >>> 13 | n3 << 19;
            int[] nArray2 = MARS_Algorithm.E(n3, nArray[2 * n7 + 4], nArray[2 * n7 + 5]);
            n5 -= nArray2[1];
            if (n7 < 8) {
                n4 -= nArray2[0];
                n6 ^= nArray2[2];
            } else {
                n6 -= nArray2[0];
                n4 ^= nArray2[2];
            }
            --n7;
        }
        n7 = 7;
        while (n7 >= 0) {
            n2 = n6;
            n6 = n5;
            n5 = n4;
            n4 = n3;
            n3 = n2;
            switch (n7) {
                case 0: 
                case 4: {
                    n3 -= n6;
                    break;
                }
                case 1: 
                case 5: {
                    n3 -= n4;
                }
            }
            n3 = n3 << 24 | n3 >>> 8;
            n6 ^= S[256 + (n3 >>> 24 & 0xFF)];
            n5 -= S[n3 >>> 16 & 0xFF];
            n4 -= S[256 + (n3 >>> 8 & 0xFF)];
            n4 ^= S[n3 & 0xFF];
            --n7;
        }
        byte[] byArray2 = new byte[]{(byte)(n3 -= nArray[0]), (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24), (byte)(n4 -= nArray[1]), (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)(n5 -= nArray[2]), (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24), (byte)(n6 -= nArray[3]), (byte)(n6 >>> 8), (byte)(n6 >>> 16), (byte)(n6 >>> 24)};
        return byArray2;
    }

    public static boolean self_test() {
        return MARS_Algorithm.self_test(16);
    }

    private static final int[] E(int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = (n << 13 | n >>> 19) * n3;
        int n6 = n4 & 0x1FF;
        int n7 = S[n6];
        n5 = n5 << 5 | n5 >>> 27;
        int n8 = n5 & 0x1F;
        n4 = n4 << n8 | n4 >>> 32 - n8;
        n7 ^= n5;
        n5 = n5 << 5 | n5 >>> 27;
        n7 ^= n5;
        n8 = n5 & 0x1F;
        n7 = n7 << n8 | n7 >>> 32 - n8;
        return new int[]{n7, n4, n5};
    }

    public static int blockSize() {
        return 16;
    }

    private static boolean self_test(int n) {
        boolean bl = false;
        try {
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[16];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)n2;
                ++n2;
            }
            n2 = 0;
            while (n2 < 16) {
                byArray2[n2] = (byte)n2;
                ++n2;
            }
            Object object = MARS_Algorithm.makeKey(byArray);
            byte[] byArray3 = MARS_Algorithm.blockEncrypt(byArray2, 0, object);
            byte[] byArray4 = MARS_Algorithm.blockDecrypt(byArray3, 0, object);
            bl = MARS_Algorithm.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static String intToString(int n) {
        char[] cArray = new char[8];
        int n2 = 7;
        while (n2 >= 0) {
            cArray[n2] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    private static String toString(byte[] byArray) {
        return MARS_Algorithm.toString(byArray, 0, byArray.length);
    }

    private static String toString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byte by = byArray[n++];
            cArray[n4++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n4++] = HEX_DIGITS[by & 0xF];
            ++n3;
        }
        return new String(cArray);
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        MARS_Algorithm.self_test(16);
        MARS_Algorithm.self_test(24);
        MARS_Algorithm.self_test(32);
    }
}

