/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import java.io.File;
import java.io.OutputStream;
import java.util.Vector;
import sun.tools.javac.Main;

public final class CompileKit {
    private static final String NAME = "CompileKit";
    private static final String NL = System.getProperty("line.separator");
    private static final String VERSION = "$Revision: 1.0$";
    private static final String COPYRIGHT = "Copyright (c) 1998 Systemics Ltd. on behalf of" + NL + "the Cryptix Development Team.  All rights reserved.";
    private static final String ID = "Cryptix AES-Kit javac tool" + NL + "$Revision: 1.0$" + NL + COPYRIGHT;
    private int exitValue;
    private boolean mute = true;
    private boolean optimal = false;
    private String dirName;
    private String algorithm;
    private File dir;

    public static final void main(String[] args) {
        System.out.println(String.valueOf(ID) + NL + NL);
        CompileKit cmd = new CompileKit();
        cmd.run(args);
    }

    private boolean run(String[] args) {
        long time = System.currentTimeMillis();
        if (!this.processOptions(args)) {
            return false;
        }
        this.notify("AES Candidate Algorithm: \"" + this.algorithm + "\"");
        this.notify("         Home directory: \"" + this.dir + "\"");
        try {
            this.dir = new File(this.dir, this.algorithm);
            Vector<String> argv = new Vector<String>();
            argv.addElement(this.optimal ? "-O" : "-g");
            argv.addElement("-deprecation");
            argv.addElement("-depend");
            argv.addElement("-d");
            argv.addElement(new File(this.dir, "classes").getAbsolutePath());
            this.dir = new File(this.dir, "src");
            String[] files = this.dir.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".java")) {
                    argv.addElement(new File(this.dir, files[i]).getAbsolutePath());
                }
                ++i;
            }
            args = new String[argv.size()];
            argv.copyInto(args);
            this.notify("About to invoke javac");
            if (!new Main((OutputStream)System.out, "javac").compile(args)) {
                throw new RuntimeException("Javac invocation failed");
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            this.error("Exception encountered: " + x.getMessage());
            return false;
        }
        this.notify("Java interpreter used: Version " + System.getProperty("java.version"));
        this.notify("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        this.notify("Total execution time (ms): " + (System.currentTimeMillis() - time));
        return true;
    }

    private boolean processOptions(String[] args) {
        int argc = args.length;
        if (argc == 0) {
            this.printHelp();
            return false;
        }
        System.out.println("(type \"java NIST.CompileKit\" with no arguments for help)" + NL + NL);
        int i = -1;
        String cmd = "";
        boolean next = true;
        while (true) {
            if (next) {
                if (++i >= argc) break;
                cmd = args[i];
            } else {
                cmd = "-" + cmd.substring(2);
            }
            if (cmd.startsWith("-v")) {
                this.mute = false;
                next = cmd.length() == 2;
                continue;
            }
            if (cmd.startsWith("-o")) {
                this.optimal = true;
                next = cmd.length() == 2;
                continue;
            }
            if (cmd.startsWith("-h")) {
                this.dirName = args[i + 1];
                ++i;
                next = true;
                continue;
            }
            this.algorithm = cmd;
        }
        if (this.algorithm == null) {
            this.error("Missing candidate Algorithm name");
            return false;
        }
        if (this.dirName == null) {
            this.dirName = System.getProperty("user.dir");
        }
        this.dir = new File(this.dirName);
        if (!this.dir.isDirectory()) {
            this.error("Source \"" + this.dir.getAbsolutePath() + "\" is not a directory");
            return false;
        }
        return true;
    }

    private void error(String s) {
        System.err.println(String.valueOf(NL) + "*** " + s + "...");
        this.exitValue = -1;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    private void notify(String s) {
        if (!this.mute) {
            System.out.println("CompileKit: " + s + "...");
        }
    }

    void printHelp() {
        System.out.println("NAME" + NL + "  " + NAME + ": Compiles a specified AES candidate algorithm source" + NL + "  code files." + NL + NL + "SYNTAX" + NL + "  java NIST." + NAME + NL + "    [ -v ]" + NL + "    [ -o ]" + NL + "    [ -h <home-directory>]" + NL + "    <algorithm>" + NL + NL + "DESCRIPTION" + NL + "  Invokes the javac command to compile all .java source files in a" + NL + "  designated directory according to the conventions of the AES-Kit." + NL + NL + "OPTIONS" + NL + "  -v   Verbose." + NL + NL + "  -o   Optimize compiled code." + NL + NL + "  -h <home-directory>" + NL + "       Pathname of the algorithm home directory containing the" + NL + "       'src' and 'classes' directories. If unspecified, the current" + NL + "       user directory is considered." + NL + NL + "  <algorithm>" + NL + "       Candidate algorithm name (<Foo> in the documentation)." + NL + NL + COPYRIGHT);
    }
}

