/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;

public final class InstallKit {
    private static final String NAME = "InstallKit";
    private static final String NL = System.getProperty("line.separator");
    private static final String VERSION = "$Revision: 1.0$";
    private static final String COPYRIGHT = "Copyright (c) 1998 Systemics Ltd. on behalf of" + NL + "the Cryptix Development Team.  All rights reserved.";
    private static final String ID = "Cryptix NIST-Kit template source code installer" + NL + "$Revision: 1.0$" + NL + COPYRIGHT;
    private int exitValue;
    private boolean mute = true;
    private boolean overWrite = false;
    private String srcDirName;
    private String destDirName;
    private String algorithm;
    private File srcDir;
    private File destDir;

    public static final void main(String[] args) {
        System.out.println(String.valueOf(ID) + NL + NL);
        InstallKit cmd = new InstallKit();
        cmd.run(args);
    }

    private boolean run(String[] args) {
        long time = System.currentTimeMillis();
        if (!this.processOptions(args)) {
            return false;
        }
        this.notify("AES Candidate Algorithm: \"" + this.algorithm + "\"");
        this.notify("     Template directory: \"" + this.srcDir + "\"");
        this.notify(" Installation directory: \"" + this.destDir + "\"");
        try {
            this.destDir = new File(this.destDir, this.algorithm);
            File dir = new File(this.destDir, "classes");
            dir.mkdirs();
            dir = new File(dir, this.algorithm);
            dir.mkdirs();
            File props = new File(this.srcDir, "XXX.properties");
            if (!props.exists()) {
                this.error("\"XXX.properties\" file not found. Check the -s argument.");
                return false;
            }
            if (!this.copyReplace(props, dir)) {
                return false;
            }
            this.srcDir = new File(this.srcDir, "src");
            this.destDir = new File(this.destDir, "src");
            String[] files = this.srcDir.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].startsWith("XXX") && !this.copyReplace(new File(this.srcDir, files[i]), this.destDir)) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            this.error("Exception encountered: " + x.getMessage());
            return false;
        }
        this.notify("Java interpreter used: Version " + System.getProperty("java.version"));
        this.notify("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        this.notify("Total execution time (ms): " + (System.currentTimeMillis() - time));
        return true;
    }

    private boolean processOptions(String[] args) {
        int argc = args.length;
        if (argc == 0) {
            this.printHelp();
            return false;
        }
        System.out.println("(type \"java NIST.InstallKit\" with no arguments for help)" + NL + NL);
        int i = -1;
        String cmd = "";
        boolean next = true;
        while (true) {
            if (next) {
                if (++i >= argc) break;
                cmd = args[i];
            } else {
                cmd = "-" + cmd.substring(2);
            }
            if (cmd.startsWith("-v")) {
                this.mute = false;
                next = cmd.length() == 2;
                continue;
            }
            if (cmd.startsWith("-f")) {
                this.overWrite = true;
                next = cmd.length() == 2;
                continue;
            }
            if (cmd.startsWith("-s")) {
                this.srcDirName = args[i + 1];
                ++i;
                next = true;
                continue;
            }
            if (cmd.startsWith("-d")) {
                this.destDirName = args[i + 1];
                ++i;
                next = true;
                continue;
            }
            this.algorithm = cmd;
        }
        if (this.algorithm == null) {
            this.error("Missing candidate Algorithm name");
            return false;
        }
        if (this.srcDirName == null) {
            this.srcDirName = System.getProperty("user.dir");
        }
        if (this.destDirName == null) {
            this.destDirName = System.getProperty("user.dir");
        }
        this.srcDir = new File(new File(this.srcDirName), "XXX");
        if (!this.srcDir.isDirectory()) {
            this.error("Source \"" + this.srcDir.getAbsolutePath() + "\" is not a directory");
            return false;
        }
        this.destDir = new File(this.destDirName);
        if (!this.destDir.isDirectory()) {
            this.error("Destination \"" + this.destDir.getAbsolutePath() + "\" is not a directory");
            return false;
        }
        return true;
    }

    private boolean copyReplace(File srcFile, File destDir) throws FileNotFoundException, IOException {
        String line;
        String destFileName = String.valueOf(this.algorithm) + srcFile.getName().substring(3);
        File destFile = new File(destDir, destFileName);
        if (destFile.exists() && !this.overWrite) {
            this.error("File \"" + destFile.getAbsolutePath() + "\" already exists");
            return false;
        }
        File parent = new File(destFile.getParent());
        if (parent != null) {
            parent.mkdirs();
        }
        File tmp = InstallKit.createTempFile("aes", destDir);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(srcFile));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(tmp)));
        while ((line = in.readLine()) != null) {
            out.println(InstallKit.replace(line, "XXX", this.algorithm));
        }
        if (out.checkError()) {
            this.notify("Error encountered while processing \"" + srcFile.getAbsolutePath() + "\"");
        }
        out.close();
        in.close();
        tmp.renameTo(destFile);
        this.notify("File \"" + srcFile.getAbsolutePath() + "\" processed");
        return true;
    }

    private static File createTempFile(String prefix, File destDir) {
        int x;
        File it;
        Random random = new Random();
        do {
            x = (int)(Math.abs(random.nextDouble()) * 1000000.0);
        } while ((it = new File(destDir, String.valueOf(prefix) + String.valueOf(x))).exists());
        return it;
    }

    private static String replace(String line, String oldToken, String newToken) {
        int end;
        int limit = line.length();
        int delta = oldToken.length();
        StringBuffer result = new StringBuffer(2 * limit);
        int start = 0;
        while (start < limit && (end = line.indexOf(oldToken, start)) != -1) {
            result.append(line.substring(start, end)).append(newToken);
            start = end + delta;
        }
        return start < limit ? result.append(line.substring(start)).toString() : result.toString();
    }

    private void error(String s) {
        System.err.println(String.valueOf(NL) + "*** " + s + "...");
        this.exitValue = -1;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    private void notify(String s) {
        if (!this.mute) {
            System.out.println("InstallKit: " + s + "...");
        }
    }

    void printHelp() {
        System.out.println("NAME" + NL + "  " + NAME + ": Installs the NIST-Kit template sources for a specified" + NL + "  candidate algorithm name." + NL + NL + "SYNTAX" + NL + "  java NIST." + NAME + NL + "    [ -v ]" + NL + "    [ -f ]" + NL + "    [ -s <source-directory>]" + NL + "    [ -d <destination-directory>]" + NL + "    <algorithm>" + NL + NL + "DESCRIPTION" + NL + "  Creates a new directory named after the candidate algorithm and" + NL + "  copies the template source files there, renaming them by replacing" + NL + "  the 'XXX' prefix with the algorithm's name." + NL + "  The contents of these files are also scaned and every occurence of" + NL + "  the token 'XXX' is replaced with <algorithm>." + NL + NL + "OPTIONS" + NL + "  -v   Verbose." + NL + NL + "  -f   Overwrite existing files and directoriues if already there." + NL + NL + "  -s <source-directory>" + NL + "       Pathname where the 'src' directory and the template source" + NL + "       files are located (<dir-1>/ in the documentation). If left" + NL + "       unspecified, the current user directory is considered." + NL + NL + "  -d <destination-directory>" + NL + "       Pathname where the new 'src' directory and the properly named" + NL + "       blank source files will be installed (<dir-2>/ in the" + NL + "       documentation). If left unspecified, the current user directory" + NL + "       is considered." + NL + NL + "  <algorithm>" + NL + "       Candidate algorithm name (<Foo> in the documentation)." + NL + NL + COPYRIGHT);
    }
}

