/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public final class MCT {
    static final String VERSION = "$Revision: 1.0$";
    static final String SUBMITTER = "<as stated on the submission cover sheet>";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    boolean ecb = false;
    boolean cbc = false;
    boolean encrypting = false;
    boolean decrypting = false;
    String dirName;
    String keylengths;
    String cipherName;
    File destination;
    int[] keys = new int[]{128, 192, 256};
    final String eeFileName = "ecb_e_m.txt";
    final String edFileName = "ecb_d_m.txt";
    final String ceFileName = "cbc_e_m.txt";
    final String cdFileName = "cbc_d_m.txt";
    long encBlocks;
    long decBlocks;
    long keyCount;
    Method makeKey;
    Method encrypt;
    Method decrypt;

    public static void main(String[] args) {
        System.out.println("NIST Monte-Carlo Tests data generator/exerciser\n$Revision: 1.0$\nCopyright (c) 1998 Systemics Ltd. on behalf of\nthe Cryptix Development Team.  All rights reserved.\n\n");
        MCT cmd = new MCT();
        cmd.processOptions(args);
        cmd.run();
    }

    void processOptions(String[] args) {
        int argc = args.length;
        if (argc == 0) {
            this.printUsage();
        }
        System.out.println("(type \"java NIST.MCT\" with no arguments for help)\n\n");
        int i = -1;
        String cmd = "";
        boolean next = true;
        while (true) {
            if (next) {
                if (++i >= argc) break;
                cmd = args[i];
            } else {
                cmd = "-" + cmd.substring(2);
            }
            if (cmd.startsWith("-e")) {
                this.ecb = true;
                this.cbc = false;
                next = cmd.length() == 2;
                continue;
            }
            if (cmd.startsWith("-c")) {
                this.ecb = false;
                this.cbc = true;
                next = cmd.length() == 2;
                continue;
            }
            if (cmd.startsWith("-E")) {
                this.encrypting = true;
                this.decrypting = false;
                next = cmd.length() == 2;
                continue;
            }
            if (cmd.startsWith("-D")) {
                this.encrypting = false;
                this.decrypting = true;
                next = cmd.length() == 2;
                continue;
            }
            if (cmd.startsWith("-l")) {
                this.keylengths = args[i + 1];
                ++i;
                next = true;
                continue;
            }
            if (cmd.startsWith("-d")) {
                this.dirName = args[i + 1];
                ++i;
                next = true;
                continue;
            }
            this.cipherName = cmd;
        }
        if (this.cipherName == null) {
            MCT.halt("Missing cipher algorithm name");
        }
        if (this.cipherName.length() > 1 && (this.cipherName.startsWith("\"") || this.cipherName.startsWith("'"))) {
            this.cipherName = this.cipherName.substring(2, this.cipherName.length() - 2);
        }
        if (this.keylengths != null) {
            int count = 0;
            int[] keystemp = new int[3];
            StringTokenizer st = new StringTokenizer(this.keylengths, ", \t\"");
            while (st.hasMoreTokens()) {
                int k = Integer.parseInt(st.nextToken());
                if (k <= 0) {
                    MCT.halt("Negative key length not allowed: " + k);
                }
                if (count == 3) {
                    MCT.halt("Only three key-length values are allowed.");
                }
                keystemp[count++] = k;
            }
            if (count != 0) {
                this.keys = new int[count];
                System.arraycopy(keystemp, 0, this.keys, 0, count);
            }
        }
        if (!this.ecb && !this.cbc) {
            this.cbc = true;
            this.ecb = true;
        }
        if (!this.encrypting && !this.decrypting) {
            this.decrypting = true;
            this.encrypting = true;
        }
        if (this.dirName == null) {
            this.dirName = System.getProperty("user.dir");
        }
        this.destination = new File(this.dirName);
        if (!this.destination.isDirectory()) {
            MCT.halt("Destination <" + this.destination.getName() + "> is not a directory");
        }
        String aes = String.valueOf(this.cipherName) + "." + this.cipherName + "_Algorithm";
        try {
            Class<?> algorithm = Class.forName(aes);
            Method[] methods = algorithm.getDeclaredMethods();
            i = 0;
            while (i < methods.length) {
                String name = methods[i].getName();
                int params = methods[i].getParameterTypes().length;
                if (name.equals("makeKey") && params == 1) {
                    this.makeKey = methods[i];
                } else if (name.equals("blockEncrypt") && params == 3) {
                    this.encrypt = methods[i];
                } else if (name.equals("blockDecrypt") && params == 3) {
                    this.decrypt = methods[i];
                }
                ++i;
            }
            if (this.makeKey == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.encrypt == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.decrypt == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            MCT.halt("Unable to find " + aes + " class");
        }
        catch (NoSuchMethodException x2) {
            MCT.halt("Unable to find " + aes + "." + x2.getMessage() + " method");
        }
    }

    static void halt(String s) {
        System.err.println("\n*** " + s + "...");
        System.exit(-1);
    }

    static void notify(String s) {
        System.out.println("MCT: " + s + "...");
    }

    void printUsage() {
        System.out.println("NAME\n  MCT: A Monte Carlo Tests data generator/exerciser for any AES\n  candidate cipher algorithm.\n\nSYNTAX\n  java NIST.MCT\n    [ -e | -c ]\n    [ -E | -D ]\n    [ -l <comma-separated-key-lengths>]\n    [ -d <output-directory>]\n    <cipher>\n\nDESCRIPTION\n  For a designated candidate AES block cipher algorithm, this command\n  generates and exercises Monte Carlo Tests data for both Encryption\n  and Decryption in Electronic Codebook (ECB) and Cipher Block Chaining\n  (CBC) modes.\n  MCT's output file format is in conformance with the layout described\n  in Section 4 of NIST's document \"Description of Known Answer Tests\n  and Monte Carlo Tests for Advanced Encryption Standard (AES) Candidate\n  Algorithm Submissions\" dated January 7, 1998.\n\nOPTIONS\n  -e   Generate test data for the cipher in ECB mode only.  By default\n       MCT generates both ECB and CBC test suites.\n\n  -c   Generate test data for the cipher in CBC mode only.  By default\n       MCT generates both ECB and CBC test suites.\n\n  -E   Generate Encryption data only for the cipher in one or both of\n       ECB and CBC modes depending on the first two switches.  By default\n       MCT generates both Encryption and Decryption data.\n\n  -D   Generate Decryption data only for the cipher in one or both of\n       ECB and CBC modes depending on the first two switches.  By default\n       MCT generates both Encryption and Decryption data.\n\n  -l <comma-separated-key-lengths>\n       Comma separated list (maximum of three) of key lengths to use\n       for the tests.  If omitted, the following three values are\n       assumed: 128, 192 and 256.\n\n  -d <output-directory>\n       Pathname of the directory where the output files: \"ecb_e_m.txt\",\n       \"ecb_d_m.txt\", \"cbc_e_m.txt\" and \"cbc_d_m.txt\" will be generated.\n       If this destination directory is not specified, those files will\n       be placed in the current user directory.\n\n  <cipher>\n       Cipher algorithm name.\n\nCOPYRIGHT\n  Copyright (c) 1998 Systemics Ltd. on behalf of\n  the Cryptix Development Team.  All rights reserved.\n");
        System.exit(0);
    }

    void run() {
        long time = System.currentTimeMillis();
        if (this.ecb) {
            if (this.encrypting) {
                this.ecbEncrypt("ecb_e_m.txt");
            }
            if (this.decrypting) {
                this.ecbDecrypt("ecb_d_m.txt");
            }
        }
        if (this.cbc) {
            if (this.encrypting) {
                this.cbcEncrypt("cbc_e_m.txt");
            }
            if (this.decrypting) {
                this.cbcDecrypt("cbc_d_m.txt");
            }
        }
        MCT.notify("Java interpreter used: Version " + System.getProperty("java.version"));
        MCT.notify("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        MCT.notify("Total execution time (ms): " + (System.currentTimeMillis() - time));
        MCT.notify("During this time, " + this.cipherName + ":");
        MCT.notify("  Encrypted " + this.encBlocks + " blocks");
        MCT.notify("  Decrypted " + this.decBlocks + " blocks");
        MCT.notify("  Created " + this.keyCount + " session keys");
    }

    void ecbEncrypt(String encName) {
        PrintWriter enc = null;
        File f1 = new File(this.destination, encName);
        try {
            enc = new PrintWriter((Writer)new FileWriter(f1), true);
        }
        catch (IOException x) {
            MCT.halt("Unable to initialize <" + encName + "> as a Writer:\n" + x.getMessage());
        }
        enc.println();
        enc.println("=========================");
        enc.println();
        enc.println("FILENAME:  \"" + encName + "\"");
        enc.println();
        enc.println("Electronic Codebook (ECB) Mode - ENCRYPTION");
        enc.println("Monte Carlo Test");
        enc.println();
        enc.println("Algorithm Name: " + this.cipherName);
        enc.println("Principal Submitter: <as stated on the submission cover sheet>");
        enc.println();
        try {
            int k = 0;
            while (k < this.keys.length) {
                this.ecbEncryptForKey(this.keys[k], enc);
                ++k;
            }
        }
        catch (Exception x) {
            MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + x.getMessage());
        }
        enc.println("==========");
        enc.close();
    }

    void ecbDecrypt(String decName) {
        PrintWriter dec = null;
        File f2 = new File(this.destination, decName);
        try {
            dec = new PrintWriter((Writer)new FileWriter(f2), true);
        }
        catch (IOException x) {
            MCT.halt("Unable to initialize <" + decName + "> as a Writer:\n" + x.getMessage());
        }
        dec.println();
        dec.println("=========================");
        dec.println();
        dec.println("FILENAME:  \"" + decName + "\"");
        dec.println();
        dec.println("Electronic Codebook (ECB) Mode - DECRYPTION");
        dec.println("Monte Carlo Test");
        dec.println();
        dec.println("Algorithm Name: " + this.cipherName);
        dec.println("Principal Submitter: <as stated on the submission cover sheet>");
        dec.println();
        try {
            int k = 0;
            while (k < this.keys.length) {
                this.ecbDecryptForKey(this.keys[k], dec);
                ++k;
            }
        }
        catch (Exception x) {
            MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + x.getMessage());
        }
        dec.println("==========");
        dec.close();
    }

    void ecbEncryptForKey(int keysize, PrintWriter enc) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in ECB-Encrypt mode (long); key size: " + keysize);
        enc.println("==========");
        enc.println();
        enc.println("KEYSIZE=" + keysize);
        enc.println();
        Object[] args = new Object[]{};
        int keylen = keysize / 8;
        byte[] keyMaterial = new byte[keylen];
        int SIZE = 16;
        byte[] pt = new byte[SIZE];
        int i = 0;
        while (i < 400) {
            int k;
            args = new Object[]{keyMaterial};
            Object skeys = this.makeKey.invoke(null, args);
            ++this.keyCount;
            enc.println("I=" + i);
            enc.println("KEY=" + MCT.toString(keyMaterial));
            enc.println("PT=" + MCT.toString(pt));
            args = new Object[]{pt, new Integer(0), skeys};
            byte[] ct_1 = (byte[])this.encrypt.invoke(null, args);
            ++this.encBlocks;
            int j = 1;
            while (j < 9999) {
                args[0] = ct_1;
                ct_1 = (byte[])this.encrypt.invoke(null, args);
                ++this.encBlocks;
                ++j;
            }
            args[0] = ct_1;
            pt = (byte[])this.encrypt.invoke(null, args);
            ++this.encBlocks;
            enc.println("CT=" + MCT.toString(pt));
            enc.println();
            j = 0;
            if (keylen > SIZE) {
                int count = keylen - SIZE;
                k = SIZE - count;
                while (j < count) {
                    int n = j++;
                    keyMaterial[n] = (byte)(keyMaterial[n] ^ ct_1[k++]);
                }
            }
            k = 0;
            while (j < keylen) {
                int n = j++;
                keyMaterial[n] = (byte)(keyMaterial[n] ^ pt[k++]);
            }
            ++i;
        }
    }

    void ecbDecryptForKey(int keysize, PrintWriter dec) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in ECB-Decrypt mode (long); key size: " + keysize);
        dec.println("==========");
        dec.println();
        dec.println("KEYSIZE=" + keysize);
        dec.println();
        Object[] args = new Object[]{};
        int keylen = keysize / 8;
        byte[] keyMaterial = new byte[keylen];
        int SIZE = 16;
        byte[] ct = new byte[SIZE];
        int i = 0;
        while (i < 400) {
            int k;
            args = new Object[]{keyMaterial};
            Object skeys = this.makeKey.invoke(null, args);
            ++this.keyCount;
            dec.println("I=" + i);
            dec.println("KEY=" + MCT.toString(keyMaterial));
            dec.println("CT=" + MCT.toString(ct));
            args = new Object[]{ct, new Integer(0), skeys};
            byte[] pt_1 = (byte[])this.decrypt.invoke(null, args);
            ++this.decBlocks;
            int j = 1;
            while (j < 9999) {
                args[0] = pt_1;
                pt_1 = (byte[])this.decrypt.invoke(null, args);
                ++this.decBlocks;
                ++j;
            }
            args[0] = pt_1;
            ct = (byte[])this.decrypt.invoke(null, args);
            ++this.decBlocks;
            dec.println("PT=" + MCT.toString(ct));
            dec.println();
            j = 0;
            if (keylen > SIZE) {
                int count = keylen - SIZE;
                k = SIZE - count;
                while (j < count) {
                    int n = j++;
                    keyMaterial[n] = (byte)(keyMaterial[n] ^ pt_1[k++]);
                }
            }
            k = 0;
            while (j < keylen) {
                int n = j++;
                keyMaterial[n] = (byte)(keyMaterial[n] ^ ct[k++]);
            }
            ++i;
        }
    }

    void cbcEncrypt(String encName) {
        PrintWriter pw = null;
        File f = new File(this.destination, encName);
        try {
            pw = new PrintWriter((Writer)new FileWriter(f), true);
        }
        catch (IOException x) {
            MCT.halt("Unable to initialize <" + encName + "> as a Writer:\n" + x.getMessage());
        }
        pw.println();
        pw.println("=========================");
        pw.println();
        pw.println("FILENAME:  \"" + encName + "\"");
        pw.println();
        pw.println("Cipher Block Chaining (CBC) Mode - ENCRYPTION");
        pw.println("Monte Carlo Test");
        pw.println();
        pw.println("Algorithm Name: " + this.cipherName);
        pw.println("Principal Submitter: <as stated on the submission cover sheet>");
        pw.println();
        try {
            int k = 0;
            while (k < this.keys.length) {
                this.cbcEncryptForKey(this.keys[k], pw);
                ++k;
            }
        }
        catch (Exception x) {
            MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + x.getMessage());
        }
        pw.println("==========");
        pw.close();
    }

    void cbcDecrypt(String decName) {
        PrintWriter pw = null;
        File f = new File(this.destination, decName);
        try {
            pw = new PrintWriter((Writer)new FileWriter(f), true);
        }
        catch (IOException x) {
            MCT.halt("Unable to initialize <" + decName + "> as a Writer:\n" + x.getMessage());
        }
        pw.println();
        pw.println("=========================");
        pw.println();
        pw.println("FILENAME:  \"" + decName + "\"");
        pw.println();
        pw.println("Cipher Block Chaining (CBC) Mode - DECRYPTION");
        pw.println("Monte Carlo Test");
        pw.println();
        pw.println("Algorithm Name: " + this.cipherName);
        pw.println("Principal Submitter: <as stated on the submission cover sheet>");
        pw.println();
        try {
            int k = 128;
            while (k < 257) {
                this.cbcDecryptForKey(k, pw);
                k += 64;
            }
        }
        catch (Exception x) {
            MCT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + x.getMessage());
        }
        pw.println("==========");
        pw.close();
    }

    void cbcEncryptForKey(int keysize, PrintWriter pw) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in CBC-Encrypt mode (long); key size: " + keysize);
        pw.println("==========");
        pw.println();
        pw.println("KEYSIZE=" + keysize);
        pw.println();
        Object[] args = new Object[]{};
        int keylen = keysize / 8;
        byte[] keyMaterial = new byte[keylen];
        int SIZE = 16;
        byte[] pt = new byte[SIZE];
        byte[] ct = new byte[SIZE];
        byte[] iv = new byte[SIZE];
        System.arraycopy(iv, 0, ct, 0, SIZE);
        int i = 0;
        while (i < 400) {
            int k;
            pw.println("I=" + i);
            pw.println("KEY=" + MCT.toString(keyMaterial));
            pw.println("IV=" + MCT.toString(iv));
            pw.println("PT=" + MCT.toString(pt));
            args = new Object[]{keyMaterial};
            Object skeys = this.makeKey.invoke(null, args);
            ++this.keyCount;
            args = new Object[3];
            args[1] = new Integer(0);
            args[2] = skeys;
            int j = 0;
            while (j < 10000) {
                k = 0;
                while (k < SIZE) {
                    int n = k;
                    iv[n] = (byte)(iv[n] ^ pt[k]);
                    ++k;
                }
                System.arraycopy(ct, 0, pt, 0, SIZE);
                args[0] = iv;
                ct = (byte[])this.encrypt.invoke(null, args);
                ++this.encBlocks;
                System.arraycopy(ct, 0, iv, 0, SIZE);
                ++j;
            }
            pw.println("CT=" + MCT.toString(ct));
            pw.println();
            j = 0;
            if (keylen > SIZE) {
                int count = keylen - SIZE;
                k = SIZE - count;
                while (j < count) {
                    int n = j++;
                    keyMaterial[n] = (byte)(keyMaterial[n] ^ pt[k++]);
                }
            }
            k = 0;
            while (j < keylen) {
                int n = j++;
                keyMaterial[n] = (byte)(keyMaterial[n] ^ ct[k++]);
            }
            ++i;
        }
    }

    void cbcDecryptForKey(int keysize, PrintWriter pw) throws IllegalAccessException, InvocationTargetException {
        MCT.notify("Processing MCT in CBC-Decrypt mode (long); key size: " + keysize);
        pw.println("==========");
        pw.println();
        pw.println("KEYSIZE=" + keysize);
        pw.println();
        Object[] args = new Object[]{};
        int keylen = keysize / 8;
        byte[] keyMaterial = new byte[keylen];
        int SIZE = 16;
        byte[] pt = new byte[SIZE];
        byte[] ct = new byte[SIZE];
        byte[] iv = new byte[SIZE];
        int i = 0;
        while (i < 400) {
            int k;
            pw.println("I=" + i);
            pw.println("KEY=" + MCT.toString(keyMaterial));
            pw.println("IV=" + MCT.toString(iv));
            pw.println("CT=" + MCT.toString(ct));
            args = new Object[]{keyMaterial};
            Object skeys = this.makeKey.invoke(null, args);
            ++this.keyCount;
            args = new Object[3];
            args[1] = new Integer(0);
            args[2] = skeys;
            int j = 0;
            while (j < 10000) {
                args[0] = ct;
                pt = (byte[])this.decrypt.invoke(null, args);
                ++this.decBlocks;
                k = 0;
                while (k < SIZE) {
                    int n = k;
                    pt[n] = (byte)(pt[n] ^ iv[k]);
                    ++k;
                }
                System.arraycopy(ct, 0, iv, 0, SIZE);
                System.arraycopy(pt, 0, ct, 0, SIZE);
                ++j;
            }
            pw.println("PT=" + MCT.toString(pt));
            pw.println();
            j = 0;
            if (keylen > SIZE) {
                int count = keylen - SIZE;
                k = SIZE - count;
                while (j < count) {
                    int n = j++;
                    keyMaterial[n] = (byte)(keyMaterial[n] ^ iv[k++]);
                }
            }
            k = 0;
            while (j < keylen) {
                int n = j++;
                keyMaterial[n] = (byte)(keyMaterial[n] ^ pt[k++]);
            }
            ++i;
        }
    }

    private static String toString(byte[] ba) {
        int length = ba.length;
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }
}

